<!-- SEO Meta Content -->
@push('meta')
    <meta name="title" content="{{ $page->meta_title }}" />

    <meta name="description" content="{{ $page->meta_description }}" />

    <meta name="keywords" content="{{ $page->meta_keywords }}" />
@endPush

<!-- Page Layout -->
<x-shop::layouts>
    <!-- Page Title -->
    <x-slot:title>
        {{ $page->meta_title }}
    </x-slot>

    <!-- Page Content -->
    <div class="container mt-8 px-[60px] max-lg:px-8 container-cmspages">
        <h1 class="tittle_heading">{!! $page->page_title !!}</h1>
       @if($page->id!=12) <div class="mt-4"> {!! $page->html_content !!}</div> @endif
 @if($page->id==12)
        <!-- Loop over the theme customization -->
    @foreach ($customizations as $customization)
        @php ($data = $customization->options) @endphp

        <!-- Static content -->
        @switch ($customization->type)
            

             @case ($customization::TRUSTEDBRANDS_CAROUSEL)
                <!-- Image Carousel -->
                <x-shop::carousel.trustedbrandspage :options="$data" aria-label="Our Trusted Brands Carousel" />

                @break

           
        @endswitch
    @endforeach @endif
    </div>
</x-shop::layouts>