@props(['options'])

<v-carouselourbrandpage :count="8" :images="{{ json_encode($options['images'] ?? []) }}">
    <div class="overflow-hidden">
        <div class="shimmer aspect-[2.743/1] max-h-screen w-screen"></div>
    </div>
</v-carouselourbrandpage>

@pushOnce('scripts')
    <script
        type="text/x-template"
        id="v-carouselourbrandpage-template"
    >


    <div class="page-brands mt-4 flex gap-6 justify-items-center-">
 
           
                 <div class="our_brands_list_page our_brands_list justify-items-center"
                    v-for="(image, index) in images"
                    @click="visitLink(image)"
                    ref="slide"
                ><a :href="image.link">
                    <x-shop::media.images.lazy
                        class=""
                        ::lazy="false"
                        ::src="image.image.replace('storage', '/public/storage')"
                        ::srcset="image.image.replace('storage', '/public/storage') + ' 1920w, ' + image.image.replace('storage', '/public/cache/large') + ' 1280w,' + image.image.replace('storage', '/public/cache/medium') + ' 1024w, ' + image.image.replace('storage', '/public/cache/small') + ' 525w'"
                        ::alt="image?.title"
                        tabindex="0"
                        fetchpriority="high"
                    /></a>
                </div>
                
               
          
        </div>


        
    </script>

    <script type="module">
        app.component("v-carouselourbrandpage", {
            template: '#v-carouselourbrandpage-template',

            props: ['images'],

            data() {
                return {
                    isLoading: true,

                    categories: [],

                    offset: 323,
                };
            },

            mounted() {
                this.getCategories();
            },

            methods: {
                getCategories() {
                    this.$axios.get(this.src)
                        .then(response => {
                            this.isLoading = false;

                            this.categories = response.data.data;
                            console.log(response.data.data);
                        }).catch(error => {
                            console.log(error);
                        });
                },

                swipeLeft() {
                    const container = this.$refs.swiperContainer;

                    container.scrollLeft -= this.offset;
                },

                swipeRight() {
                    const container = this.$refs.swiperContainer;

                    container.scrollLeft += this.offset;
                },
            },
        });
    </script>

   
@endpushOnce