<v-categories-brandfilter
    src="{{ $src }}"
    title="{{ $title }}"
    navigation-link="{{ $navigationLink ?? '' }}"
>
    <x-shop::shimmer.categories.carousel
        :count="8"
        :navigation-link="$navigationLink ?? false"
    />
</v-categories-brandfilter>



@pushOnce('scripts')
    <script
        type="text/x-template"
        id="v-categories-brandfilter-template"
    >

    <section class="vehicle-search" v-if="! isLoading && categories?.length">
        <div class="container">
          <h2>Search by Vehicle</h2>
          <form class="vehicle-search-form" id="filterformhome" action="{{ url('/all-products') }}" method="get">
            <select onchange="filtercategory()" id="maker_select">
              <option value="">Select Maker</option>
              <option v-for="category in categories" :value="category.slug" v-text="category.name"></option>
            </select>
            <select id="model_select" onchange="filtersubcategory()" >
              <option value="">Select Model</option>
            </select>
            <select name="year" id="year_select" >
              <option value="">Select Year</option>
              <option v-for="yearval in years" :value="yearval.id" v-text="yearval.label"></option>
             
            </select>
            <button type="submit">Search</button>
          </form>
        </div>
      </section>
    
        <!-- Category Carousel Shimmer -->
        <template v-if="isLoading">
            <x-shop::shimmer.categories.carousel
                :count="8"
                :navigation-link="$navigationLink ?? false"
            />
        </template>
    </script>

    <script type="module">
        app.component('v-categories-brandfilter', {
            template: '#v-categories-brandfilter-template',

            props: [
                'src',
                'title',
                'navigationLink',
            ],

            data() {
                return {
                    isLoading: true,
                    categories: [],
                    years: [],
                    offset: 323,
                };
            },

            mounted() {
                this.getCategoriesbrand();
            },

            methods: {
                getCategoriesbrand() {
                    this.$axios.get(this.src)
                        .then(response => {
                            this.isLoading = false;
                            this.categories = response.data.data.categoryall;
                            this.years = response.data.data.year;
                           // console.log(this.years);
                        }).catch(error => {
                            console.log(error);
                        });
                },

                swipeLeft() {
                    const container = this.$refs.swiperContainer;

                    container.scrollLeft -= this.offset;
                },

                swipeRight() {
                    const container = this.$refs.swiperContainer;

                    container.scrollLeft += this.offset;
                },
            },
        });
    </script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>  
    
        function filtercategory() {
                const selectElement = document.getElementById("maker_select");
                const selectedValue = selectElement.value;
                var formElement = document.getElementById("filterformhome");
               // console.log("Selected value:", selectedValue);
                if(selectedValue){
                    $.ajax({
                        url: '{{ route("get-subcate") }}?brand='+selectedValue,
                        type: 'GET',
                        dataType: 'json',
                        success: function(response) {
                            //console.log(response.data);
                            $('#model_select').html(response.data);
                            formElement.action = response.action;
                        },
                        error: function(xhr) {
                            alert('Error fetching data.');
                        }
                    });
                    
                }else{
                     formElement.action = ((selectedValuebrand) ? "/public/"+selectedValuebrand : "{{ url('/all-products') }}");
                }
        }
        function filtersubcategory() {

                const selectElementbrand = document.getElementById("maker_select");
                const selectedValuebrand = selectElementbrand.value;

                const selectElement = document.getElementById("model_select");
                const selectedValue = selectElement.value;
                var formElement = document.getElementById("filterformhome");
               // console.log("Selected value:", selectedValue);
                if(selectedValue){
                    $.ajax({
                        url: '{{ route("get-subcate") }}?brand='+selectedValue,
                        type: 'GET',
                        dataType: 'json',
                        success: function(response) {
                            //console.log(response.data);
                            //$('#model_select').html(response.data);
                            formElement.action = response.action;
                        },
                        error: function(xhr) {
                            alert('Error fetching data.');
                        }
                    });
                    
                }else{
                    formElement.action = ((selectedValuebrand) ? "/public/"+selectedValuebrand : "{{ url('/all-products') }}");
                }
        }
        
        
       
  
        </script>
@endPushOnce
