<v-categories-home
    src="{{ $src }}"
    title="{{ $title }}"
    navigation-link="{{ $navigationLink ?? '' }}"
>
    <x-shop::shimmer.categories.carousel
        :count="8"
        :navigation-link="$navigationLink ?? false"
    />
</v-categories-home>



@pushOnce('scripts')
    <script
        type="text/x-template"
        id="v-categories-home-template"
    >
    <div class="category-search"  v-if="! isLoading && categories?.length">
        <div class="container">
          <h2>Search by Category</h2>
          <div class="category-grid">
             
          <a  v-for="category in categories"
                            :href="category.slug"
                            class="category-item"
                            :aria-label="category.name"
                        >
                           <div class="category-icon"> <x-shop::media.images.lazy
                                ::src="category.logo?.original_image_url || '{{ bagisto_asset('images/small-product-placeholder.webp') }}'"
                                width="110"
                                height="110"
                                class="w-full rounded-full- max-sm:h-[60px] max-sm:w-[60px]"
                                ::alt="category.name"
                            /></div>
                        
                            <h3
                                v-text="category.name"
                            >
                            </h3>
                        </a>

            
          </div>
          <a href="#" class="view-all-btn">View All</a>
        </div>
      </div>
        <!-- Category Carousel Shimmer -->
        <template v-if="isLoading">
            <x-shop::shimmer.categories.carousel
                :count="8"
                :navigation-link="$navigationLink ?? false"
            />
        </template>
    </script>

    <script type="module">
        app.component('v-categories-home', {
            template: '#v-categories-home-template',

            props: [
                'src',
                'title',
                'navigationLink',
            ],

            data() {
                return {
                    isLoading: true,

                    categories: [],

                    offset: 323,
                };
            },

            mounted() {
                this.getCategories();
            },

            methods: {
                getCategories() {
                    this.$axios.get(this.src)
                        .then(response => {
                            this.isLoading = false;

                            this.categories = response.data.data;
                            console.log(response.data.data);
                        }).catch(error => {
                            console.log(error);
                        });
                },

                swipeLeft() {
                    const container = this.$refs.swiperContainer;

                    container.scrollLeft -= this.offset;
                },

                swipeRight() {
                    const container = this.$refs.swiperContainer;

                    container.scrollLeft += this.offset;
                },
            },
        });
    </script>
@endPushOnce
