<!-- Page Layout -->
<x-shop::layouts>
    <!-- Page Title -->
    <x-slot:title>
        @lang('shop::app.home.contact.title')
    </x-slot>

    <div class="container mt-8 max-1180:px-5 max-md:mt-6 max-md:px-4">

    <div class="flex justify-center- max-lg:hidden"><div class="mt-[34px] flex justify-start max-lg:hidden"><div class="flex items-center gap-x-3.5"><nav aria-label=""><ol class="flex breadcrumb_ol"><li class="flex items-center gap-x-2.5 text-base font-medium"><a href="/"> Home </a><span class="icon-arrow-right rtl:icon-arrow-left text-xl"></span></li><li class="flex items-center gap-x-2.5 text-base text-zinc-500 after:content-['/'] after:last:hidden ltr:ml-2.5 rtl:mr-0" aria-current="page">  @lang('shop::app.home.contact.title') </li></ol></nav></div></div></div>
        <!-- Form Container -->
		<div class="m-auto w-full max-md:px-8-- max-md:py-8- max-sm:border-none- max-sm:p-0- mt-4">
			<h1 class="font-semibold text-4xl max-md:text-3xl max-sm:text-xl">
                @lang('shop::app.home.contact.title')
            </h1>

			<p class="mt-4 text-xl text-zinc-500 max-sm:mt-1 max-sm:text-sm">
                <img class="w-full" src="{{ asset('themes/shop/cheval/images/contact_us.jpg') }}">
            </p>

            <div class="mt-14 max-sm:mt-8">
                <!-- Contact Form -->
                <x-shop::form class="contact_us_form" :action="route('shop.home.contact_us.send_mail')">
                    <!-- Name -->
                    <x-shop::form.control-group>
                        <x-shop::form.control-group.label class="required">
                            @lang('shop::app.home.contact.name')
                        </x-shop::form.control-group.label>

                        <x-shop::form.control-group.control
                            type="text"
                            class="px-6 py-5 max-md:py-3 max-sm:py-3.5"
                            name="name"
                            rules="required"
                            :value="old('name')"
                            :label="trans('shop::app.home.contact.name')"
                            :placeholder="trans('shop::app.home.contact.name')"
                            :aria-label="trans('shop::app.home.contact.name')"
                            aria-required="true"
                        />

                        <x-shop::form.control-group.error control-name="name" />
                    </x-shop::form.control-group>

                    <!-- Email -->
                    <x-shop::form.control-group>
                        <x-shop::form.control-group.label class="required">
                            @lang('shop::app.home.contact.email')
                        </x-shop::form.control-group.label>

                        <x-shop::form.control-group.control
                            type="email"
                            class="px-6 py-5 max-md:py-3 max-sm:py-3.5"
                            name="email"
                            rules="required|email"
                            :value="old('email')"
                            :label="trans('shop::app.home.contact.email')"
                            :placeholder="trans('shop::app.home.contact.email')"
                            :aria-label="trans('shop::app.home.contact.email')"
                            aria-required="true"
                        />

                        <x-shop::form.control-group.error control-name="email" />
                    </x-shop::form.control-group>

                    <!-- Contact -->
                    <x-shop::form.control-group>
                        <x-shop::form.control-group.label>
                            @lang('shop::app.home.contact.phone-number')
                        </x-shop::form.control-group.label>

                        <x-shop::form.control-group.control
                            type="text"
                            class="px-6 py-5 max-md:py-3 max-sm:py-3.5"
                            name="contact"
                            rules="phone"
                            :value="old('contact')"
                            :label="trans('shop::app.home.contact.phone-number')"
                            :placeholder="trans('shop::app.home.contact.phone-number')"
                            :aria-label="trans('shop::app.home.contact.phone-number')"
                        />

                        <x-shop::form.control-group.error control-name="contact" />
                    </x-shop::form.control-group>



                    <!-- subject -->
                    <x-shop::form.control-group>
                        <x-shop::form.control-group.label class="required">
                             @lang('shop::app.home.contact.help_subject')
                        </x-shop::form.control-group.label>

                        <x-shop::form.control-group.control
                            type="text"
                            class="px-6 py-5 max-md:py-3 max-sm:py-3.5"
                            name="subject"
                            rules="required"
                            :value="old('subject')"
                            :label="trans('shop::app.home.contact.help_subject')"
                            :placeholder="trans('shop::app.home.contact.help_subject')"
                            :aria-label="trans('shop::app.home.contact.help_subject')"
                            aria-required="true"
                        />

                        <x-shop::form.control-group.error control-name="subject" />
                    </x-shop::form.control-group>

                    <!-- Message -->
                    <x-shop::form.control-group>
                        <x-shop::form.control-group.label class="required">
                            @lang('shop::app.home.contact.desc')
                        </x-shop::form.control-group.label>

                        <x-shop::form.control-group.control
                            type="textarea"
                            class="px-6 py-5 max-md:py-3 max-sm:py-3.5"
                            name="message"
                            rules="required"
                            :label="trans('shop::app.home.contact.message')"
                            :placeholder="trans('shop::app.home.contact.describe-here')"
                            :aria-label="trans('shop::app.home.contact.message')"
                            aria-required="true"
                            rows="4"
                        />

                        <x-shop::form.control-group.error control-name="message" />
                    </x-shop::form.control-group>

                    <!-- Recaptcha -->
                    @if (core()->getConfigData('customer.captcha.credentials.status'))
                        <div class="mb-5 flex">
                            {!! Captcha::render() !!}
                        </div>
                    @endif

                    <!-- Submit Button -->
                    <div class="mt-0 flex flex-wrap w-full items-center gap-9 max-sm:justify-center max-sm:text-center">
                        <button
                            class="secondary-button m-auto mx-auto block w-full max-w-[374px] rounded-2xl px-11 py-4 text-center text-base max-md:max-w-full max-md:rounded-lg max-md:py-3 max-sm:py-1.5 "
                            type="submit"
                        >
                            @lang('shop::app.home.contact.submit')
                        </button>
                    </div>
                </x-shop::form>
            </div>

            <div class="mt-14 max-sm:mt-8 contact_footer_area">
                <div class="flex w-full justify-center">
                <div class="flex flex-wrap w-full items-center justify-center p-4 border_px">
                    <img src="{{ asset('themes/shop/cheval/images/location.svg') }}">
                    <div><label>Location</label><p>Dubai - Marina</p></div>
                </div>
                <div class="flex flex-wrap w-full items-center justify-center p-4 border_px">
                    <img src="{{ asset('themes/shop/cheval/images/contact_call.svg') }}">
                    <div><label>Location</label><a href="tel:+971505050501">+971 505 050 5010</a></div>
                </div>
                <div class="flex flex-wrap w-full items-center justify-center p-4">
                    <img src="{{ asset('themes/shop/cheval/images/contact_message.svg') }}">
                    <div><label>Location</label><a href="mailto:autovault@gmail.com">autovault@gmail.com</a></div>
                </div>
            </div> </div>
		</div>
    </div>

    @push('scripts')
        {!! Captcha::renderJS() !!}
    @endpush
</x-shop::layouts>