<?php

return [
    'users' => [
        'sessions' => [
            'email'                => 'Endereço de Email',
            'forget-password-link' => 'Esqueceu a Senha?',
            'password'             => 'Senha',
            'submit-btn'           => 'Entrar',
            'title'                => 'Entrar',
        ],

        'forget-password' => [
            'create' => [
                'email'           => 'Email Registrado',
                'email-not-exist' => 'Email não Existe',
                'page-title'      => 'Esqueceu a Senha',
                'reset-link-sent' => 'Link de Redefinição de Senha enviado',
                'sign-in-link'    => 'Voltar para Entrar?',
                'submit-btn'      => 'Redefinir',
                'title'           => 'Recuperar Senha',
            ],
        ],

        'reset-password' => [
            'back-link-title'  => 'Voltar para Entrar?',
            'confirm-password' => 'Confirmar Senha',
            'email'            => 'Email Registrado',
            'password'         => 'Senha',
            'submit-btn'       => 'Redefinir Senha',
            'title'            => 'Redefinir Senha',
        ],
    ],

    'notifications' => [
        'description-text' => 'Listar todas as notificações',
        'marked-success'   => 'Notificação Marcada com Sucesso',
        'no-record'        => 'Nenhum Registro Encontrado',
        'of'               => 'de',
        'per-page'         => 'Por página',
        'read-all'         => 'Marcar como Lido',
        'title'            => 'Notificações',
        'view-all'         => 'Ver Todas',

        'order-status-messages' => [
            'all'             => 'Todos',
            'canceled'        => 'Pedido Cancelado',
            'closed'          => 'Pedido Fechado',
            'completed'       => 'Pedido Concluído',
            'pending'         => 'Pedido Pendente',
            'pending-payment' => 'Pagamento Pendente',
            'processing'      => 'Pedido em Processamento',
        ],
    ],

    'account' => [
        'edit' => [
            'back-btn'          => 'Voltar',
            'change-password'   => 'Alterar Senha',
            'confirm-password'  => 'Confirmar Senha',
            'current-password'  => 'Senha Atual',
            'email'             => 'Email',
            'general'           => 'Geral',
            'invalid-password'  => 'A senha atual que você digitou está incorreta.',
            'name'              => 'Nome',
            'password'          => 'Senha',
            'profile-image'     => 'Imagem de Perfil',
            'save-btn'          => 'Salvar Conta',
            'title'             => 'Minha Conta',
            'update-success'    => 'Conta atualizada com sucesso',
            'upload-image-info' => 'Faça o upload de uma imagem de perfil (110px X 110px) em formato PNG ou JPG',
        ],
    ],

    'dashboard' => [
        'index' => [
            'add-customer'                => 'Adicionar Cliente',
            'add-product'                 => 'Adicionar Produto',
            'all-channels'                => 'Todos os Canais',
            'attribute-code'              => 'Código do Atributo',
            'average-sale'                => 'Média de Vendas por Pedido',
            'color'                       => 'Cor',
            'customer-info'               => 'Nenhum Cliente Encontrado com Mais Vendas',
            'customer-with-most-sales'    => 'Cliente com Mais Vendas',
            'date-duration'               => ':start - :end',
            'decreased'                   => ':progress%',
            'empty-threshold'             => 'Limiar de Vazio',
            'empty-threshold-description' => 'Não há produtos disponíveis',
            'end-date'                    => 'Data de Término',
            'from'                        => 'De',
            'increased'                   => ':progress%',
            'more-products'               => ':product_count+ Mais Imagens',
            'order'                       => ':total_orders Pedidos',
            'order-count'                 => ':count Pedidos',
            'order-id'                    => '#:id',
            'overall-details'             => 'Detalhes Gerais',
            'pay-by'                      => 'Pagamento por - :method',
            'product-count'               => ':count Produtos',
            'product-image'               => 'Imagem do Produto',
            'product-info'                => 'Adicione produtos relacionados enquanto está em movimento.',
            'product-number'              => 'Produto - :product_number',
            'revenue'                     => 'Receita :total',
            'sale-count'                  => ':count Vendas',
            'sales'                       => 'Vendas',
            'sku'                         => 'SKU - :sku',
            'start-date'                  => 'Data de Início',
            'stock-threshold'             => 'Limite de Estoque',
            'store-stats'                 => 'Estatísticas da Loja',
            'title'                       => 'Painel de Controle',
            'to'                          => 'Para',
            'today-customers'             => 'Clientes de Hoje',
            'today-details'               => 'Detalhes de Hoje',
            'today-orders'                => 'Pedidos de Hoje',
            'today-sales'                 => 'Vendas de Hoje',
            'top-performing-categories'   => 'Categorias Mais Populares',
            'top-selling-products'        => 'Produtos Mais Vendidos',
            'total-customers'             => 'Total de Clientes',
            'total-orders'                => 'Total de Pedidos',
            'total-sales'                 => 'Total de Vendas',
            'total-stock'                 => ':total_stock Estoque',
            'total-unpaid-invoices'       => 'Total de Faturas Não Pagas',
            'unique-visitors'             => ':count Único',
            'user-info'                   => 'Revise rapidamente o que está acontecendo em sua loja',
            'user-name'                   => 'Oi, :user_name!',
            'visitors'                    => 'Visitante',
        ],
    ],

    'sales' => [
        'orders' => [
            'index' => [
                'create-btn' => 'Criar Pedido',
                'title'      => 'Pedidos',

                'search-customer' => [
                    'create-btn'  => 'Criar Cliente',
                    'empty-info'  => 'Nenhum cliente disponível para o termo de pesquisa.',
                    'empty-title' => 'Nenhum cliente encontrado',
                    'search-by'   => 'Pesquisar por email ou nome',
                    'title'       => 'Selecionar Cliente',
                ],

                'datagrid' => [
                    'canceled'        => 'Cancelado',
                    'channel-name'    => 'Canal',
                    'closed'          => 'Fechado',
                    'completed'       => 'Concluído',
                    'customer'        => 'Cliente',
                    'date'            => 'Data',
                    'email'           => 'Email',
                    'fraud'           => 'Fraude',
                    'grand-total'     => 'Total Geral',
                    'id'              => '#:id',
                    'items'           => 'Itens',
                    'location'        => 'Localização',
                    'order-id'        => 'ID do Pedido',
                    'pay-by'          => 'Pagar Por - :method',
                    'pay-via'         => 'Pagar Via',
                    'pending-payment' => 'Pagamento Pendente',
                    'pending'         => 'Pendente',
                    'processing'      => 'Processando',
                    'product-count'   => ':count + Mais produtos',
                    'status'          => 'Status',
                    'success'         => 'Sucesso',
                    'view'            => 'Visualizar',
                ],
            ],

            'create' => [
                'add-to-cart'             => 'Adicionar ao Carrinho',
                'back-btn'                => 'Voltar',
                'check-billing-address'   => 'Endereço de cobrança está faltando.',
                'check-shipping-address'  => 'Endereço de entrega está faltando.',
                'configuration'           => 'Configuração',
                'coupon-already-applied'  => 'Código do cupom já aplicado.',
                'coupon-applied'          => 'Código do cupom aplicado com sucesso.',
                'coupon-error'            => 'Não foi possível aplicar o código do cupom.',
                'coupon-not-found'        => 'Cupom não encontrado',
                'coupon-remove'           => 'Código do cupom removido com sucesso.',
                'error'                   => 'Algo deu errado',
                'minimum-order-error'     => 'O valor mínimo do pedido não foi atingido.',
                'order-placed-success'    => 'Pedido realizado com sucesso.',
                'payment-not-supported'   => 'Este método de pagamento não é suportado',
                'save-btn'                => 'Criar Pedido',
                'specify-payment-method'  => 'Método de pagamento está faltando.',
                'specify-shipping-method' => 'Método de entrega está faltando.',
                'title'                   => 'Criar Pedido para :name',

                'types' => [
                    'configurable' => [
                        'select-options' => 'Por favor, selecione uma opção',
                    ],

                    'bundle' => [
                        'none'         => 'Nenhum',
                        'total-amount' => 'Valor Total',
                    ],

                    'grouped' => [
                        'name' => 'Nome',
                    ],

                    'downloadable' => [
                        'title' => 'Links',
                    ],
                ],

                'cart' => [
                    'success-add-to-cart' => 'Produto adicionado ao carrinho com sucesso',
                    'success-remove'      => 'Item removido do carrinho com sucesso',
                    'success-update'      => 'Item do carrinho atualizado com sucesso',

                    'items' => [
                        'add-product'       => 'Adicionar Produto',
                        'amount-per-unit'   => ':amount Por Unidade x :qty Quantidade',
                        'delete'            => 'Excluir',
                        'empty-description' => 'Nenhum item encontrado no seu carrinho.',
                        'empty-title'       => 'Carrinho Vazio',
                        'excl-tax'          => 'Escl. IVA',
                        'move-to-wishlist'  => 'Mover para a Lista de Desejos',
                        'see-details'       => 'Ver Detalhes',
                        'sku'               => 'SKU - :sku',
                        'sub-total'         => 'Subtotal - :sub_total',
                        'title'             => 'Itens do Carrinho',

                        'search' => [
                            'add-to-cart'   => 'Adicionar ao Carrinho',
                            'available-qty' => ':qty Disponível',
                            'empty-info'    => 'Nenhum produto disponível para o termo de pesquisa.',
                            'empty-title'   => 'Nenhum produto encontrado',
                            'product-image' => 'Imagem do Produto',
                            'qty'           => 'Quantidade',
                            'sku'           => 'SKU - :sku',
                            'title'         => 'Pesquisar Produtos',
                        ],
                    ],

                    'address' => [
                        'add-btn'          => 'Adicionar Endereço',
                        'add-new'          => 'Adicionar novo endereço',
                        'add-new-address'  => 'Adicionar novo endereço',
                        'addresses'        => 'Endereços',
                        'back'             => 'Voltar',
                        'billing-address'  => 'Endereço de Cobrança',
                        'city'             => 'Cidade',
                        'company-name'     => 'Nome da Empresa',
                        'confirm'          => 'Confirmar',
                        'country'          => 'País',
                        'edit-btn'         => 'Editar Endereço',
                        'email'            => 'Email',
                        'first-name'       => 'Nome',
                        'last-name'        => 'Sobrenome',
                        'postcode'         => 'CEP',
                        'proceed'          => 'Continuar',
                        'same-as-billing'  => 'Usar o mesmo endereço para entrega?',
                        'save'             => 'Salvar',
                        'save-address'     => 'Salvar este endereço',
                        'select-country'   => 'Selecionar País',
                        'select-state'     => 'Selecionar Estado',
                        'shipping-address' => 'Endereço de Entrega',
                        'state'            => 'Estado',
                        'street-address'   => 'Endereço',
                        'telephone'        => 'Telefone',
                        'title'            => 'Endereço',
                        'vat-id'           => 'NIF',
                    ],

                    'payment' => [
                        'title' => 'Pagamento',
                    ],

                    'shipping' => [
                        'title' => 'Entrega',
                    ],

                    'summary' => [
                        'apply-coupon'             => 'Applica Coupon',
                        'discount-amount'          => 'Importo Sconto',
                        'enter-your-code'          => 'Inserisci il tuo codice',
                        'grand-total'              => 'Totale',
                        'place-order'              => 'Effettua Ordine',
                        'processing'               => 'Elaborazione',
                        'shipping-amount-excl-tax' => 'Importo Spedizione (Escl. IVA)',
                        'shipping-amount-incl-tax' => 'Importo Spedizione (Incl. IVA)',
                        'shipping-amount'          => 'Importo Spedizione',
                        'sub-total-excl-tax'       => 'Subtotale (Escl. IVA)',
                        'sub-total-incl-tax'       => 'Subtotale (Incl. IVA)',
                        'sub-total'                => 'Subtotale',
                        'tax'                      => 'IVA',
                        'title'                    => 'Riepilogo Ordine',
                    ],
                ],

                'cart-items' => [
                    'add-to-cart'       => 'Adicionar ao Carrinho',
                    'delete'            => 'Excluir',
                    'empty-description' => 'Nenhum item encontrado no seu carrinho.',
                    'empty-title'       => 'Carrinho Vazio',
                    'excl-tax'          => 'Escl. IVA',
                    'see-details'       => 'Ver Detalhes',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Itens do Carrinho',
                ],

                'recent-order-items' => [
                    'add-to-cart'       => 'Adicionar ao Carrinho',
                    'empty-description' => 'Nenhum item encontrado nos seus pedidos recentes.',
                    'empty-title'       => 'Pedidos Vazios',
                    'see-details'       => 'Ver Detalhes',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Itens dos Pedidos Recentes',
                    'view'              => 'Visualizar',
                ],

                'wishlist-items' => [
                    'add-to-cart'       => 'Adicionar ao Carrinho',
                    'delete'            => 'Excluir',
                    'empty-description' => 'Nenhum item encontrado na sua lista de desejos.',
                    'empty-title'       => 'Itens da Lista de Desejos Vazios',
                    'see-details'       => 'Ver Detalhes',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Itens da Lista de Desejos',
                ],

                'compare-items' => [
                    'add-to-cart'       => 'Adicionar ao Carrinho',
                    'delete'            => 'Excluir',
                    'empty-description' => 'Nenhum item encontrado na sua lista de comparação.',
                    'empty-title'       => 'Itens da Lista de Comparação Vazios',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Itens da Lista de Comparação',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount Per Unità x :qty Quantità',
                'billing-address'                => 'Indirizzo di Fatturazione',
                'cancel'                         => 'Annulla',
                'cancel-msg'                     => 'Sei sicuro di voler annullare questo ordine',
                'cancel-success'                 => 'Ordine annullato con successo',
                'canceled'                       => 'Annullato',
                'channel'                        => 'Canale',
                'closed'                         => 'Chiuso',
                'comment-success'                => 'Commento aggiunto con successo.',
                'comments'                       => 'Commenti',
                'completed'                      => 'Completato',
                'contact'                        => 'Contatto',
                'create-success'                 => 'Ordine creato con successo',
                'currency'                       => 'Valuta',
                'customer'                       => 'Cliente',
                'customer-group'                 => 'Gruppo Cliente',
                'customer-not-notified'          => ':date | Cliente <b>Non Notificato</b>',
                'customer-notified'              => ':date | Cliente <b>Notificato</b>',
                'discount'                       => 'Sconto - :discount',
                'download-pdf'                   => 'Scarica PDF',
                'fraud'                          => 'Frode',
                'grand-total'                    => 'Totale - :grand_total',
                'invoice-id'                     => 'Fattura #:invoice',
                'invoices'                       => 'Fatture',
                'item-canceled'                  => 'Annullato (:qty_canceled)',
                'item-invoice'                   => 'Fatturato (:qty_invoiced)',
                'item-ordered'                   => 'Ordinato (:qty_ordered)',
                'item-refunded'                  => 'Rimborsato (:qty_refunded)',
                'item-shipped'                   => 'Spedito (:qty_shipped)',
                'name'                           => 'Nome',
                'no-invoice-found'               => 'Nessuna Fattura Trovata',
                'no-refund-found'                => 'Nessun Rimborso Trovato',
                'no-shipment-found'              => 'Nessuna Spedizione Trovata',
                'notify-customer'                => 'Notifica Cliente',
                'order-date'                     => 'Data Ordine',
                'order-information'              => 'Informazioni Ordine',
                'order-status'                   => 'Stato Ordine',
                'payment-and-shipping'           => 'Pagamento e Spedizione',
                'payment-method'                 => 'Metodo di Pagamento',
                'pending'                        => 'In Attesa',
                'pending_payment'                => 'Pagamento in Sospeso',
                'per-unit'                       => 'Per Unità',
                'price'                          => 'Prezzo - :price',
                'price-excl-tax'                 => 'Prezzo (Escl. Tasse) - :price',
                'price-incl-tax'                 => 'Prezzo (Incl. Tasse) - :price',
                'processing'                     => 'In Elaborazione',
                'quantity'                       => 'Quantità',
                'refund'                         => 'Rimborso',
                'refund-id'                      => 'Rimborso #:refund',
                'refunded'                       => 'Rimborsato',
                'reorder'                        => 'Riordina',
                'ship'                           => 'Spedisci',
                'shipment'                       => 'Spedizione #:shipment',
                'shipments'                      => 'Spedizioni',
                'shipping-address'               => 'Indirizzo di Spedizione',
                'shipping-and-handling'          => 'Spedizione e Gestione',
                'shipping-and-handling-excl-tax' => 'Spedizione e Gestione (Escl. Tasse)',
                'shipping-and-handling-incl-tax' => 'Spedizione e Gestione (Incl. Tasse)',
                'shipping-method'                => 'Metodo di Spedizione',
                'shipping-price'                 => 'Prezzo Spedizione',
                'sku'                            => 'SKU - :sku',
                'status'                         => 'Stato',
                'sub-total'                      => 'Sub Totale - :sub_total',
                'sub-total-excl-tax'             => 'Sub Totale (Escl. Tasse) - :sub_total',
                'sub-total-incl-tax'             => 'Sub Totale (Incl. Tasse) - :sub_total',
                'submit-comment'                 => 'Invia Commento',
                'summary-discount'               => 'Sconto',
                'summary-grand-total'            => 'Totale',
                'summary-sub-total'              => 'Sub Totale',
                'summary-sub-total-excl-tax'     => 'Sub Totale (Escl. Tasse)',
                'summary-sub-total-incl-tax'     => 'Sub Totale (Incl. Tasse)',
                'summary-tax'                    => 'Tasse',
                'tax'                            => 'Tasse (:percent) - :tax',
                'title'                          => 'Ordine #:order_id',
                'total-due'                      => 'Totale Dovuto',
                'total-paid'                     => 'Totale Pagato',
                'total-refund'                   => 'Totale Rimborso',
                'view'                           => 'Visualizza',
                'write-your-comment'             => 'Scrivi il tuo commento',
            ],
        ],

        'shipments' => [
            'index' => [
                'title' => 'Remessas',

                'datagrid' => [
                    'id'               => 'ID',
                    'inventory-source' => 'Fonte de Estoque',
                    'order-date'       => 'Data do Pedido',
                    'order-id'         => 'ID do Pedido',
                    'shipment-date'    => 'Data da Remessa',
                    'shipment-to'      => 'Enviar Para',
                    'total-qty'        => 'Quantidade Total',
                    'view'             => 'Visualizar',
                ],
            ],

            'create' => [
                'amount-per-unit'  => ':amount Por Unidade x :qty Quantidade',
                'cancel-error'     => 'Pedido não pode ser cancelado',
                'carrier-name'     => 'Nome da Transportadora',
                'create-btn'       => 'Criar Remessa',
                'creation-error'   => 'Erro na criação da Remessa',
                'item-canceled'    => 'Cancelado (:qty_canceled)',
                'item-invoice'     => 'Faturado (:qty_invoiced)',
                'item-ordered'     => 'Pedido (:qty_ordered)',
                'item-refunded'    => 'Reembolsado (:qty_refunded)',
                'item-shipped'     => 'Enviado (:qty_shipped)',
                'order-error'      => 'A Remessa não é válida',
                'per-unit'         => 'Por Unidade',
                'qty-available'    => 'Qtde. Disponível',
                'qty-to-ship'      => 'Qtde. para Envio',
                'quantity-invalid' => 'Qtde. Inválida',
                'sku'              => 'SKU - :sku',
                'source'           => 'Fonte',
                'success'          => 'Remessa criada com sucesso',
                'title'            => 'Criar nova Remessa',
                'tracking-number'  => 'Número de Rastreamento',
            ],

            'view' => [
                'billing-address'      => 'Endereço de Cobrança',
                'carrier-title'        => 'Título da Transportadora',
                'channel'              => 'Canal',
                'currency'             => 'Moeda',
                'customer'             => 'Cliente',
                'email'                => 'Email - :email',
                'inventory-source'     => 'Fonte de Estoque',
                'order-date'           => 'Data do Pedido',
                'order-id'             => 'ID do Pedido',
                'order-information'    => 'Informações do Pedido',
                'order-status'         => 'Status do Pedido',
                'ordered-items'        => 'Itens Pedidos',
                'payment-and-shipping' => 'Pagamento e Envio',
                'payment-method'       => 'Método de Pagamento',
                'product-image'        => 'Imagem do Produto',
                'qty'                  => 'Quantidade - :qty',
                'shipping-address'     => 'Endereço de Envio',
                'shipping-method'      => 'Método de Envio',
                'shipping-price'       => 'Preço de Envio',
                'sku'                  => 'SKU - :sku ',
                'title'                => 'Remessa #:shipment_id',
                'tracking-number'      => 'Número de Rastreamento',
            ],
        ],

        'refunds' => [
            'index' => [
                'title' => 'Reembolsos',

                'datagrid' => [
                    'billed-to'       => 'Cobrado Para',
                    'id'              => 'ID',
                    'order-id'        => 'ID do Pedido',
                    'refund-date'     => 'Data do Reembolso',
                    'refunded-amount' => 'Montante Reembolsado',
                    'view'            => 'Visualizar',
                ],
            ],

            'view' => [
                'account-information'        => 'Informazioni Account',
                'adjustment-fee'             => 'Commissione di Adeguamento',
                'adjustment-refund'          => 'Rimborso di Adeguamento',
                'base-discounted-amount'     => 'Importo Scontato - :base_discounted_amount',
                'billing-address'            => 'Indirizzo di Fatturazione',
                'currency'                   => 'Valuta',
                'sub-total-amount-excl-tax'  => 'Subtotale (Escl. Tasse) - :discounted_amount',
                'sub-total-amount-incl-tax'  => 'Subtotale (Incl. Tasse) - :discounted_amount',
                'sub-total-amount'           => 'Subtotale - :discounted_amount',
                'grand-total'                => 'Totale Generale',
                'order-channel'              => 'Canale Ordine',
                'order-date'                 => 'Data Ordine',
                'order-id'                   => 'ID Ordine',
                'order-information'          => 'Informazioni Ordine',
                'order-status'               => 'Stato Ordine',
                'payment-information'        => 'Informazioni Pagamento',
                'payment-method'             => 'Metodo di Pagamento',
                'price-excl-tax'             => 'Prezzo (Escl. Tasse) - :price',
                'price-incl-tax'             => 'Prezzo (Incl. Tasse) - :price',
                'price'                      => 'Prezzo - :price',
                'product-image'              => 'Immagine Prodotto',
                'product-ordered'            => 'Prodotti Ordinati',
                'qty'                        => 'Quantità - :qty',
                'refund'                     => 'Rimborso',
                'shipping-address'           => 'Indirizzo di Spedizione',
                'shipping-handling-excl-tax' => 'Spedizione e Gestione (Escl. Tasse)',
                'shipping-handling-incl-tax' => 'Spedizione e Gestione (Incl. Tasse)',
                'shipping-handling'          => 'Spedizione e Gestione',
                'shipping-method'            => 'Metodo di Spedizione',
                'shipping-price'             => 'Costo Spedizione',
                'sku'                        => 'SKU - :sku',
                'sub-total-excl-tax'         => 'Subtotale (Escl. Tasse)',
                'sub-total-incl-tax'         => 'Subtotale (Incl. Tasse)',
                'sub-total'                  => 'Subtotale',
                'tax'                        => 'Tasse',
                'tax-amount'                 => 'Importo Tasse - :tax_amount',
                'title'                      => 'Rimborso #:refund_id',
            ],

            'create' => [
                'adjustment-fee'              => 'Taxa de Ajuste',
                'adjustment-refund'           => 'Reembolso de Ajuste',
                'amount-per-unit'             => ':amount Por Unidade x :qty Quantidade',
                'create-success'              => 'Reembolso criado com sucesso',
                'creation-error'              => 'A criação de reembolsos não é permitida.',
                'discount-amount'             => 'Valor do Desconto',
                'grand-total'                 => 'Total Geral',
                'invalid-qty'                 => 'Encontramos uma quantidade inválida para faturar itens.',
                'invalid-refund-amount-error' => 'O valor do reembolso deve ser diferente de zero.',
                'item-canceled'               => 'Cancelado (:qty_canceled)',
                'item-invoice'                => 'Faturado (:qty_invoiced)',
                'item-ordered'                => 'Pedido (:qty_ordered)',
                'item-refunded'               => 'Reembolsado (:qty_refunded)',
                'item-shipped'                => 'Enviado (:qty_shipped)',
                'per-unit'                    => 'Por Unidade',
                'price'                       => 'Preço',
                'qty-to-refund'               => 'Qtd Para Reembolso',
                'refund-btn'                  => 'Reembolsar',
                'refund-limit-error'          => 'O Valor do Reembolso :amount não pode ser processado.',
                'refund-shipping'             => 'Reembolso do Envio',
                'sku'                         => 'SKU - :sku',
                'subtotal'                    => 'Subtotal',
                'tax-amount'                  => 'Valor do Imposto',
                'title'                       => 'Criar Reembolso',
                'update-totals-btn'           => 'Atualizar Totais',
            ],
        ],

        'invoices' => [
            'index' => [
                'title' => 'Faturas',

                'datagrid' => [
                    'action'       => 'Ações',
                    'grand-total'  => 'Total Geral',
                    'id'           => 'ID',
                    'invoice-date' => 'Data da Fatura',
                    'order-id'     => 'ID do Pedido',
                    'overdue'      => 'Atrasada',
                    'paid'         => 'Paga',
                    'pending'      => 'Pendente',
                    'status'       => 'Status',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount Per Unità x :qty Quantità',
                'channel'                        => 'Canale',
                'customer-email'                 => 'Email - :email',
                'customer'                       => 'Cliente',
                'discount'                       => 'Importo Sconto - :discount',
                'email'                          => 'Email',
                'grand-total'                    => 'Totale Generale',
                'invoice-items'                  => 'Voci Fattura',
                'invoice-sent'                   => 'Fattura inviata con successo',
                'invoice-status'                 => 'Stato Fattura',
                'order-date'                     => 'Data Ordine',
                'order-id'                       => 'ID Ordine',
                'order-information'              => 'Informazioni Ordine',
                'order-status'                   => 'Stato Ordine',
                'price-excl-tax'                 => 'Prezzo (Escl. Tasse) - :price',
                'price-incl-tax'                 => 'Prezzo (Incl. Tasse) - :price',
                'price'                          => 'Prezzo - :price',
                'print'                          => 'Stampa',
                'product-image'                  => 'Immagine Prodotto',
                'qty'                            => 'Quantità - :qty',
                'send-btn'                       => 'Invia',
                'send-duplicate-invoice'         => 'Invia Fattura Duplicata',
                'send'                           => 'Invia',
                'shipping-and-handling-excl-tax' => 'Spedizione e Gestione (Escl. Tasse)',
                'shipping-and-handling-incl-tax' => 'Spedizione e Gestione (Incl. Tasse)',
                'shipping-and-handling'          => 'Spedizione e Gestione',
                'sku'                            => 'SKU - :sku',
                'sub-total-excl-tax'             => 'Subtotale (Escl. Tasse) - :sub_total',
                'sub-total-incl-tax'             => 'Subtotale (Incl. Tasse) - :sub_total',
                'sub-total-summary-excl-tax'     => 'Subtotale (Escl. Tasse)',
                'sub-total-summary-incl-tax'     => 'Subtotale (Incl. Tasse)',
                'sub-total-summary'              => 'Subtotale',
                'sub-total'                      => 'Subtotale - :sub_total',
                'summary-discount'               => 'Importo Sconto',
                'summary-tax'                    => 'Importo Tasse',
                'tax'                            => 'Importo Tasse - :tax',
                'title'                          => 'Fattura #:invoice_id',
            ],

            'create' => [
                'amount-per-unit'    => ':amount Por Unidade x :qty Quantidade',
                'create-invoice'     => 'Criar Fatura',
                'create-success'     => 'Fatura criada com sucesso',
                'create-transaction' => 'Criar Transação',
                'creation-error'     => 'Não é permitida a criação de fatura de pedido.',
                'invalid-qty'        => 'Encontramos uma quantidade inválida para faturar os itens.',
                'invoice'            => 'Fatura',
                'new-invoice'        => 'Nova Fatura',
                'product-error'      => 'Não é possível criar uma fatura sem produtos.',
                'product-image'      => 'Imagem do Produto',
                'qty-to-invoiced'    => 'Quantidade a faturar',
                'sku'                => 'SKU - :sku',
            ],

            'invoice-pdf' => [
                'bank-details'               => 'Dettagli Bancari',
                'bill-to'                    => 'Fatturato a',
                'contact-number'             => 'Numero di Contatto',
                'contact'                    => 'Contatto',
                'date'                       => 'Data Fattura',
                'discount'                   => 'Sconto',
                'excl-tax'                   => 'Escl. Tasse:',
                'grand-total'                => 'Totale Generale',
                'invoice-id'                 => 'ID Fattura',
                'invoice'                    => 'Fattura',
                'order-date'                 => 'Data Ordine',
                'order-id'                   => 'ID Ordine',
                'payment-method'             => 'Metodo di Pagamento',
                'payment-terms'              => 'Termini di Pagamento',
                'price'                      => 'Prezzo',
                'product-name'               => 'Nome Prodotto',
                'qty'                        => 'Quantità',
                'ship-to'                    => 'Spedisci a',
                'shipping-handling-excl-tax' => 'Spedizione e Gestione (Escl. Tasse)',
                'shipping-handling-incl-tax' => 'Spedizione e Gestione (Incl. Tasse)',
                'shipping-handling'          => 'Spedizione e Gestione',
                'shipping-method'            => 'Metodo di Spedizione',
                'sku'                        => 'SKU',
                'subtotal-excl-tax'          => 'Subtotale (Escl. Tasse)',
                'subtotal-incl-tax'          => 'Subtotale (Incl. Tasse)',
                'subtotal'                   => 'Subtotale',
                'tax-amount'                 => 'Importo Imposta',
                'tax'                        => 'Imposta',
                'vat-number'                 => 'Numero di Partita IVA',
            ],
        ],

        'invoice-transaction' => [
            'id'               => 'ID',
            'transaction-date' => 'Data da Transação',
            'transaction-id'   => 'ID da Transação',
            'view'             => 'Visualizar',
        ],

        'transactions' => [
            'index' => [
                'create-btn' => 'Criar Transações',
                'title'      => 'Transações',

                'datagrid' => [
                    'completed'          => 'Concluído',
                    'id'                 => 'ID',
                    'invoice-id'         => 'ID da fatura',
                    'order-id'           => 'ID do pedido',
                    'paid'               => 'Pago',
                    'pending'            => 'Pendente',
                    'status'             => 'Status',
                    'transaction-amount' => 'Valor da transação',
                    'transaction-date'   => 'Data da transação',
                    'transaction-id'     => 'ID da transação',
                    'view'               => 'Ver',
                ],

                'create' => [
                    'already-paid'               => 'Já pago',
                    'amount'                     => 'Valor',
                    'create-transaction'         => 'Criar Transação',
                    'invoice-id'                 => 'ID da Fatura',
                    'invoice-missing'            => 'Fatura Ausente',
                    'payment-method'             => 'Método de Pagamento',
                    'save-transaction'           => 'Salvar Transação',
                    'transaction-amount-exceeds' => 'Valor da Transação excede',
                    'transaction-amount-zero'    => 'Valor da Transação zero',
                    'transaction-saved'          => 'Transação salva com sucesso.',
                ],

                'view' => [
                    'amount'           => 'Valor',
                    'created-at'       => 'Criado em',
                    'invoice-id'       => 'ID da Fatura',
                    'order-id'         => 'ID do Pedido',
                    'payment-details'  => 'Detalhes do Pagamento',
                    'payment-method'   => 'Método de Pagamento',
                    'status'           => 'Status',
                    'title'            => 'Detalhes da Transação',
                    'transaction-data' => 'Dados da Transação',
                    'transaction-id'   => 'ID da Transação',
                ],
            ],
        ],
    ],

    'catalog' => [
        'products' => [
            'index' => [
                'already-taken' => ':name já foi utilizado.',
                'create-btn'    => 'Criar Produto',
                'title'         => 'Produtos',

                'create' => [
                    'back-btn'                => 'Voltar',
                    'configurable-attributes' => 'Atributos Configuráveis',
                    'create-btn'              => 'Criar Produto',
                    'family'                  => 'Família',
                    'save-btn'                => 'Salvar Produto',
                    'sku'                     => 'SKU',
                    'title'                   => 'Criar Novo Produto',
                    'type'                    => 'Tipo',
                ],

                'datagrid' => [
                    'active'                 => 'Ativo',
                    'attribute-family'       => 'Família de Atributos',
                    'attribute-family-value' => 'Família de Atributos - :attribute_family',
                    'category'               => 'Categoria',
                    'channel'                => 'Canal',
                    'copy-of'                => 'Cópia de :value',
                    'copy-of-slug'           => 'cópia-de-:value',
                    'delete'                 => 'Excluir',
                    'disable'                => 'Desativar',
                    'id'                     => 'ID',
                    'id-value'               => 'ID - :id',
                    'image'                  => 'Imagem',
                    'mass-delete-success'    => 'Produtos Selecionados Excluídos com Sucesso',
                    'mass-update-success'    => 'Produtos Selecionados Atualizados com Sucesso',
                    'name'                   => 'Nome',
                    'out-of-stock'           => 'Fora de Estoque',
                    'price'                  => 'Preço',
                    'product-image'          => 'Imagem do Produto',
                    'qty'                    => 'Quantidade',
                    'qty-value'              => ':qty Disponíveis',
                    'sku'                    => 'SKU',
                    'sku-value'              => 'SKU - :sku',
                    'status'                 => 'Status',
                    'type'                   => 'Tipo',
                    'update-status'          => 'Atualizar Status',
                ],
            ],

            'edit' => [
                'preview'  => 'Visualização',
                'remove'   => 'Remover',
                'save-btn' => 'Salvar Produto',
                'title'    => 'Editar Produto',

                'channels' => [
                    'title' => 'Canais',
                ],

                'price' => [
                    'group' => [
                        'add-group-price'           => 'Adicionar Preço de Grupo',
                        'all-groups'                => 'Todos os grupos',
                        'create-btn'                => 'Adicionar Novo',
                        'discount-group-price-info' => 'Para :qty Quantidade com desconto de :price',
                        'edit-btn'                  => 'Editar',
                        'empty-info'                => 'Preços especiais para clientes que pertencem a um grupo específico.',
                        'fixed-group-price-info'    => 'Para :qty Quantidade a preço fixo de :price',
                        'title'                     => 'Preço do Grupo de Clientes',

                        'create' => [
                            'all-groups'     => 'Todos os grupos',
                            'create-title'   => 'Criar Preço do Grupo de Clientes',
                            'customer-group' => 'Grupo de Clientes',
                            'delete-btn'     => 'Excluir',
                            'discount'       => 'Desconto',
                            'fixed'          => 'Fixo',
                            'price'          => 'Preço',
                            'price-type'     => 'Tipo de Preço',
                            'qty'            => 'Quantidade mínima',
                            'save-btn'       => 'Salvar',
                            'update-title'   => 'Atualizar Preço do Grupo de Clientes',
                        ],
                    ],
                ],

                'inventories' => [
                    'pending-ordered-qty'      => 'Quantidade Pendente Encomendada: :qty',
                    'pending-ordered-qty-info' => 'A quantidade pendente encomendada será deduzida da fonte de inventário correspondente após o envio. Em caso de cancelamento, a quantidade pendente estará disponível para venda.',
                    'title'                    => 'Inventários',
                ],

                'categories' => [
                    'title' => 'Categorias',
                ],

                'images' => [
                    'info'  => 'A resolução da imagem deve ser de cerca de 560px X 609px',
                    'title' => 'Imagens',
                ],

                'videos' => [
                    'error' => 'O :attribute não pode ser maior que :max kilobytes. Por favor, escolha um arquivo menor.',
                    'title' => 'Vídeos',
                    'info'  => 'O tamanho máximo do vídeo deve ser como :size',
                ],

                'links' => [
                    'related-products' => [
                        'empty-info' => 'Adicione produtos relacionados enquanto está em movimento.',
                        'info'       => 'Além do produto que o cliente está visualizando, são apresentados produtos relacionados.',
                        'title'      => 'Produtos Relacionados',
                    ],

                    'up-sells' => [
                        'empty-info' => 'Adicione produtos de venda adicional enquanto estiver em movimento.',
                        'info'       => 'O cliente é apresentado com produtos para venda cruzada, que servem como uma alternativa premium ou de maior qualidade ao produto que estão visualizando atualmente.',
                        'title'      => 'Produtos para Venda Cruzada',
                    ],

                    'cross-sells' => [
                        'empty-info' => 'Adicione produtos de venda cruzada enquanto está em movimento.',
                        'info'       => 'Ao lado do carrinho de compras, você encontrará esses produtos de "compra por impulso" posicionados como vendas cruzadas para complementar os itens já adicionados ao seu carrinho.',
                        'title'      => 'Produtos de Venda Cruzada',
                    ],

                    'add-btn'           => 'Adicionar Produto',
                    'delete'            => 'Excluir',
                    'empty-info'        => 'Para adicionar produtos :type rapidamente.',
                    'empty-title'       => 'Adicionar Produto',
                    'image-placeholder' => 'Imagem do Produto',
                    'sku'               => 'SKU - :sku',
                ],

                'types' => [
                    'configurable' => [
                        'add-btn'           => 'Adicionar Variante',
                        'delete-btn'        => 'Excluir',
                        'edit-btn'          => 'Editar',
                        'empty-info'        => 'Para criar várias combinações de produtos rapidamente.',
                        'empty-title'       => 'Adicionar Variante',
                        'image-placeholder' => 'Imagem do Produto',
                        'info'              => 'Produtos de variação dependem de todas as possíveis combinações de atributos.',
                        'qty'               => ':qty Quantidade',
                        'sku'               => 'SKU - :sku',
                        'title'             => 'Variantes',

                        'create' => [
                            'description'            => 'Descrição',
                            'name'                   => 'Nome',
                            'save-btn'               => 'Adicionar',
                            'title'                  => 'Adicionar Variante',
                            'variant-already-exists' => 'Esta variante já existe',
                        ],

                        'edit' => [
                            'disabled'        => 'Desativado',
                            'edit-info'       => 'Se você deseja atualizar as informações do produto em detalhes, vá para a',
                            'edit-link-title' => 'Página de Detalhes do Produto',
                            'enabled'         => 'Ativado',
                            'images'          => 'Imagens',
                            'name'            => 'Nome',
                            'price'           => 'Preço',
                            'quantities'      => 'Quantidades',
                            'save-btn'        => 'Salvar',
                            'sku'             => 'SKU',
                            'status'          => 'Status',
                            'title'           => 'Produto',
                            'weight'          => 'Peso',
                        ],

                        'mass-edit' => [
                            'add-images'          => 'Adicionar Imagens',
                            'apply-to-all-btn'    => 'Aplicar a Todos',
                            'apply-to-all-name'   => 'Aplicar um nome a todas as variantes.',
                            'apply-to-all-sku'    => 'Aplicar um preço a todas as SKU.',
                            'apply-to-all-status' => 'Aplicar um status a todas as variantes.',
                            'apply-to-all-weight' => 'Aplicar um peso a todas as variantes.',
                            'edit-inventories'    => 'Editar Inventários',
                            'edit-names'          => 'Editar Nomes',
                            'edit-prices'         => 'Editar Preços',
                            'edit-sku'            => 'Editar SKU',
                            'edit-status'         => 'Editar Status',
                            'edit-weight'         => 'Editar Peso',
                            'name'                => 'Nome',
                            'price'               => 'Preço',
                            'remove-images'       => 'Remover Imagens',
                            'remove-variants'     => 'Remover Variantes',
                            'select-action'       => 'Selecionar Ação',
                            'select-variants'     => 'Selecionar Variantes',
                            'status'              => 'Status',
                            'variant-name'        => 'Nome da Variante',
                            'variant-sku'         => 'SKU da Variante',
                            'weight'              => 'Peso',
                        ],
                    ],

                    'grouped' => [
                        'add-btn'           => 'Adicionar Produto',
                        'default-qty'       => 'Quantidade Padrão',
                        'delete'            => 'Excluir',
                        'empty-info'        => 'Para criar várias combinações de produtos rapidamente.',
                        'empty-title'       => 'Adicionar Produto',
                        'image-placeholder' => 'Imagem do Produto',
                        'info'              => 'Um produto agrupado consiste em itens independentes apresentados como um conjunto, permitindo variações ou coordenação por temporada ou tema. Cada produto pode ser comprado individualmente ou como parte do grupo.',
                        'sku'               => 'SKU - :sku',
                        'title'             => 'Produtos Agrupados',
                    ],

                    'bundle' => [
                        'add-btn'           => 'Adicionar Opção',
                        'empty-info'        => 'Para criar opções de pacotes rapidamente.',
                        'empty-title'       => 'Adicionar Opção',
                        'image-placeholder' => 'Imagem do Produto',
                        'info'              => 'Um produto de pacote é um pacote de vários itens ou serviços vendidos juntos a um preço especial, proporcionando valor e conveniência aos clientes.',
                        'title'             => 'Itens de Pacote',

                        'update-create' => [
                            'checkbox'    => 'Caixa de Seleção',
                            'is-required' => 'Obrigatório',
                            'multiselect' => 'Seleção Múltipla',
                            'name'        => 'Título',
                            'no'          => 'Não',
                            'radio'       => 'Botão de Rádio',
                            'save-btn'    => 'Salvar',
                            'select'      => 'Selecionar',
                            'title'       => 'Opção',
                            'type'        => 'Tipo',
                            'yes'         => 'Sim',
                        ],

                        'option' => [
                            'add-btn'     => 'Adicionar Produto',
                            'default-qty' => 'Quantidade Padrão',
                            'delete'      => 'Excluir',
                            'delete-btn'  => 'Excluir',
                            'edit-btn'    => 'Editar',
                            'empty-info'  => 'Para criar várias combinações de produtos rapidamente.',
                            'empty-title' => 'Adicionar Produto',
                            'sku'         => 'SKU - :sku',

                            'types' => [
                                'checkbox' => [
                                    'info'  => 'Defina o produto padrão usando caixa de seleção',
                                    'title' => 'Caixa de Seleção',
                                ],

                                'multiselect' => [
                                    'info'  => 'Defina o produto padrão usando o botão de caixa de seleção',
                                    'title' => 'Seleção Múltipla',
                                ],

                                'radio' => [
                                    'info'  => 'Defina o produto padrão usando o botão de rádio',
                                    'title' => 'Botão de Rádio',
                                ],

                                'select' => [
                                    'info'  => 'Defina o produto padrão usando o botão de rádio',
                                    'title' => 'Selecionar',
                                ],
                            ],
                        ],
                    ],

                    'downloadable' => [
                        'links' => [
                            'add-btn'     => 'Adicionar Link',
                            'delete-btn'  => 'Excluir',
                            'edit-btn'    => 'Editar',
                            'empty-info'  => 'Para criar um link rapidamente.',
                            'empty-title' => 'Adicionar Link',
                            'file'        => 'Arquivo : ',
                            'info'        => 'O tipo de produto para download permite vender produtos digitais, como eBooks, aplicativos de software, música, jogos, etc.',
                            'sample-file' => 'Arquivo de Amostra : ',
                            'sample-url'  => 'URL de Amostra : ',
                            'title'       => 'Links para Downloads',
                            'url'         => 'URL : ',

                            'update-create' => [
                                'downloads'   => 'Download Permitido',
                                'file'        => 'Arquivo',
                                'file-type'   => 'Tipo de Arquivo',
                                'name'        => 'Título',
                                'price'       => 'Preço',
                                'sample'      => 'Amostra',
                                'sample-type' => 'Tipo de Amostra',
                                'save-btn'    => 'Salvar',
                                'title'       => 'Link',
                                'url'         => 'URL',
                            ],
                        ],

                        'samples' => [
                            'add-btn'     => 'Adicionar Amostra',
                            'delete-btn'  => 'Excluir',
                            'edit-btn'    => 'Editar',
                            'empty-info'  => 'Para criar uma amostra rapidamente.',
                            'empty-title' => 'Adicionar Amostra',
                            'file'        => 'Arquivo : ',
                            'info'        => 'O tipo de produto para download permite vender produtos digitais, como eBooks, aplicativos de software, música, jogos, etc.',
                            'title'       => 'Amostras para Download',
                            'url'         => 'URL : ',

                            'update-create' => [
                                'file'        => 'Arquivo',
                                'file-type'   => 'Tipo de Arquivo',
                                'name'        => 'Título',
                                'save-btn'    => 'Salvar',
                                'title'       => 'Link',
                                'url'         => 'URL',
                            ],
                        ],
                    ],
                ],
            ],

            'create-success'          => 'Produto criado com sucesso',
            'delete-failed'           => 'Falha ao excluir o produto',
            'delete-success'          => 'Produto excluído com sucesso',
            'product-copied'          => 'Produto copiado com sucesso',
            'saved-inventory-message' => 'Produto salvo com sucesso',
            'update-success'          => 'Produto atualizado com sucesso',
        ],

        'attributes' => [
            'index' => [
                'create-btn' => 'Criar Atributos',
                'title'      => 'Atributos',

                'datagrid' => [
                    'boolean'             => 'Boolean',
                    'channel-based'       => 'Baseado em Canal',
                    'checkbox'            => 'Checkbox',
                    'code'                => 'Código',
                    'created-at'          => 'Criado Em',
                    'date'                => 'Data',
                    'date-time'           => 'Data Hora',
                    'delete'              => 'Deletar',
                    'edit'                => 'Editar',
                    'file'                => 'Arquivo',
                    'id'                  => 'ID',
                    'image'               => 'Imagem',
                    'locale-based'        => 'Baseado em Localidade',
                    'mass-delete-success' => 'Atributo Selecionado Deletado com Sucesso',
                    'multiselect'         => 'Seleção Múltipla',
                    'name'                => 'Nome',
                    'price'               => 'Preço',
                    'required'            => 'Requerido',
                    'select'              => 'Selecionar',
                    'text'                => 'Texto',
                    'textarea'            => 'Área de Texto',
                    'type'                => 'Tipo',
                    'unique'              => 'Único',
                ],
            ],

            'create' => [
                'add-attribute-options'  => 'Adicionar Opções de Atributo',
                'add-option'             => 'Adicionar Opção',
                'add-options-info'       => 'Para criar várias combinações de Opções de Atributo de uma só vez.',
                'add-row'                => 'Adicionar Linha',
                'admin'                  => 'Admin',
                'admin-name'             => 'Nome do Admin',
                'back-btn'               => 'Voltar',
                'boolean'                => 'Booleano',
                'checkbox'               => 'Caixa de seleção',
                'code'                   => 'Código do Atributo',
                'color'                  => 'Cor',
                'configuration'          => 'Configuração',
                'create-empty-option'    => 'Criar opção vazia padrão',
                'date'                   => 'Data',
                'datetime'               => 'Data e Hora',
                'decimal'                => 'Decimal',
                'default-value'          => 'Valor padrão',
                'email'                  => 'Email',
                'enable-wysiwyg'         => 'Habilitar Editor Wysiwyg',
                'file'                   => 'Arquivo',
                'general'                => 'Geral',
                'image'                  => 'Imagem',
                'input-options'          => 'Opções de Entrada',
                'input-validation'       => 'Validação de Entrada',
                'is-comparable'          => 'O atributo é comparável',
                'is-configurable'        => 'Usar Para Criar Produto Configurável',
                'is-filterable'          => 'Usar na Navegação em Camadas',
                'is-required'            => 'Obrigatório',
                'is-unique'              => 'Único',
                'is-visible-on-front'    => 'Visível na Página de Visualização do Produto na Frente',
                'label'                  => 'Rótulo',
                'multiselect'            => 'Seleção Múltipla',
                'no'                     => 'Não',
                'numeric'                => 'Número',
                'option-deleted'         => 'Opção eliminada com sucesso',
                'options'                => 'Opções',
                'position'               => 'Posição',
                'price'                  => 'Preço',
                'regex'                  => 'Expressão Regular (Regex)',
                'regex-info'             => 'A expressão deve estar entre aspas duplas.',
                'save-btn'               => 'Salvar Atributo',
                'select'                 => 'Seleção',
                'select-type'            => 'Selecionar Tipo de Atributo',
                'swatch'                 => 'Mostruário',
                'text'                   => 'Texto',
                'textarea'               => 'Área de Texto',
                'title'                  => 'Adicionar Atributo',
                'type'                   => 'Tipo de Atributo',
                'url'                    => 'URL',
                'use-in-flat'            => 'Criar na Tabela de Produtos Simples',
                'validations'            => 'Validações',
                'value-per-channel'      => 'Valor Por Canal',
                'value-per-locale'       => 'Valor Por Localização',
                'yes'                    => 'Sim',

                'option' => [
                    'color'    => 'Mostruário de Cores',
                    'dropdown' => 'Caixa de Seleção',
                    'image'    => 'Mostruário de Imagens',
                    'save-btn' => 'Salvar Opção',
                    'text'     => 'Mostruário de Texto',
                ],
            ],

            'edit' => [
                'add-attribute-options' => 'Adicionar Opções de Atributo',
                'add-option'            => 'Adicionar Opção',
                'add-options-info'      => 'Para criar várias combinações de Opções de Atributo de uma só vez.',
                'add-row'               => 'Adicionar Linha',
                'admin'                 => 'Admin',
                'admin-name'            => 'Nome do Admin',
                'back-btn'              => 'Voltar',
                'boolean'               => 'Booleano',
                'checkbox'              => 'Caixa de seleção',
                'code'                  => 'Código do Atributo',
                'color'                 => 'Cor',
                'configuration'         => 'Configuração',
                'create-empty-option'   => 'Criar opção vazia padrão',
                'date'                  => 'Data',
                'datetime'              => 'Data e Hora',
                'decimal'               => 'Decimal',
                'default-value'         => 'Valor padrão',
                'email'                 => 'Email',
                'enable-wysiwyg'        => 'Habilitar Editor Wysiwyg',
                'file'                  => 'Arquivo',
                'general'               => 'Geral',
                'image'                 => 'Imagem',
                'input-options'         => 'Opções de Entrada',
                'input-validation'      => 'Validação de Entrada',
                'is-comparable'         => 'O atributo é comparável',
                'is-configurable'       => 'Usar Para Criar Produto Configurável',
                'is-filterable'         => 'Usar na Navegação em Camadas',
                'is-required'           => 'Obrigatório',
                'is-unique'             => 'Único',
                'is-visible-on-front'   => 'Visível na Página de Visualização do Produto na Frente',
                'label'                 => 'Rótulo',
                'multiselect'           => 'Seleção Múltipla',
                'no'                    => 'Não',
                'numeric'               => 'Número',
                'option-deleted'        => 'Opção eliminada com sucesso',
                'options'               => 'Opções',
                'position'              => 'Posição',
                'price'                 => 'Preço',
                'regex'                 => 'Expressão Regular (Regex)',
                'regex-info'            => 'A expressão deve estar entre aspas duplas.',
                'save-btn'              => 'Salvar Atributo',
                'select'                => 'Seleção',
                'select-type'           => 'Selecionar Tipo de Atributo',
                'swatch'                => 'Mostruário',
                'text'                  => 'Texto',
                'textarea'              => 'Área de Texto',
                'title'                 => 'Editar Atributo',
                'type'                  => 'Tipo de Atributo',
                'url'                   => 'URL',
                'use-in-flat'           => 'Criar na Tabela de Produtos Simples',
                'validations'           => 'Validações',
                'value-per-channel'     => 'Valor Por Canal',
                'value-per-locale'      => 'Valor Por Localização',
                'yes'                   => 'Sim',

                'option' => [
                    'color'    => 'Mostruário de Cores',
                    'dropdown' => 'Caixa de Seleção',
                    'image'    => 'Mostruário de Imagens',
                    'save-btn' => 'Salvar Opção',
                    'text'     => 'Mostruário de Texto',
                ],
            ],

            'create-success'    => 'Atributo Criado com Sucesso',
            'delete-failed'     => 'Falha ao Excluir o Atributo',
            'delete-success'    => 'Atributo Excluído com Sucesso',
            'update-success'    => 'Atributo Atualizado com Sucesso',
            'user-define-error' => 'Não é possível excluir Atributo de Sistema',
        ],

        'categories' => [
            'index' => [
                'add-btn' => 'Criar Categoria',
                'title'   => 'Categorias',

                'datagrid' => [
                    'active'         => 'Ativa',
                    'delete'         => 'Excluir',
                    'delete-success' => 'Selecionado(s) :resource foram excluídos com sucesso',
                    'edit'           => 'Editar',
                    'id'             => 'ID',
                    'inactive'       => 'Inativa',
                    'name'           => 'Nome',
                    'no-of-products' => 'Número de Produtos',
                    'position'       => 'Posição',
                    'status'         => 'Visível no menu',
                    'update-status'  => 'Atualizar Status',
                ],
            ],

            'create' => [
                'add-banner'               => 'Adicionar Banner',
                'add-logo'                 => 'Adicionar Logo',
                'back-btn'                 => 'Voltar',
                'banner'                   => 'Banner',
                'banner-size'              => 'Proporção do banner (1320px X 300px)',
                'description'              => 'Descrição',
                'description-and-images'   => 'Descrição e Imagens',
                'description-only'         => 'Apenas Descrição',
                'display-mode'             => 'Modo de Exibição',
                'enter-position'           => 'Informe a Posição',
                'filterable-attributes'    => 'Atributos Filtráveis',
                'general'                  => 'Geral',
                'logo'                     => 'Logo',
                'logo-size'                => 'Resolução do Logo deve ser (110px X 110px)',
                'meta-description'         => 'Meta Descrição',
                'meta-keywords'            => 'Meta Palavras-chave',
                'meta-title'               => 'Meta Título',
                'name'                     => 'Nome',
                'parent-category'          => 'Categoria Pai',
                'position'                 => 'Posição',
                'products-and-description' => 'Produtos e Descrição',
                'products-only'            => 'Apenas Produtos',
                'save-btn'                 => 'Salvar Categoria',
                'select-display-mode'      => 'Selecione o Modo de Exibição',
                'seo-details'              => 'Detalhes de SEO',
                'settings'                 => 'Configurações',
                'slug'                     => 'Slug',
                'title'                    => 'Adicionar Nova Categoria',
                'visible-in-menu'          => 'Visível no Menu',
            ],

            'edit' => [
                'add-banner'               => 'Adicionar Banner',
                'add-logo'                 => 'Adicionar Logo',
                'back-btn'                 => 'Voltar',
                'banner'                   => 'Banner',
                'banner-size'              => 'Proporção do banner (1320px X 300px)',
                'description'              => 'Descrição',
                'description-and-images'   => 'Descrição e Imagens',
                'description-only'         => 'Apenas Descrição',
                'display-mode'             => 'Modo de Exibição',
                'enter-position'           => 'Informe a Posição',
                'filterable-attributes'    => 'Atributos Filtráveis',
                'general'                  => 'Geral',
                'logo'                     => 'Logo',
                'logo-size'                => 'Resolução do Logo deve ser (110px X 110px)',
                'meta-description'         => 'Meta Descrição',
                'meta-keywords'            => 'Meta Palavras-chave',
                'meta-title'               => 'Meta Título',
                'name'                     => 'Nome',
                'position'                 => 'Posição*',
                'products-and-description' => 'Produtos e Descrição',
                'products-only'            => 'Apenas Produtos',
                'save-btn'                 => 'Salvar Categoria',
                'select-display-mode'      => 'Selecione o Modo de Exibição',
                'select-parent-category'   => 'Selecione a Categoria Pai*',
                'seo-details'              => 'Detalhes de SEO',
                'settings'                 => 'Configurações',
                'slug'                     => 'Slug',
                'title'                    => 'Editar Categoria',
                'visible-in-menu'          => 'Visível no Menu',
            ],

            'category'             => 'Categoria',
            'create-success'       => 'Categoria criada com sucesso.',
            'delete-category-root' => 'A categoria raiz não pode ser excluída.',
            'delete-failed'        => 'Erro ao excluir a categoria',
            'delete-success'       => 'A categoria foi excluída com sucesso.',
            'update-success'       => 'Categoria atualizada com sucesso.',
        ],

        'families'   => [
            'index' => [
                'add'   => 'Criar Família de Atributos',
                'title' => 'Famílias',

                'datagrid' => [
                    'code'           => 'Código',
                    'delete'         => 'Excluir',
                    'delete-success' => 'Selecionado(s) :resource foram excluídos com sucesso',
                    'edit'           => 'Editar',
                    'id'             => 'ID',
                    'method-error'   => 'Erro! Método incorreto detectado, verifique a configuração da ação em massa',
                    'name'           => 'Nome',
                    'no-resource'    => 'O recurso fornecido é insuficiente para a ação',
                    'partial-action' => 'Algumas ações não foram executadas devido a restrições do sistema em :resource',
                    'update-success' => 'Selecionado(s) :resource foram atualizados com sucesso',
                ],
            ],

            'create' => [
                'add-group-btn'                    => 'Adicionar Grupo',
                'add-group-title'                  => 'Adicionar Novo Grupo',
                'back-btn'                         => 'Voltar',
                'code'                             => 'Código',
                'column'                           => 'Coluna',
                'delete-group-btn'                 => 'Excluir Grupo',
                'edit-group-info'                  => 'Clique duas vezes para editar o Grupo',
                'enter-code'                       => 'Digite o Código',
                'enter-name'                       => 'Digite o Nome',
                'general'                          => 'Geral',
                'group-code-already-exists'        => 'Um código de grupo de atributos já existe.',
                'group-contains-system-attributes' => 'Este grupo contém atributos do sistema. Primeiro mova os atributos do sistema para outro grupo e tente novamente.',
                'group-name-already-exists'        => 'Já existe um nome de grupo de atributos.',
                'groups'                           => 'Grupos',
                'groups-info'                      => 'Gerenciar grupos de família de atributos',
                'main-column'                      => 'Coluna Principal',
                'name'                             => 'Nome',
                'removal-not-possible'             => 'Você não pode remover atributos do sistema da família de atributos.',
                'right-column'                     => 'Coluna Lateral Direita',
                'save-btn'                         => 'Salvar Família de Atributos',
                'select-group'                     => 'Por favor, selecione um grupo de atributos.',
                'title'                            => 'Criar Família de Atributos',
                'unassigned-attributes'            => 'Atributos não Atribuídos',
                'unassigned-attributes-info'       => 'Arraste esses atributos para adicionar nas colunas ou grupos.',
            ],

            'edit' => [
                'add-group-btn'                    => 'Adicionar Grupo',
                'add-group-title'                  => 'Adicionar Novo Grupo',
                'back-btn'                         => 'Voltar',
                'code'                             => 'Código',
                'column'                           => 'Coluna',
                'delete-group-btn'                 => 'Excluir Grupo',
                'edit-group-info'                  => 'Clique duas vezes para editar o Grupo',
                'enter-code'                       => 'Digite o Código',
                'enter-name'                       => 'Digite o Nome',
                'general'                          => 'Geral',
                'group-code-already-exists'        => 'Um código de grupo de atributos já existe.',
                'group-contains-system-attributes' => 'Este grupo contém atributos do sistema. Primeiro mova os atributos do sistema para outro grupo e tente novamente.',
                'group-name-already-exists'        => 'Já existe um nome de grupo de atributos.',
                'groups'                           => 'Grupos',
                'groups-info'                      => 'Gerenciar grupos de família de atributos',
                'main-column'                      => 'Coluna Principal',
                'name'                             => 'Nome',
                'removal-not-possible'             => 'Você não pode remover atributos do sistema da família de atributos.',
                'right-column'                     => 'Coluna Lateral Direita',
                'save-btn'                         => 'Salvar Família de Atributos',
                'select-group'                     => 'Por favor, selecione um grupo de atributos.',
                'title'                            => 'Editar Família de Atributos',
                'unassigned-attributes'            => 'Atributos não Atribuídos',
                'unassigned-attributes-info'       => 'Arraste esses atributos para adicionar nas colunas ou grupos.',
            ],

            'attribute-family'        => 'Família de Atributos',
            'attribute-product-error' => 'A família é usada em produtos.',
            'create-success'          => 'Família criada com sucesso.',
            'delete-failed'           => 'Erro ao excluir a Família.',
            'delete-success'          => 'Família excluída com sucesso.',
            'family'                  => 'Família',
            'last-delete-error'       => 'Pelo menos uma família é necessária.',
            'update-success'          => 'Família atualizada com sucesso.',
            'user-define-error'       => 'Não é possível excluir a família de atributos do sistema.',
        ],
    ],

    'customers' => [
        'customers' => [
            'index' => [
                'title'         => 'Clientes',
                'login-message' => 'Você fez login como :customer_name',

                'datagrid' => [
                    'active'         => 'Ativo',
                    'address'        => ':address Endereço(s)',
                    'address-count'  => 'Quantidade de Endereços',
                    'channel'        => 'Canal',
                    'delete'         => 'Excluir',
                    'delete-success' => 'Dados selecionados excluídos com sucesso',
                    'email'          => 'E-mail',
                    'gender'         => 'Gênero',
                    'group'          => 'Grupo',
                    'id'             => 'ID do Cliente',
                    'inactive'       => 'Inativo',
                    'method-error'   => 'Erro! Método incorreto detectado, por favor, verifique a configuração da ação em massa',
                    'name'           => 'Nome do Cliente',
                    'no-resource'    => 'O recurso fornecido é insuficiente para a ação',
                    'order'          => ':order Pedido(s)',
                    'order-count'    => 'Quantidade de Pedidos',
                    'order-pending'  => 'Cliente com pedido pendente',
                    'partial-action' => 'Algumas ações não foram realizadas devido a restrições do sistema em :resource',
                    'phone'          => 'Número de Contato',
                    'revenue'        => 'Receita',
                    'status'         => 'Status',
                    'suspended'      => 'Suspenso',
                    'update-status'  => 'Atualizar Status',
                    'update-success' => 'Clientes selecionados atualizados com sucesso',
                ],

                'create' => [
                    'contact-number'        => 'Número de Contato',
                    'create-btn'            => 'Criar Cliente',
                    'create-success'        => 'Cliente criado com sucesso',
                    'customer-group'        => 'Grupo de Clientes',
                    'date-of-birth'         => 'Data de Nascimento',
                    'email'                 => 'E-mail',
                    'female'                => 'Feminino',
                    'first-name'            => 'Primeiro Nome',
                    'gender'                => 'Gênero',
                    'last-name'             => 'Sobrenome',
                    'male'                  => 'Masculino',
                    'other'                 => 'Outro',
                    'save-btn'              => 'Salvar Cliente',
                    'select-customer-group' => 'Selecionar Grupo de Cliente',
                    'select-gender'         => 'Selecionar Gênero',
                    'title'                 => 'Criar Novo Cliente',
                ],
            ],

            'view' => [
                'account-delete-confirmation' => 'Tem certeza de que deseja excluir esta conta?',
                'active'                      => 'Ativo',
                'address-delete-confirmation' => 'Tem certeza de que deseja excluir este endereço?',
                'back-btn'                    => 'Voltar',
                'create-order'                => 'Criar Pedido',
                'customer'                    => 'Cliente',
                'date-of-birth'               => 'Nasc. - :dob',
                'default-address'             => 'Endereço Padrão',
                'delete-account'              => 'Excluir Conta',
                'delete'                      => 'Excluir',
                'email'                       => 'E-mail - :email',
                'empty-description'           => 'Criar novos endereços para o cliente',
                'empty-title'                 => 'Adicionar Endereço do Cliente',
                'gender'                      => 'Gênero - :gender',
                'group'                       => 'Grupo - :group_code',
                'inactive'                    => 'Inativo',
                'login-as-customer'           => 'Login como cliente',
                'note-created-success'        => 'Nota criada com sucesso',
                'order-create-confirmation'   => 'Tem certeza de que deseja criar um pedido para este cliente?',
                'phone'                       => 'Telefone - :phone',
                'set-as-default'              => 'Definir como padrão',
                'suspended'                   => 'Suspenso',
                'title'                       => 'Visualização do Cliente',

                'address' => [
                    'count'  => 'Endereços (:count)',

                    'create' => [
                        'city'               => 'Cidade',
                        'company-name'       => 'Nome da Empresa',
                        'country'            => 'País',
                        'create-btn'         => 'Criar',
                        'create-address-btn' => 'Adicionar Novo Endereço',
                        'default-address'    => 'Endereço Padrão',
                        'email'              => 'E-mail',
                        'first-name'         => 'Primeiro Nome',
                        'last-name'          => 'Sobrenome',
                        'phone'              => 'Telefone',
                        'post-code'          => 'Código Postal',
                        'save-btn-title'     => 'Salvar Endereço',
                        'select-country'     => 'Selecionar País',
                        'state'              => 'Estado',
                        'street-address'     => 'Endereço',
                        'title'              => 'Criar Endereço',
                        'vat-id'             => 'ID do VAT',
                    ],

                    'edit' => [
                        'city'            => 'Cidade',
                        'company-name'    => 'Nome da Empresa',
                        'country'         => 'País',
                        'default-address' => 'Endereço Padrão',
                        'edit-btn'        => 'Editar',
                        'email'           => 'E-mail',
                        'first-name'      => 'Primeiro Nome',
                        'last-name'       => 'Sobrenome',
                        'phone'           => 'Telefone',
                        'post-code'       => 'Código Postal',
                        'save-btn-title'  => 'Salvar Endereço',
                        'select-country'  => 'Selecionar País',
                        'state'           => 'Estado',
                        'street-address'  => 'Endereço',
                        'title'           => 'Editar Endereço',
                        'vat-id'          => 'ID do VAT',
                    ],

                    'address-delete-success' => 'Endereço excluído com sucesso',
                    'create-success'         => 'Endereço criado com sucesso',
                    'set-default-success'    => 'Endereço padrão atualizado com sucesso',
                    'success-mass-delete'    => 'Exclusão em massa de endereços realizada com sucesso',
                    'update-success'         => 'Endereço atualizado com sucesso',
                ],

                'datagrid' => [
                    'invoices' => [
                        'empty-invoice'  => 'Nenhuma avaliação disponível',
                        'increment-id'   => 'ID das Faturas',
                        'invoice-amount' => 'Valor das Faturas',
                        'invoice-date'   => 'Data das Faturas',
                        'order-id'       => 'ID do Pedido',
                        'view'           => 'Visualizar',
                    ],

                    'orders' => [
                        'canceled'        => 'Cancelado',
                        'channel-name'    => 'Nome do Canal',
                        'closed'          => 'Fechado',
                        'completed'       => 'Concluído',
                        'customer-name'   => 'Nome do Cliente',
                        'empty-order'     => 'Nenhum pedido disponível',
                        'date'            => 'Data',
                        'email'           => 'E-mail',
                        'fraud'           => 'Fraude',
                        'grand-total'     => 'Total Geral',
                        'location'        => 'Localização',
                        'order-id'        => 'ID do Pedido',
                        'pay-via'         => 'Pagar Por',
                        'pending'         => 'Pendente',
                        'pending-payment' => 'Pagamento Pendente',
                        'processing'      => 'Processando',
                        'status'          => 'Status',
                        'view'            => 'Visualizar',
                    ],

                    'reviews' => [
                        'approved'      => 'Aprovado',
                        'comment'       => 'Comentário',
                        'created-at'    => 'Criado em',
                        'disapproved'   => 'Reprovado',
                        'empty-reviews' => 'Nenhuma fatura disponível',
                        'id'            => 'ID',
                        'invoice-date'  => 'Data da Fatura',
                        'pending'       => 'Pendente',
                        'product-id'    => 'ID do Produto',
                        'product-name'  => 'Nome do Produto',
                        'rating'        => 'Avaliação',
                        'status'        => 'Status',
                        'title'         => 'Título',
                    ],
                ],

                'edit' => [
                    'contact-number'        => 'Número de Contato',
                    'customer-group'        => 'Grupo de Clientes',
                    'date-of-birth'         => 'Data de Nascimento',
                    'edit-btn'              => 'Editar',
                    'email'                 => 'E-mail',
                    'female'                => 'Feminino',
                    'first-name'            => 'Primeiro Nome',
                    'gender'                => 'Gênero',
                    'last-name'             => 'Sobrenome',
                    'male'                  => 'Masculino',
                    'other'                 => 'Outro',
                    'save-btn'              => 'Salvar Cliente',
                    'select-customer-group' => 'Selecionar Grupo de Cliente',
                    'select-gender'         => 'Selecionar Gênero',
                    'status'                => 'Status',
                    'suspended'             => 'Suspenso',
                    'title'                 => 'Editar Cliente',
                ],

                'invoices' => [
                    'count'        => 'Faturas (:count)',
                    'increment-id' => '# :increment_id',
                ],

                'notes' => [
                    'add-note'              => 'Adicionar Nota',
                    'customer-not-notified' => ':date | Cliente <b>Não Notificado</b>',
                    'customer-notified'     => ':date | Cliente <b>Notificado</b>',
                    'note'                  => 'Nota',
                    'note-placeholder'      => 'Escreva sua nota aqui',
                    'notify-customer'       => 'Notificar Cliente',
                    'submit-btn-title'      => 'Enviar Nota',
                ],

                'orders' => [
                    'count'         => 'Pedidos (:count)',
                    'increment-id'  => '# :increment_id',
                    'total-revenue' => 'Receita Total - :revenue',
                ],

                'reviews' => [
                    'id'    => 'ID - :id',
                    'count' => 'Avaliações (:count)',
                ],

                'cart' => [
                    'delete-success' => 'Item do carrinho removido com sucesso.',
                ],

                'wishlist' => [
                    'delete-success' => 'Item da lista de desejos removido com sucesso.',
                ],

                'compare' => [
                    'delete-success' => 'Item de comparação removido com sucesso.',
                ],
            ],

            'delete-failed'  => 'Falha ao Excluir Cliente',
            'delete-success' => 'Cliente Excluído com Sucesso',
            'order-pending'  => 'Pedido Pendente',
            'update-success' => 'Cliente Atualizado com Sucesso',
        ],

        'groups' => [
            'index' => [
                'title' => 'Grupos',

                'create' => [
                    'code'       => 'Código',
                    'create-btn' => 'Criar Grupo',
                    'name'       => 'Nome',
                    'save-btn'   => 'Salvar Grupo',
                    'success'    => 'Grupo criado com sucesso',
                    'title'      => 'Criar Novo Grupo',
                ],

                'edit' => [
                    'delete-failed'  => 'Falha ao Excluir Grupo',
                    'delete-success' => 'Grupo Excluído com Sucesso',
                    'group-default'  => 'O Grupo Padrão Não Pode ser Excluído',
                    'success'        => 'Grupo Atualizado com Sucesso',
                    'title'          => 'Editar Grupo',
                ],

                'datagrid' => [
                    'code'   => 'Código',
                    'delete' => 'Excluir',
                    'edit'   => 'Editar',
                    'id'     => 'ID',
                    'name'   => 'Nome',
                ],
            ],
        ],

        'reviews' => [
            'index' => [
                'date'        => 'Data',
                'description' => 'Descrição',
                'id'          => 'ID',
                'name'        => 'Nome',
                'product'     => 'Produto',
                'rating'      => 'Classificação',
                'status'      => 'Status',
                'title'       => 'Avaliações',

                'edit' => [
                    'approved'       => 'Aprovada',
                    'customer'       => 'Cliente',
                    'date'           => 'Data',
                    'disapproved'    => 'Reprovada',
                    'id'             => 'ID',
                    'images'         => 'Imagens',
                    'pending'        => 'Pendente',
                    'product'        => 'Produto',
                    'rating'         => 'Classificação',
                    'review-comment' => 'Comentário',
                    'review-title'   => 'Título',
                    'save-btn'       => 'Salvar',
                    'status'         => 'Status',
                    'title'          => 'Editar Avaliação',
                    'update-success' => 'Atualização Bem-sucedida',
                ],

                'datagrid' => [
                    'approved'            => 'Aprovada',
                    'comment'             => 'Comentário',
                    'customer-names'      => 'Nome',
                    'date'                => 'Data',
                    'delete'              => 'Excluir',
                    'delete-success'      => 'Avaliação Excluída com Sucesso',
                    'disapproved'         => 'Reprovada',
                    'edit'                => 'Editar',
                    'id'                  => 'ID',
                    'mass-delete-error'   => 'Algo deu errado',
                    'mass-delete-success' => 'Avaliações Selecionadas Excluídas com Sucesso',
                    'mass-update-success' => 'Avaliações Selecionadas Atualizadas com Sucesso',
                    'pending'             => 'Pendente',
                    'product'             => 'Produto',
                    'rating'              => 'Classificação',
                    'review-id'           => 'ID - :review_id',
                    'status'              => 'Status',
                    'title'               => 'Título',
                    'update-status'       => 'Atualizar Status',
                ],
            ],
        ],
    ],

    'marketing' => [
        'communications' => [
            'templates' => [
                'index' => [
                    'create-btn' => 'Criar Modelo',
                    'title'      => 'Modelos de Email',

                    'datagrid' => [
                        'active'   => 'Ativo',
                        'draft'    => 'Rascunho',
                        'id'       => 'ID',
                        'inactive' => 'Inativo',
                        'name'     => 'Nome',
                        'status'   => 'Status',
                    ],
                ],

                'create' => [
                    'active'         => 'Ativo',
                    'back-btn'       => 'Voltar',
                    'content'        => 'Conteúdo',
                    'create-success' => 'Modelo de email criado com sucesso.',
                    'draft'          => 'Rascunho',
                    'general'        => 'Geral',
                    'inactive'       => 'Inativo',
                    'name'           => 'Nome',
                    'save-btn'       => 'Salvar Modelo',
                    'select-status'  => 'Selecione o Status',
                    'status'         => 'Status',
                    'title'          => 'Criar Modelo',
                ],

                'edit' => [
                    'active'         => 'Ativo',
                    'back-btn'       => 'Voltar',
                    'content'        => 'Conteúdo*',
                    'draft'          => 'Rascunho',
                    'general'        => 'Geral',
                    'inactive'       => 'Inativo',
                    'name'           => 'Nome',
                    'save-btn'       => 'Salvar Modelo',
                    'status'         => 'Status',
                    'title'          => 'Editar Modelo',
                    'update-success' => 'Atualizado com sucesso',
                ],

                'delete-failed'  => 'Falha ao excluir :name',
                'delete-success' => 'Modelo excluído com sucesso',
                'email-template' => 'Modelo de Email',
            ],

            'campaigns' => [
                'index' => [
                    'create-btn' => 'Criar Campanha',
                    'title'      => 'Campanhas',

                    'datagrid' => [
                        'active'   => 'Ativo',
                        'delete'   => 'Excluir',
                        'edit'     => 'Editar',
                        'id'       => 'ID',
                        'inactive' => 'Inativo',
                        'name'     => 'Nome',
                        'status'   => 'Status',
                        'subject'  => 'Assunto',
                    ],
                ],

                'create' => [
                    'active'          => 'Ativo',
                    'back-btn'        => 'Voltar',
                    'channel'         => 'Canal',
                    'customer-group'  => 'Grupo de Clientes',
                    'email-template'  => 'Modelo de Email',
                    'event'           => 'Evento',
                    'general'         => 'Geral',
                    'inactive'        => 'Inativo',
                    'name'            => 'Nome',
                    'save-btn'        => 'Salvar Campanha',
                    'select-channel'  => 'Selecionar canal',
                    'select-event'    => 'Selecione um Evento',
                    'select-group'    => 'Selecionar grupo',
                    'select-status'   => 'Selecione um Status',
                    'select-template' => 'Selecione um Modelo',
                    'setting'         => 'Configuração',
                    'status'          => 'Status',
                    'subject'         => 'Assunto',
                    'title'           => 'Criar Campanha',
                ],

                'edit' => [
                    'active'          => 'Ativo',
                    'audience'        => 'Público',
                    'back-btn'        => 'Voltar',
                    'channel'         => 'Canal',
                    'customer-group'  => 'Grupo de Clientes',
                    'email-template'  => 'Modelo de Email',
                    'event'           => 'Evento',
                    'general'         => 'Geral',
                    'inactive'        => 'Inativo',
                    'name'            => 'Nome',
                    'save-btn'        => 'Salvar Campanha',
                    'select-event'    => 'Selecione um Evento',
                    'select-status'   => 'Selecione um Status',
                    'select-template' => 'Selecione um Modelo',
                    'status'          => 'Status',
                    'subject'         => 'Assunto',
                    'title'           => 'Editar Campanha',
                ],

                'create-success'   => 'Campanha criada com sucesso.',
                'delete-failed'    => 'Falha ao excluir :name',
                'delete-success'   => 'Campanha excluída com sucesso.',
                'email-campaign'   => 'Campanha de Email',
                'update-success'   => 'Campanha atualizada com sucesso.',
            ],

            'events' => [
                'index' => [
                    'create-btn' => 'Criar Evento',
                    'event'      => 'Evento',
                    'title'      => 'Eventos',

                    'datagrid' => [
                        'actions' => 'Ações',
                        'date'    => 'Data',
                        'delete'  => 'Excluir',
                        'edit'    => 'Editar',
                        'id'      => 'ID',
                        'name'    => 'Nome',
                    ],

                    'create' => [
                        'date'           => 'Data',
                        'delete-warning' => 'Você tem certeza de que deseja executar esta ação?',
                        'description'    => 'Descrição',
                        'general'        => 'Geral',
                        'name'           => 'Nome',
                        'save-btn'       => 'Salvar Evento',
                        'success'        => 'Eventos Criados com Sucesso',
                        'title'          => 'Criar Eventos',
                    ],

                    'edit' => [
                        'success' => 'Eventos Atualizados com Sucesso',
                        'title'   => 'Editar Eventos',
                    ],
                ],

                'delete-failed'  => 'Falha ao excluir :name',
                'delete-success' => 'Eventos excluídos com sucesso',
                'edit-error'     => 'Não é possível editar o evento',
            ],

            'subscribers' => [
                'index' => [
                    'title' => 'Assinaturas de Newsletter',

                    'datagrid' => [
                        'actions'    => 'Ações',
                        'delete'     => 'Excluir',
                        'edit'       => 'Editar',
                        'email'      => 'E-mail',
                        'false'      => 'Falso',
                        'id'         => 'ID',
                        'subscribed' => 'Inscrito',
                        'true'       => 'Verdadeiro',
                    ],

                    'edit' => [
                        'back-btn'      => 'Voltar',
                        'email'         => 'E-mail',
                        'false'         => 'Falso',
                        'save-btn'      => 'Salvar Assinante',
                        'subscribed'    => 'Inscrito',
                        'success'       => 'Assinatura de Newsletter Atualizada com Sucesso',
                        'title'         => 'Editar Assinante de Newsletter',
                        'true'          => 'Verdadeiro',
                        'update-failed' => 'Assinatura de Newsletter Não Atualizada',
                    ],
                ],

                'delete-failed'  => 'Falha ao Excluir Assinante',
                'delete-success' => 'Assinante Excluído com Sucesso',
                'delete-warning' => 'Tem certeza de que deseja executar esta ação?',
            ],
        ],

        'promotions' => [
            'index' => [
                'cart-rule-title'    => 'Regras de Carrinho',
                'catalog-rule-title' => 'Regras de Catálogo',
            ],

            'cart-rules' => [
                'index' => [
                    'create-btn' => 'Criar Regra de Carrinho',
                    'title'      => 'Regras de Carrinho',

                    'datagrid' => [
                        'active'      => 'Ativo',
                        'copy'        => 'Copiar',
                        'copy-of'     => ':value',
                        'coupon-code' => 'Código do Cupom',
                        'delete'      => 'Excluir',
                        'draft'       => 'Rascunho',
                        'edit'        => 'Editar',
                        'end'         => 'Fim',
                        'id'          => 'ID',
                        'inactive'    => 'Inativo',
                        'name'        => 'Nome',
                        'priority'    => 'Prioridade',
                        'start'       => 'Início',
                        'status'      => 'Status',
                    ],
                ],

                'create' => [
                    'action-type'                               => 'Tipo de Ação',
                    'actions'                                   => 'Ações',
                    'add-condition'                             => 'Adicionar Condição',
                    'additional'                                => 'Adicional',
                    'all-conditions-true'                       => 'Todas as Condições Verdadeiras',
                    'any-conditions-true'                       => 'Qualquer Condição Verdadeira',
                    'apply-to-shipping'                         => 'Aplicar ao Envio',
                    'attribute-family'                          => 'Família de Atributos',
                    'attribute-name-children-only'              => 'Nome do Atributo Somente para Categorias Filhas',
                    'attribute-name-parent-only'                => 'Nome do Atributo Somente para Categorias Principais',
                    'auto-generate-coupon'                      => 'Gerar Cupom Automaticamente',
                    'back-btn'                                  => 'Voltar',
                    'buy-x-get-y-free'                          => 'Compre X e Leve Y de Graça',
                    'buy-x-quantity'                            => 'Compre X Quantidade',
                    'cart-attribute'                            => 'Atributo do Carrinho',
                    'cart-item-attribute'                       => 'Atributo do Item do Carrinho',
                    'categories'                                => 'Categorias',
                    'channels'                                  => 'Canais',
                    'children-categories'                       => 'Categorias Filhas',
                    'choose-condition-to-add'                   => 'Escolha a condição para adicionar',
                    'condition-type'                            => 'Tipo de Condição',
                    'conditions'                                => 'Condições',
                    'contain'                                   => 'Contém',
                    'contains'                                  => 'Contém',
                    'coupon-code'                               => 'Código do Cupom',
                    'coupon-type'                               => 'Tipo de Cupom',
                    'create-success'                            => 'Regra de Carrinho criada com sucesso',
                    'customer-groups'                           => 'Grupos de Clientes',
                    'description'                               => 'Descrição',
                    'discount-amount'                           => 'Valor de Desconto',
                    'does-not-contain'                          => 'Não Contém',
                    'end-of-other-rules'                        => 'Fim de Outras Regras',
                    'equals-or-greater-than'                    => 'Igual ou Maior Que',
                    'equals-or-less-than'                       => 'Igual ou Menor Que',
                    'fixed-amount'                              => 'Valor Fixo',
                    'fixed-amount-whole-cart'                   => 'Valor Fixo para o Carrinho Inteiro',
                    'free-shipping'                             => 'Frete Grátis',
                    'from'                                      => 'De',
                    'general'                                   => 'Geral',
                    'greater-than'                              => 'Maior Que',
                    'is-equal-to'                               => 'É Igual a',
                    'is-not-equal-to'                           => 'Não é Igual a',
                    'less-than'                                 => 'Menor Que',
                    'marketing-time'                            => 'Tempo de Marketing',
                    'maximum-quantity-allowed-to-be-discounted' => 'Quantidade Máxima Permitida para Desconto',
                    'name'                                      => 'Nome',
                    'no'                                        => 'Não',
                    'no-coupon'                                 => 'Sem Cupom',
                    'parent-categories'                         => 'Categorias Principais',
                    'payment-method'                            => 'Método de Pagamento',
                    'percentage-product-price'                  => 'Porcentagem do Preço do Produto',
                    'price-in-cart'                             => 'Preço no Carrinho',
                    'priority'                                  => 'Prioridade',
                    'product-attribute'                         => 'Atributo do Produto',
                    'qty-in-cart'                               => 'Quantidade no Carrinho',
                    'save-btn'                                  => 'Salvar Regra de Carrinho',
                    'settings'                                  => 'Configurações',
                    'shipping-country'                          => 'País de Envio',
                    'shipping-method'                           => 'Método de Envio',
                    'shipping-postcode'                         => 'CEP de Envio',
                    'shipping-state'                            => 'Estado de Envio',
                    'specific-coupon'                           => 'Cupom Específico',
                    'status'                                    => 'Status',
                    'subtotal'                                  => 'Subtotal',
                    'title'                                     => 'Criar Regra de Carrinho',
                    'to'                                        => 'Para',
                    'total-items-qty'                           => 'Quantidade Total de Itens',
                    'total-weight'                              => 'Peso Total',
                    'uses-per-coupon'                           => 'Usos por Cupom',
                    'uses-per-customer'                         => 'Usos por Cliente',
                    'uses-per-customer-control-info'            => 'Será usado apenas para clientes logados.',
                    'yes'                                       => 'Sim',
                ],

                'edit' => [
                    'action-type'                               => 'Tipo de Ação',
                    'actions'                                   => 'Ações',
                    'add-condition'                             => 'Adicionar Condição',
                    'additional'                                => 'Adicional',
                    'all-conditions-true'                       => 'Todas as Condições Verdadeiras',
                    'alphabetical'                              => 'Alfabético',
                    'alphanumeric'                              => 'Alfanumérico',
                    'any-conditions-true'                       => 'Qualquer Condição Verdadeira',
                    'apply-to-shipping'                         => 'Aplicar ao Envio',
                    'attribute-family'                          => 'Família de Atributos',
                    'attribute-name-children-only'              => 'Nome do Atributo Somente para Categorias Filhas',
                    'attribute-name-parent-only'                => 'Nome do Atributo Somente para Categorias Principais',
                    'auto-generate-coupon'                      => 'Gerar Cupom Automaticamente',
                    'back-btn'                                  => 'Voltar',
                    'buy-x-get-y-free'                          => 'Compre X e Leve Y de Graça',
                    'buy-x-quantity'                            => 'Compre X Quantidade',
                    'cart-attribute'                            => 'Atributo do Carrinho',
                    'cart-item-attribute'                       => 'Atributo do Item do Carrinho',
                    'categories'                                => 'Categorias',
                    'channels'                                  => 'Canais',
                    'children-categories'                       => 'Categorias Filhas',
                    'choose-condition-to-add'                   => 'Escolha a condição para adicionar',
                    'code-format'                               => 'Formato do Código',
                    'code-prefix'                               => 'Prefixo do Código',
                    'code-suffix'                               => 'Sufixo do Código',
                    'condition-type'                            => 'Tipo de Condição',
                    'conditions'                                => 'Condições',
                    'contain'                                   => 'Contém',
                    'contains'                                  => 'Contém',
                    'coupon-code'                               => 'Código do Cupom',
                    'coupon-length'                             => 'Comprimento do Cupom',
                    'coupon-qty'                                => 'Quantidade de Cupons',
                    'coupon-type'                               => 'Tipo de Cupom',
                    'customer-group'                            => 'Grupo de Clientes',
                    'customer-groups'                           => 'Grupos de Clientes',
                    'description'                               => 'Descrição',
                    'discount-amount'                           => 'Valor de Desconto',
                    'does-not-contain'                          => 'Não Contém',
                    'end-of-other-rules'                        => 'Fim de Outras Regras',
                    'equals-or-greater-than'                    => 'Igual ou Maior Que',
                    'equals-or-less-than'                       => 'Igual ou Menor Que',
                    'fixed-amount'                              => 'Valor Fixo',
                    'fixed-amount-whole-cart'                   => 'Valor Fixo para o Carrinho Inteiro',
                    'free-shipping'                             => 'Frete Grátis',
                    'from'                                      => 'De',
                    'general'                                   => 'Geral',
                    'generate'                                  => 'Gerar',
                    'greater-than'                              => 'Maior Que',
                    'is-equal-to'                               => 'É Igual a',
                    'is-not-equal-to'                           => 'Não é Igual a',
                    'less-than'                                 => 'Menor Que',
                    'marketing-time'                            => 'Tempo de Marketing',
                    'maximum-quantity-allowed-to-be-discounted' => 'Quantidade Máxima Permitida para Desconto',
                    'name'                                      => 'Nome',
                    'no'                                        => 'Não',
                    'no-coupon'                                 => 'Sem Cupom',
                    'numeric'                                   => 'Numérico',
                    'parent-categories'                         => 'Categorias Principais',
                    'payment-method'                            => 'Método de Pagamento',
                    'percentage-product-price'                  => 'Porcentagem do Preço do Produto',
                    'price-in-cart'                             => 'Preço no Carrinho',
                    'priority'                                  => 'Prioridade',
                    'product-attribute'                         => 'Atributo do Produto',
                    'qty-in-cart'                               => 'Quantidade no Carrinho',
                    'save-btn'                                  => 'Salvar Regra de Carrinho',
                    'settings'                                  => 'Configurações',
                    'shipping-country'                          => 'País de Envio',
                    'shipping-method'                           => 'Método de Envio',
                    'shipping-postcode'                         => 'CEP de Envio',
                    'shipping-state'                            => 'Estado de Envio',
                    'specific-coupon'                           => 'Cupom Específico',
                    'status'                                    => 'Status',
                    'subtotal'                                  => 'Subtotal',
                    'title'                                     => 'Editar Regra de Carrinho',
                    'to'                                        => 'Para',
                    'total-items-qty'                           => 'Quantidade Total de Itens',
                    'total-weight'                              => 'Peso Total',
                    'update-success'                            => 'Regra de Carrinho atualizada com sucesso',
                    'uses-per-coupon'                           => 'Usos por Cupom',
                    'uses-per-customer'                         => 'Usos por Cliente',
                    'uses-per-customer-control-info'            => 'Será usado apenas para clientes logados.',
                    'yes'                                       => 'Sim',
                ],

                'delete-failed'  => 'Falha na exclusão da Regra de Carrinho',
                'delete-success' => 'Regra de Carrinho excluída com sucesso',
            ],

            'catalog-rules' => [
                'index' => [
                    'create-btn' => 'Criar Regra de Catálogo',
                    'title'      => 'Regras de Catálogo',

                    'datagrid' => [
                        'active'   => 'Ativo',
                        'delete'   => 'Excluir',
                        'edit'     => 'Editar',
                        'end'      => 'Fim',
                        'id'       => 'ID',
                        'inactive' => 'Inativo',
                        'name'     => 'Nome',
                        'priority' => 'Prioridade',
                        'start'    => 'Início',
                        'status'   => 'Status',
                    ],
                ],

                'create' => [
                    'action-type'              => 'Tipo de Ação',
                    'actions'                  => 'Ações',
                    'add-condition'            => 'Adicionar Condição',
                    'all-conditions-true'      => 'Todas as Condições são verdadeiras',
                    'any-conditions-true'      => 'Qualquer Condição é verdadeira',
                    'attribute-family'         => 'Família de Atributos',
                    'back-btn'                 => 'Voltar',
                    'categories'               => 'Categorias',
                    'channels'                 => 'Canais',
                    'choose-condition-to-add'  => 'Escolher Condição para Adicionar',
                    'condition-type'           => 'Tipo de Condição',
                    'conditions'               => 'Condições',
                    'contain'                  => 'Contém',
                    'contains'                 => 'Contém',
                    'customer-groups'          => 'Grupos de Clientes',
                    'description'              => 'Descrição',
                    'discount-amount'          => 'Valor do Desconto',
                    'does-not-contain'         => 'Não contém',
                    'end-other-rules'          => 'Finalizar outras regras',
                    'equals-or-greater-than'   => 'Igual ou maior que',
                    'equals-or-less-than'      => 'Igual ou menor que',
                    'fixed-amount'             => 'Valor Fixo',
                    'from'                     => 'De',
                    'general'                  => 'Geral',
                    'greater-than'             => 'Maior que',
                    'is-equal-to'              => 'É igual a',
                    'is-not-equal-to'          => 'Não é igual a',
                    'less-than'                => 'Menor que',
                    'marketing-time'           => 'Tempo de Marketing',
                    'name'                     => 'Nome',
                    'no'                       => 'Não',
                    'percentage-product-price' => 'Porcentagem do Preço do Produto',
                    'priority'                 => 'Prioridade',
                    'product-attribute'        => 'Atributo do Produto',
                    'save-btn'                 => 'Salvar Regra de Catálogo',
                    'settings'                 => 'Configurações',
                    'status'                   => 'Status',
                    'title'                    => 'Criar Regra de Catálogo',
                    'to'                       => 'Para',
                    'yes'                      => 'Sim',
                ],

                'edit' => [
                    'action-type'              => 'Tipo de Ação',
                    'actions'                  => 'Ações',
                    'add-condition'            => 'Adicionar Condição',
                    'all-conditions-true'      => 'Todas as Condições são verdadeiras',
                    'any-conditions-true'      => 'Qualquer Condição é verdadeira',
                    'back-btn'                 => 'Voltar',
                    'categories'               => 'Categorias',
                    'channels'                 => 'Canais',
                    'choose-condition-to-add'  => 'Escolher Condição para Adicionar',
                    'condition-type'           => 'Tipo de Condição',
                    'conditions'               => 'Condições',
                    'contain'                  => 'Contém',
                    'contains'                 => 'Contém',
                    'customer-groups'          => 'Grupos de Clientes',
                    'description'              => 'Descrição',
                    'discount-amount'          => 'Valor do Desconto',
                    'does-not-contain'         => 'Não contém',
                    'end-other-rules'          => 'Finalizar outras regras',
                    'equals-or-greater-than'   => 'Igual ou maior que',
                    'equals-or-less-than'      => 'Igual ou menor que',
                    'fixed-amount'             => 'Valor Fixo',
                    'from'                     => 'De',
                    'general'                  => 'Geral',
                    'greater-than'             => 'Maior que',
                    'is-equal-to'              => 'É igual a',
                    'is-not-equal-to'          => 'Não é igual a',
                    'less-than'                => 'Menor que',
                    'marketing-time'           => 'Tempo de Marketing',
                    'name'                     => 'Nome',
                    'no'                       => 'Não',
                    'percentage-product-price' => 'Porcentagem do Preço do Produto',
                    'priority'                 => 'Prioridade',
                    'product-attribute'        => 'Atributo do Produto',
                    'save-btn'                 => 'Salvar Regra de Catálogo',
                    'settings'                 => 'Configurações',
                    'status'                   => 'Status',
                    'title'                    => 'Editar Regra de Catálogo',
                    'to'                       => 'Para',
                    'yes'                      => 'Sim',
                ],

                'create-success' => 'Regra de catálogo criada com sucesso',
                'delete-success' => 'Regra de catálogo excluída com sucesso',
                'update-success' => 'Regra de catálogo atualizada com sucesso',
            ],

            'cart-rules-coupons' => [
                'cart-rule-not-defined-error' => 'Regra do carrinho não pode ser excluída',
                'delete-success'              => 'Cupom da regra do carrinho excluído com sucesso',
                'mass-delete-success'         => 'Itens selecionados excluídos com sucesso',
                'success'                     => ':name criado com sucesso',

                'datagrid' => [
                    'coupon-code'     => 'Código do cupom',
                    'created-date'    => 'Data de criação',
                    'delete'          => 'Excluir',
                    'expiration-date' => 'Data de validade',
                    'id'              => 'ID',
                    'times-used'      => 'Vezes utilizado',
                ],
            ],
        ],

        'search-seo' => [
            'search-terms' => [
                'index' => [
                    'create-btn' => 'Criar novo termo de pesquisa',
                    'title'      => 'Termos de pesquisa',

                    'datagrid' => [
                        'actions'             => 'Ações',
                        'channel'             => 'Canal',
                        'delete'              => 'Excluir',
                        'edit'                => 'Editar',
                        'id'                  => 'ID',
                        'locale'              => 'Configurações regionais',
                        'mass-delete-success' => 'Termos de pesquisa selecionados excluídos com sucesso',
                        'redirect-url'        => 'URL de redirecionamento',
                        'results'             => 'Resultados',
                        'search-query'        => 'Consulta de pesquisa',
                        'uses'                => 'Usos',
                    ],

                    'create' => [
                        'channel'        => 'Canal',
                        'delete-warning' => 'Tem certeza de que deseja executar esta ação?',
                        'locale'         => 'Configurações regionais',
                        'redirect-url'   => 'URL de redirecionamento',
                        'results'        => 'Resultados',
                        'save-btn'       => 'Salvar termo de pesquisa',
                        'search-query'   => 'Consulta de pesquisa',
                        'success'        => 'Termo de pesquisa criado com sucesso',
                        'title'          => 'Criar novo termo de pesquisa',
                        'uses'           => 'Usos',
                    ],

                    'edit' => [
                        'delete-success' => 'Termo de pesquisa excluído com sucesso',
                        'success'        => 'Termo de pesquisa atualizado com sucesso',
                        'title'          => 'Editar termo de pesquisa',
                    ],
                ],
            ],

            'search-synonyms' => [
                'index' => [
                    'create-btn' => 'Criar Sinônimo de Pesquisa',
                    'title'      => 'Sinônimos de Pesquisa',

                    'datagrid' => [
                        'actions'             => 'Ações',
                        'delete'              => 'Excluir',
                        'edit'                => 'Editar',
                        'id'                  => 'ID',
                        'mass-delete-success' => 'Sinônimos de Pesquisa Selecionados Excluídos com Sucesso',
                        'name'                => 'Nome',
                        'terms'               => 'Termos',
                    ],

                    'create' => [
                        'delete-warning' => 'Tem certeza de que deseja executar esta ação?',
                        'name'           => 'Nome',
                        'save-btn'       => 'Salvar Sinônimo de Pesquisa',
                        'success'        => 'Sinônimo de Pesquisa criado com sucesso',
                        'terms'          => 'Termos',
                        'terms-info'     => 'Digite sinônimos como uma lista separada por vírgulas, por exemplo, "sapatos, calçados." Isso amplia a pesquisa para incluir todos os termos.',
                        'title'          => 'Criar Sinônimo de Pesquisa',
                    ],

                    'edit' => [
                        'delete-success' => 'Sinônimo de Pesquisa excluído com sucesso',
                        'success'        => 'Sinônimo de Pesquisa atualizado com sucesso',
                        'title'          => 'Editar Sinônimo de Pesquisa',
                    ],
                ],
            ],

            'sitemaps' => [
                'index' => [
                    'create-btn' => 'Criar Mapa do Site',
                    'sitemap'    => 'Mapa do Site',
                    'title'      => 'Mapas do Site',

                    'datagrid' => [
                        'actions'         => 'Ações',
                        'delete'          => 'Excluir',
                        'edit'            => 'Editar',
                        'file-name'       => 'Nome do Arquivo',
                        'id'              => 'ID',
                        'link-for-google' => 'Link para o Google',
                        'path'            => 'Caminho',
                    ],

                    'create' => [
                        'delete-warning' => 'Você tem certeza de que deseja executar esta ação?',
                        'file-name'      => 'Nome do Arquivo',
                        'file-name-info' => 'Exemplo: sitemap.xml',
                        'path'           => 'Caminho',
                        'path-info'      => 'Exemplo: "/sitemap/" ou "/" para o caminho base',
                        'save-btn'       => 'Salvar Mapa do Site',
                        'success'        => 'Mapa do Site criado com sucesso',
                        'title'          => 'Criar Mapa do Site',
                    ],

                    'edit' => [
                        'delete-success' => 'Mapa do Site excluído com sucesso',
                        'success'        => 'Mapa do Site atualizado com sucesso',
                        'title'          => 'Editar Mapa do Site',
                    ],
                ],

                'edit' => [
                    'save-btn'       => 'Salvar Mapa do Site',
                    'path-info'      => 'Exemplo: "/sitemap/" ou "/" para o caminho base',
                    'path'           => 'Caminho',
                    'general'        => 'Geral',
                    'file-name-info' => 'Exemplo: sitemap.xml',
                    'file-name'      => 'Nome do Arquivo',
                    'back-btn'       => 'Voltar',
                ],

                'delete-failed' => ':name Exclusão Falhou',
            ],

            'url-rewrites' => [
                'index' => [
                    'create-btn' => 'Criar nova reescrita de URL',
                    'title'      => 'Reescritas de URL',

                    'datagrid' => [
                        'actions'             => 'Ações',
                        'category'            => 'Categoria',
                        'cms-page'            => 'Página CMS',
                        'delete'              => 'Excluir',
                        'edit'                => 'Editar',
                        'for'                 => 'Para',
                        'id'                  => 'ID',
                        'locale'              => 'Localidade',
                        'mass-delete-success' => 'As reescritas de URL selecionadas foram excluídas com sucesso.',
                        'permanent-redirect'  => 'Redirecionamento permanente (301)',
                        'product'             => 'Produto',
                        'redirect-type'       => 'Tipo de redirecionamento',
                        'request-path'        => 'Caminho da solicitação',
                        'target-path'         => 'Caminho de destino',
                        'temporary-redirect'  => 'Redirecionamento temporário (302)',
                    ],

                    'create' => [
                        'category'           => 'Categoria',
                        'cms-page'           => 'Página CMS',
                        'delete-warning'     => 'Tem certeza de que deseja realizar esta ação?',
                        'for'                => 'Para',
                        'locale'             => 'Localidade',
                        'permanent-redirect' => 'Redirecionamento permanente (301)',
                        'product'            => 'Produto',
                        'redirect-type'      => 'Tipo de redirecionamento',
                        'request-path'       => 'Caminho da solicitação',
                        'save-btn'           => 'Salvar reescrita de URL',
                        'success'            => 'Reescrita de URL criada com sucesso.',
                        'target-path'        => 'Caminho de destino',
                        'temporary-redirect' => 'Redirecionamento temporário (302)',
                        'title'              => 'Criar nova reescrita de URL',
                    ],

                    'edit' => [
                        'delete-success' => 'Reescrita de URL excluída com sucesso.',
                        'success'        => 'Reescrita de URL atualizada com sucesso.',
                        'title'          => 'Editar reescrita de URL',
                    ],
                ],
            ],
        ],
    ],

    'cms' => [
        'index' => [
            'already-taken' => 'O :name já foi utilizado.',
            'create-btn'    => 'Criar Página',
            'channel'       => 'Canal',
            'language'      => 'Idioma',
            'title'         => 'Páginas',

            'datagrid' => [
                'channel'             => 'Canal',
                'delete'              => 'Excluir',
                'edit'                => 'Editar',
                'id'                  => 'ID',
                'mass-delete-success' => 'Dados Selecionados Excluídos com Sucesso',
                'page-title'          => 'Título da Página',
                'url-key'             => 'Chave de URL',
                'view'                => 'Ver',
            ],
        ],

        'create' => [
            'channels'         => 'Canais',
            'content'          => 'Conteúdo',
            'description'      => 'Descrição',
            'general'          => 'Geral',
            'meta-description' => 'Meta Descrição',
            'meta-keywords'    => 'Meta Palavras-chave',
            'meta-title'       => 'Meta Título',
            'page-title'       => 'Título',
            'save-btn'         => 'Salvar Página',
            'seo'              => 'SEO',
            'title'            => 'Criar Página',
            'url-key'          => 'Chave de URL',
        ],

        'edit' => [
            'back-btn'         => 'Voltar',
            'channels'         => 'Canais',
            'content'          => 'Conteúdo',
            'description'      => 'Descrição',
            'general'          => 'Geral',
            'meta-description' => 'Meta Descrição',
            'meta-keywords'    => 'Meta Palavras-chave',
            'meta-title'       => 'Meta Título',
            'page-title'       => 'Título da Página',
            'preview-btn'      => 'Visualizar Página',
            'save-btn'         => 'Salvar Página',
            'seo'              => 'SEO',
            'title'            => 'Editar Página',
            'url-key'          => 'Chave de URL',
        ],

        'create-success' => 'CMS criado com sucesso.',
        'delete-success' => 'CMS excluído com sucesso.',
        'no-resource'    => 'Recurso não existe.',
        'update-success' => 'CMS atualizado com sucesso.',
    ],

    'settings' => [
        'locales'           => [
            'index' => [
                'create-btn' => 'Criar Idioma',
                'locale'     => 'Idioma',
                'logo-size'  => 'A resolução da imagem deve ser de 24px x 16px',
                'title'      => 'Idiomas',

                'datagrid' => [
                    'actions'   => 'Ações',
                    'code'      => 'Código',
                    'delete'    => 'Excluir',
                    'direction' => 'Direção',
                    'edit'      => 'Editar',
                    'id'        => 'ID',
                    'ltr'       => 'LTR',
                    'name'      => 'Nome',
                    'rtl'       => 'RTL',
                ],

                'create' => [
                    'code'             => 'Código',
                    'direction'        => 'Direção',
                    'locale-logo'      => 'Logo do Idioma',
                    'name'             => 'Nome',
                    'save-btn'         => 'Salvar Idioma',
                    'select-direction' => 'Selecionar direção',
                    'title'            => 'Criar Idioma',
                ],

                'edit' => [
                    'title' => 'Editar Idiomas',
                ],

                'create-success'    => 'Idioma criado com sucesso.',
                'delete-failed'     => 'Falha na exclusão do idioma',
                'delete-success'    => 'Idioma excluído com sucesso.',
                'delete-warning'    => 'Tem certeza de que deseja executar esta ação?',
                'last-delete-error' => 'Pelo menos um idioma é obrigatório.',
                'update-success'    => 'Idioma atualizado com sucesso.',
            ],
        ],

        'currencies' => [
            'index' => [
                'create-btn' => 'Criar Moeda',
                'currency'   => 'Moeda',
                'title'      => 'Moedas',

                'datagrid' => [
                    'actions'        => 'Ações',
                    'code'           => 'Código',
                    'delete'         => 'Excluir',
                    'edit'           => 'Editar',
                    'id'             => 'ID',
                    'method-error'   => 'Erro! Método incorreto detectado, verifique a configuração de ações em massa',
                    'name'           => 'Nome',
                    'no-resource'    => 'O recurso fornecido é insuficiente para a ação',
                    'partial-action' => 'Algumas ações não foram executadas devido a restrições do sistema em :resource',
                    'update-success' => ':resource selecionada foi atualizada com sucesso',
                ],

                'create' => [
                    'code'              => 'Código',
                    'create-btn'        => 'Criar Moeda',
                    'currency-position' => 'Posição da Moeda',
                    'decimal'           => 'Casas Decimais',
                    'decimal-separator' => 'Separador decimal',
                    'delete-warning'    => 'Tem certeza de que deseja executar esta ação?',
                    'general'           => 'Geral',
                    'group-separator'   => 'Separador de Grupo',
                    'name'              => 'Nome',
                    'save-btn'          => 'Salvar Moeda',
                    'symbol'            => 'Símbolo',
                    'title'             => 'Criar Nova Moeda',
                ],

                'edit' => [
                    'title' => 'Editar Moeda',
                ],

                'create-success'    => 'Moeda criada com sucesso.',
                'delete-failed'     => 'Falha na exclusão da Moeda',
                'delete-success'    => 'Moeda excluída com sucesso.',
                'last-delete-error' => 'Pelo menos uma Moeda é obrigatória.',
                'update-success'    => 'Moeda atualizada com sucesso.',
            ],
        ],

        'data-transfer' => [
            'imports' => [
                'create' => [
                    'action'              => 'Ação',
                    'allowed-errors'      => 'Erros permitidos',
                    'back-btn'            => 'Voltar',
                    'create-update'       => 'Criar/Atualizar',
                    'delete'              => 'Excluir',
                    'download-sample'     => 'Baixar Exemplo',
                    'field-separator'     => 'Separador de Campos',
                    'file-info-example'   => 'Por exemplo, em caso de product-images, os arquivos devem ser colocados na pasta /project-root/storage/app/import/product-images.',
                    'file-info'           => 'Use a referência de caminho para /project-root/storage/app/import, por exemplo, product-images, import-images.',
                    'file'                => 'Arquivo',
                    'general'             => 'Geral',
                    'images-directory'    => 'Caminho da Pasta de Imagens',
                    'process-in-queue'    => 'Processar na Fila',
                    'results'             => 'Resultados',
                    'save-btn'            => 'Salvar Importação',
                    'settings'            => 'Configurações',
                    'skip-errors'         => 'Ignorar Erros',
                    'stop-on-errors'      => 'Pare em Erros',
                    'title'               => 'Criar Importação',
                    'type'                => 'Tipo',
                    'validation-strategy' => 'Estratégia de Validação',
                ],

                'edit' => [
                    'action'              => 'Ação',
                    'allowed-errors'      => 'Erros permitidos',
                    'back-btn'            => 'Voltar',
                    'create-update'       => 'Criar/Atualizar',
                    'delete'              => 'Excluir',
                    'download-sample'     => 'Baixar Exemplo',
                    'field-separator'     => 'Separador de Campos',
                    'file-info-example'   => 'Por exemplo, em caso de product-images, os arquivos devem ser colocados na pasta /project-root/storage/app/import/product-images.',
                    'file-info'           => 'Use a referência de caminho para /project-root/storage/app/import, por exemplo, product-images, import-images.',
                    'file'                => 'Arquivo',
                    'general'             => 'Geral',
                    'images-directory'    => 'Caminho da Pasta de Imagens',
                    'process-in-queue'    => 'Processar na Fila',
                    'results'             => 'Resultados',
                    'save-btn'            => 'Salvar Importação',
                    'settings'            => 'Configurações',
                    'skip-errors'         => 'Ignorar Erros',
                    'stop-on-errors'      => 'Pare em Erros',
                    'title'               => 'Editar Importação',
                    'type'                => 'Tipo',
                    'validation-strategy' => 'Estratégia de Validação',
                ],

                'index' => [
                    'button-title' => 'Criar Importação',
                    'title'        => 'Importações',

                    'datagrid' => [
                        'actions'       => 'Ações',
                        'completed-at'  => 'Concluído em',
                        'created'       => 'Criado',
                        'delete'        => 'Excluir',
                        'deleted'       => 'Excluído',
                        'edit'          => 'Editar',
                        'error-file'    => 'Arquivo de Erro',
                        'id'            => 'ID',
                        'started-at'    => 'Iniciado em',
                        'state'         => 'Estado',
                        'summary'       => 'Resumo',
                        'updated'       => 'Atualizado',
                        'uploaded-file' => 'Arquivo Carregado',
                    ],
                ],

                'import' => [
                    'back-btn'                => 'Voltar',
                    'completed-batches'       => 'Lotes Concluídos Totais:',
                    'download-error-report'   => 'Baixar Relatório Completo',
                    'edit-btn'                => 'Editar',
                    'imported-info'           => 'Parabéns! A importação foi bem-sucedida.',
                    'importing-info'          => 'Importação em Processo',
                    'indexing-info'           => 'Indexação de Recursos (Preço, Estoque e Elasticsearch) em Progresso',
                    'linking-info'            => 'Vinculação de Recursos em Progresso',
                    'progress'                => 'Progresso:',
                    'title'                   => 'Importação',
                    'total-batches'           => 'Lotes Totais:',
                    'total-created'           => 'Registros Criados Totais:',
                    'total-deleted'           => 'Registros Excluídos Totais:',
                    'total-errors'            => 'Erros Totais:',
                    'total-invalid-rows'      => 'Linhas Inválidas Totais:',
                    'total-rows-processed'    => 'Linhas Processadas Totais:',
                    'total-updated'           => 'Registros Atualizados Totais:',
                    'validate-info'           => 'Clique em Validar Dados para verificar sua importação.',
                    'validate'                => 'Validar',
                    'validating-info'         => 'Os dados começaram a ser lidos e validados',
                    'validation-failed-info'  => 'Sua importação é inválida. Por favor, corrija os seguintes erros e tente novamente.',
                    'validation-success-info' => 'Sua importação é válida. Clique em Importar para iniciar o processo de importação.',
                ],

                'create-success'    => 'Importação criada com sucesso.',
                'delete-failed'     => 'Falha ao excluir a importação inesperadamente.',
                'delete-success'    => 'Importação excluída com sucesso.',
                'not-valid'         => 'Importação inválida',
                'nothing-to-import' => 'Não há recursos para importar.',
                'setup-queue-error' => 'Por favor, altere o driver de fila para "banco de dados" ou "redis" para iniciar o processo de importação.',
                'update-success'    => 'Importação atualizada com sucesso.',
            ],
        ],

        'exchange-rates' => [
            'index' => [
                'create-btn'    => 'Criar Taxa de Câmbio',
                'exchange-rate' => 'Taxa de Câmbio',
                'title'         => 'Taxas de Câmbio',
                'update-rates'  => 'Atualizar Taxa de Câmbio',

                'create' => [
                    'delete-warning'         => 'Tem certeza de que deseja executar esta ação?',
                    'rate'                   => 'Taxa',
                    'save-btn'               => 'Salvar Taxa de Câmbio',
                    'select-target-currency' => 'Selecionar moeda de destino',
                    'source-currency'        => 'Moeda de Origem',
                    'target-currency'        => 'Moeda de Destino',
                    'title'                  => 'Criar Taxa de Câmbio',
                ],

                'edit' => [
                    'title' => 'Editar Taxas de Câmbio',
                ],

                'datagrid' => [
                    'actions'       => 'Ações',
                    'currency-name' => 'Nome da Moeda',
                    'delete'        => 'Excluir',
                    'edit'          => 'Editar',
                    'exchange-rate' => 'Taxa de Câmbio',
                    'id'            => 'ID',
                ],

                'create-success'  => 'Taxa de Câmbio criada com sucesso',
                'delete-error'    => 'Erro ao excluir a Taxa de Câmbio',
                'delete-success'  => 'Taxa de Câmbio excluída com sucesso',
                'update-success'  => 'Taxa de Câmbio atualizada com sucesso',
            ],
        ],

        'inventory-sources' => [
            'index' => [
                'create-btn' => 'Criar fonte de inventário',
                'title'      => 'Fontes de Inventário',

                'datagrid' => [
                    'active'   => 'Ativo',
                    'code'     => 'Código',
                    'delete'   => 'Excluir',
                    'edit'     => 'Editar',
                    'id'       => 'ID',
                    'inactive' => 'Inativo',
                    'name'     => 'Nome',
                    'priority' => 'Prioridade',
                    'status'   => 'Status',
                ],
            ],

            'create' => [
                'add-title'      => 'Adicionar Fonte de Inventário',
                'address'        => 'Endereço da Fonte',
                'back-btn'       => 'Voltar',
                'city'           => 'Cidade',
                'code'           => 'Código',
                'contact-email'  => 'E-mail',
                'contact-fax'    => 'Fax',
                'contact-info'   => 'Informações de Contato',
                'contact-name'   => 'Nome',
                'contact-number' => 'Número de Contato',
                'country'        => 'País',
                'description'    => 'Descrição',
                'general'        => 'Geral',
                'latitude'       => 'Latitude',
                'longitude'      => 'Longitude',
                'name'           => 'Nome',
                'postcode'       => 'Código Postal',
                'priority'       => 'Prioridade',
                'save-btn'       => 'Salvar Fontes de Inventário',
                'select-country' => 'Selecionar País',
                'select-state'   => 'Selecionar Estado',
                'settings'       => 'Configurações',
                'state'          => 'Estado',
                'status'         => 'Status',
                'street'         => 'Rua',
                'title'          => 'Fontes de Inventário',
            ],

            'edit' => [
                'back-btn'       => 'Voltar',
                'city'           => 'Cidade',
                'code'           => 'Código',
                'contact-email'  => 'E-mail',
                'contact-fax'    => 'Fax',
                'contact-info'   => 'Informações de Contato',
                'contact-name'   => 'Nome',
                'contact-number' => 'Número de Contato',
                'country'        => 'País',
                'description'    => 'Descrição',
                'general'        => 'Geral',
                'latitude'       => 'Latitude',
                'longitude'      => 'Longitude',
                'name'           => 'Nome',
                'postcode'       => 'Código Postal',
                'priority'       => 'Prioridade',
                'save-btn'       => 'Salvar Fontes de Inventário',
                'select-country' => 'Selecionar País',
                'select-state'   => 'Selecionar Estado',
                'settings'       => 'Configurações',
                'source-address' => 'Endereço da Fonte',
                'state'          => 'Estado',
                'status'         => 'Status',
                'street'         => 'Rua',
                'title'          => 'Editar Fontes de Inventário',
            ],

            'create-success'    => 'Fonte de Inventário criada com sucesso',
            'delete-failed'     => 'Falha ao excluir as Fontes de Inventário',
            'delete-success'    => 'Fontes de Inventário excluídas com sucesso',
            'last-delete-error' => 'Não é possível excluir as últimas Fontes de Inventário',
            'update-success'    => 'Fontes de Inventário atualizadas com sucesso',
        ],

        'taxes' => [
            'categories' => [
                'index' => [
                    'delete-warning' => 'Tem certeza de que deseja excluir?',
                    'tax-category'   => 'Categoria de Imposto',
                    'title'          => 'Categorias de Impostos',

                    'datagrid' => [
                        'actions' => 'Ações',
                        'code'    => 'Código',
                        'delete'  => 'Excluir',
                        'edit'    => 'Editar',
                        'id'      => 'ID',
                        'name'    => 'Nome',
                    ],

                    'create' => [
                        'add-tax-rates' => 'Adicionar Taxas de Imposto',
                        'code'          => 'Código',
                        'description'   => 'Descrição',
                        'empty-text'    => 'As Taxas de Imposto não estão disponíveis, por favor crie novas Taxas de Imposto.',
                        'general'       => 'Categoria de Imposto',
                        'name'          => 'Nome',
                        'save-btn'      => 'Salvar Categoria de Imposto',
                        'select'        => 'Selecionar',
                        'tax-rates'     => 'Taxas de Imposto',
                        'title'         => 'Criar Categoria de Imposto',
                    ],

                    'edit' => [
                        'title'   => 'Editar Categorias de Imposto',
                    ],

                    'create-success'  => 'Nova Categoria de Imposto criada',
                    'delete-failed'   => 'Falha ao excluir a Categoria de Imposto',
                    'delete-success'  => 'Categoria de Imposto excluída com sucesso',
                    'update-success'  => 'Categoria de Imposto atualizada com sucesso',
                ],
            ],

            'rates' => [
                'index' => [
                    'button-title' => 'Criar taxa de imposto',
                    'tax-rate'     => 'Taxa de Imposto',
                    'title'        => 'Taxas de Imposto',

                    'datagrid' => [
                        'country'    => 'País',
                        'delete'     => 'Excluir',
                        'edit'       => 'Editar',
                        'id'         => 'ID',
                        'identifier' => 'Identificador',
                        'state'      => 'Estado',
                        'tax-rate'   => 'Taxa de Imposto',
                        'zip-code'   => 'Código Postal',
                        'zip-from'   => 'De Código Postal',
                        'zip-to'     => 'Para Código Postal',
                    ],
                ],

                'create' => [
                    'back-btn'       => 'Voltar',
                    'country'        => 'País',
                    'general'        => 'Geral',
                    'identifier'     => 'Identificador',
                    'is-zip'         => 'Ativar Faixa de Código Postal',
                    'save-btn'       => 'Salvar Taxa de Imposto',
                    'select-country' => 'Selecionar País',
                    'select-state'   => 'Selecionar Estado',
                    'settings'       => 'Configurações',
                    'state'          => 'Estado',
                    'tax-rate'       => 'Taxa',
                    'title'          => 'Criar Taxa de Imposto',
                    'zip-code'       => 'Código Postal',
                    'zip-from'       => 'De Código Postal',
                    'zip-to'         => 'Para Código Postal',
                ],

                'edit' => [
                    'back-btn'       => 'Voltar',
                    'country'        => 'País',
                    'identifier'     => 'Identificador',
                    'save-btn'       => 'Salvar Taxa de Imposto',
                    'select-country' => 'Selecionar País',
                    'select-state'   => 'Selecionar Estado',
                    'settings'       => 'Configurações',
                    'state'          => 'Estado',
                    'tax-rate'       => 'Taxa',
                    'title'          => 'Editar Taxa de Imposto',
                    'zip-code'       => 'Código Postal',
                    'zip-from'       => 'De Código Postal',
                    'zip-to'         => 'Para Código Postal',
                ],

                'update-success' => 'Taxa de Imposto atualizada com sucesso',
                'delete-success' => 'Taxa de imposto excluída com sucesso',
                'delete-failed'  => 'Falha na exclusão da taxa de imposto',
                'create-success' => 'Taxa de imposto criada com sucesso.',
            ],
        ],

        'channels' => [
            'index' => [
                'create-btn'        => 'Criar Canal',
                'delete-failed'     => 'Canal Exclusão Falhou',
                'delete-success'    => 'Canal excluído com sucesso.',
                'last-delete-error' => 'Falha na exclusão do último canal.',
                'title'             => 'Canais',

                'datagrid' => [
                    'code'      => 'Código',
                    'delete'    => 'Excluir',
                    'edit'      => 'Editar',
                    'host-name' => 'Nome do Host',
                    'id'        => 'ID',
                    'name'      => 'Nome',
                ],
            ],

            'create' => [
                'allowed-ips'             => 'IPs Permitidos',
                'cancel'                  => 'Voltar',
                'code'                    => 'Código',
                'create-success'          => 'Canal criado com sucesso.',
                'currencies'              => 'Moedas',
                'currencies-and-locales'  => 'Moedas e Idiomas',
                'default-currency'        => 'Moeda Padrão',
                'default-locale'          => 'Idioma Padrão',
                'description'             => 'Descrição',
                'design'                  => 'Design',
                'favicon'                 => 'Favicon',
                'favicon-size'            => 'A resolução da imagem deve ser de 16px X 16px',
                'general'                 => 'Geral',
                'hostname'                => 'Nome do Host',
                'hostname-placeholder'    => 'https://www.example.com (Não adicione barra no final.)',
                'inventory-sources'       => 'Fontes de Inventário',
                'last-delete-error'       => 'Pelo menos um canal é obrigatório.',
                'locales'                 => 'Idiomas',
                'logo'                    => 'Logo',
                'logo-size'               => 'A resolução da imagem deve ser de 192px X 50px',
                'maintenance-mode-text'   => 'Mensagem',
                'name'                    => 'Nome',
                'root-category'           => 'Categoria Raiz',
                'save-btn'                => 'Salvar Canal',
                'select-default-currency' => 'Selecionar moeda padrão',
                'select-default-locale'   => 'Selecionar idioma padrão',
                'select-root-category'    => 'Selecionar categoria raiz',
                'select-theme'            => 'Selecionar tema',
                'seo'                     => 'SEO da Página Inicial',
                'seo-description'         => 'Descrição Meta',
                'seo-keywords'            => 'Palavras-chave Meta',
                'seo-title'               => 'Título Meta',
                'settings'                => 'Configurações',
                'status'                  => 'Status',
                'theme'                   => 'Tema',
                'title'                   => 'Criar Canal',
            ],

            'edit' => [
                'allowed-ips'            => 'IPs Permitidos',
                'back-btn'               => 'Voltar',
                'code'                   => 'Código',
                'currencies'             => 'Moedas',
                'currencies-and-locales' => 'Moedas e Idiomas',
                'default-currency'       => 'Moeda Padrão',
                'default-locale'         => 'Idioma Padrão',
                'description'            => 'Descrição',
                'design'                 => 'Design',
                'favicon'                => 'Favicon',
                'favicon-size'           => 'A resolução da imagem deve ser de 16px X 16px',
                'general'                => 'Geral',
                'hostname'               => 'Nome do Host',
                'hostname-placeholder'   => 'https://www.example.com (Não adicione barra no final.)',
                'inventory-sources'      => 'Fontes de Inventário',
                'last-delete-error'      => 'Pelo menos um canal é obrigatório.',
                'locales'                => 'Idiomas',
                'logo'                   => 'Logo',
                'logo-size'              => 'A resolução da imagem deve ser de 192px X 50px',
                'maintenance-mode'       => 'Modo de manutenção',
                'maintenance-mode-text'  => 'Mensagem',
                'name'                   => 'Nome',
                'root-category'          => 'Categoria Raiz',
                'save-btn'               => 'Salvar Canal',
                'seo'                    => 'SEO da Página Inicial',
                'seo-description'        => 'Descrição Meta',
                'seo-keywords'           => 'Palavras-chave Meta',
                'seo-title'              => 'Título Meta',
                'status'                 => 'Status',
                'theme'                  => 'Tema',
                'title'                  => 'Editar Canal',
                'update-success'         => 'Canal atualizado com sucesso',
            ],
        ],

        'users' => [
            'index' => [
                'admin' => 'Admin',
                'title' => 'Usuários',
                'user'  => 'Usuário',

                'create' => [
                    'confirm-password'  => 'Confirmar Senha',
                    'email'             => 'Email',
                    'name'              => 'Nome',
                    'password'          => 'Senha',
                    'role'              => 'Função',
                    'save-btn'          => 'Salvar Usuário',
                    'status'            => 'Status',
                    'title'             => 'Criar Usuário',
                    'upload-image-info' => 'Envie uma Imagem de Perfil (110px X 110px) em Formato PNG ou JPG',
                ],

                'datagrid' => [
                    'actions'  => 'Ações',
                    'active'   => 'Ativo',
                    'delete'   => 'Apagar',
                    'edit'     => 'Editar',
                    'email'    => 'Email',
                    'id'       => 'ID',
                    'inactive' => 'Inativo',
                    'name'     => 'Nome',
                    'role'     => 'Função',
                    'status'   => 'Status',
                ],

                'edit' => [
                    'title' => 'Editar Usuário',
                ],
            ],

            'edit' => [
                'back-btn'         => 'Voltar',
                'confirm-password' => 'Confirmar Senha',
                'email'            => 'Email',
                'general'          => 'Geral',
                'name'             => 'Nome',
                'password'         => 'Senha',
                'role'             => 'Função',
                'save-btn'         => 'Salvar Usuário',
                'status'           => 'Status',
                'title'            => 'Editar Usuário',
            ],

            'activate-warning'   => 'Sua conta ainda não foi ativada, entre em contato com o administrador.',
            'cannot-change'      => 'Não é possível alterar o usuário.',
            'create-success'     => 'Usuário criado com sucesso.',
            'delete-failed'      => 'Falha ao excluir usuário.',
            'delete-success'     => 'Usuário excluído com sucesso.',
            'delete-warning'     => 'Tem certeza de que deseja realizar esta ação?',
            'incorrect-password' => 'Senha incorreta',
            'last-delete-error'  => 'Falha ao excluir o último usuário.',
            'login-error'        => 'Verifique suas credenciais e tente novamente.',
            'update-success'     => 'Usuário atualizado com sucesso.',
        ],

        'roles' => [
            'index' => [
                'create-btn' => 'Criar Função',
                'title'      => 'Funções',

                'datagrid' => [
                    'custom'          => 'Customizado',
                    'all'             => 'Tudo',
                    'permission-type' => 'Tipo de Permissão',
                    'name'            => 'Nome',
                    'id'              => 'Id',
                    'edit'            => 'Editar',
                    'delete'          => 'Excluir',
                ],
            ],

            'create' => [
                'access-control' => 'Controle de Acesso',
                'all'            => 'Tudo',
                'back-btn'       => 'Voltar',
                'custom'         => 'Customizado',
                'description'    => 'Descrição',
                'general'        => 'Geral',
                'name'           => 'Nome',
                'permissions'    => 'Permissões',
                'save-btn'       => 'Salvar Função',
                'title'          => 'Criar Função',
            ],

            'edit' => [
                'access-control' => 'Controle de Acesso',
                'all'            => 'Tudo',
                'back-btn'       => 'Voltar',
                'custom'         => 'Customizado',
                'description'    => 'Descrição',
                'general'        => 'Geral',
                'name'           => 'Nome',
                'permissions'    => 'Permissões',
                'save-btn'       => 'Salvar Função',
                'title'          => 'Editar Função',
            ],

            'being-used'        => 'A função já está em uso por um usuário administrador',
            'create-success'    => 'Função criada com sucesso',
            'delete-failed'     => 'Falha ao excluir a função',
            'delete-success'    => 'Função excluída com sucesso',
            'last-delete-error' => 'A última função não pode ser excluída',
            'update-success'    => 'Função atualizada com sucesso',
        ],

        'themes' => [
            'index' => [
                'create-btn' => 'Criar Tema',
                'title'      => 'Temas',

                'datagrid' => [
                    'active'       => 'Ativo',
                    'channel_name' => 'Nome do Canal',
                    'delete'       => 'Excluir',
                    'id'           => 'ID',
                    'inactive'     => 'Inativo',
                    'name'         => 'Nome',
                    'sort-order'   => 'Ordem de Classificação',
                    'status'       => 'Status',
                    'theme'        => 'Tema',
                    'type'         => 'Tipo',
                    'view'         => 'Ver',
                ],
            ],

            'create' => [
                'name'       => 'Nome',
                'save-btn'   => 'Salvar tema',
                'sort-order' => 'Ordem de Classificação',
                'themes'     => 'Temas',
                'title'      => 'Criar Tema',

                'type' => [
                    'category-carousel' => 'Carrossel de Categoria',
                    'footer-links'      => 'Links do Rodapé',
                    'image-carousel'    => 'Carrossel de imagens',
                    'product-carousel'  => 'Carrossel de Produtos',
                    'services-content'  => 'Conteúdo de serviços',
                    'static-content'    => 'Conteúdo Estático',
                    'title'             => 'Tipo',
                ],
            ],

            'edit' => [
                'active'                        => 'Ativo',
                'add-filter-btn'                => 'Adicionar Filtro',
                'add-footer-link-btn'           => 'Adicionar Link do Rodapé',
                'add-image-btn'                 => 'Adicionar Imagem',
                'add-link'                      => 'Adicionar Link',
                'asc'                           => 'crescente',
                'back'                          => 'Voltar',
                'category-carousel'             => 'Carrossel de Categoria',
                'category-carousel-description' => 'Exiba categorias dinâmicas de forma atraente usando um carrossel de categoria responsivo.',
                'channels'                      => 'Canais',
                'column'                        => 'Coluna',
                'create-filter'                 => 'Criar Filtro',
                'css'                           => 'CSS',
                'delete'                        => 'Excluir',
                'desc'                          => 'decrescente',
                'edit'                          => 'Editar',
                'featured'                      => 'Destacado',
                'filter-title'                  => 'Título',
                'filters'                       => 'Filtros',
                'footer-link'                   => 'Links do Rodapé',
                'footer-link-description'       => 'Navegue por meio de links no rodapé para explorar o site de forma fácil e obter informações.',
                'footer-link-form-title'        => 'Link do Rodapé',
                'footer-title'                  => 'Título',
                'general'                       => 'Geral',
                'html'                          => 'HTML',
                'image'                         => 'Imagem',
                'image-size'                    => 'O tamanho da imagem deve ser (1920px X 700px)',
                'image-title'                   => 'Título da imagem',
                'image-upload-message'          => 'Somente imagens (.jpeg, .jpg, .png, .webp, ..) são permitidas.',
                'inactive'                      => 'Inativo',
                'key'                           => 'Chave: :key',
                'key-input'                     => 'Chave',
                'limit'                         => 'Limite',
                'link'                          => 'Link',
                'name'                          => 'Nome',
                'new'                           => 'Novo',
                'no'                            => 'Não',
                'parent-id'                     => 'ID do Pai',
                'category-id'                   => 'ID de categoria',
                'preview'                       => 'Visualização',
                'product-carousel'              => 'Carrossel de Produtos',
                'product-carousel-description'  => 'Apresente produtos de forma elegante com um carrossel de produtos dinâmico e responsivo.',
                'save-btn'                      => 'Salvar',
                'select'                        => 'Selecionar',
                'slider'                        => 'Slider',
                'slider-add-btn'                => 'Adicionar Slider',
                'slider-description'            => 'Personalização relacionada ao slider.',
                'slider-image'                  => 'Imagem do Slider',
                'slider-required'               => 'Campo do slider é obrigatório.',
                'sort'                          => 'Ordenar',
                'sort-order'                    => 'Ordem de Classificação',
                'static-content'                => 'Conteúdo Estático',
                'static-content-description'    => 'Melhore o engajamento com conteúdo estático conciso e informativo para seu público.',
                'status'                        => 'Status',
                'themes'                        => 'Temas',
                'title'                         => 'Editar Tema',
                'update-slider'                 => 'Atualizar Slider',
                'url'                           => 'URL',
                'value'                         => 'Valor: :value',
                'value-input'                   => 'Valor',

                'services-content' => [
                    'add-btn'            => 'Adicionar Serviços',
                    'channels'           => 'Canais',
                    'delete'             => 'Excluir',
                    'description'        => 'Descrição',
                    'general'            => 'Geral',
                    'name'               => 'Nome',
                    'save-btn'           => 'Salvar',
                    'service-icon'       => 'Ícone de serviço',
                    'service-icon-class' => 'Classe de ícone de serviço',
                    'service-info'       => 'Personalização de tema relacionada a serviços.',
                    'services'           => 'Serviços',
                    'sort-order'         => 'Ordem de classificação',
                    'status'             => 'Status',
                    'title'              => 'Título',
                    'update-service'     => 'Atualizar Serviços',
                ],
                'yes'                           => 'Sim',
            ],

            'create-success' => 'Tema criado com sucesso',
            'delete-success' => 'Tema excluído com sucesso',
            'update-success' => 'Tema atualizado com sucesso',
        ],
    ],

    'reporting' => [
        'sales' => [
            'index' => [
                'abandoned-carts'               => 'Carrinhos Abandonados',
                'abandoned-products'            => 'Produtos Abandonados',
                'abandoned-rate'                => 'Taxa de Abandono',
                'abandoned-revenue'             => 'Receita de Abandono',
                'added-to-cart'                 => 'Adicionados ao Carrinho',
                'added-to-cart-info'            => 'Apenas :progress visitantes adicionaram produtos ao carrinho',
                'all-channels'                  => 'Todos os Canais',
                'average-order-value-over-time' => 'Valor Médio de Pedido ao Longo do Tempo',
                'average-sales'                 => 'Valor Médio de Venda',
                'count'                         => 'Contagem',
                'end-date'                      => 'Data de Término',
                'id'                            => 'ID',
                'interval'                      => 'Intervalo',
                'name'                          => 'Nome',
                'orders'                        => 'Pedidos',
                'orders-over-time'              => 'Pedidos ao Longo do Tempo',
                'payment-method'                => 'Método de Pagamento',
                'product-views'                 => 'Visualizações de Produtos',
                'product-views-info'            => 'Apenas :progress visitantes visualizaram produtos',
                'purchase-funnel'               => 'Funil de Compra',
                'purchased'                     => 'Comprados',
                'purchased-info'                => 'Apenas :progress visitantes fizeram a compra',
                'refunds'                       => 'Reembolsos',
                'refunds-over-time'             => 'Reembolsos ao Longo do Tempo',
                'sales-over-time'               => 'Vendas ao Longo do Tempo',
                'shipping-collected'            => 'Cobrança de Frete',
                'shipping-collected-over-time'  => 'Cobrança de Frete ao Longo do Tempo',
                'start-date'                    => 'Data de Início',
                'tax-collected'                 => 'Cobrança de Impostos',
                'tax-collected-over-time'       => 'Cobrança de Impostos ao Longo do Tempo',
                'title'                         => 'Vendas',
                'top-payment-methods'           => 'Principais Métodos de Pagamento',
                'top-shipping-methods'          => 'Principais Métodos de Envio',
                'top-tax-categories'            => 'Principais Categorias de Impostos',
                'total'                         => 'Total',
                'total-orders'                  => 'Total de Pedidos',
                'total-sales'                   => 'Total de Vendas',
                'total-visits'                  => 'Total de visitas',
                'total-visits-info'             => 'Total de visitantes na loja',
                'view-details'                  => 'Ver Detalhes',
            ],
        ],

        'customers' => [
            'index' => [
                'all-channels'                => 'Todos os Canais',
                'count'                       => 'Contagem',
                'customers'                   => 'Clientes',
                'customers-over-time'         => 'Clientes ao Longo do Tempo',
                'customers-traffic'           => 'Tráfego de Clientes',
                'customers-with-most-orders'  => 'Clientes com Mais Pedidos',
                'customers-with-most-reviews' => 'Clientes com Mais Avaliações',
                'customers-with-most-sales'   => 'Clientes com Mais Vendas',
                'email'                       => 'E-mail',
                'end-date'                    => 'Data de Término',
                'id'                          => 'ID',
                'interval'                    => 'Intervalo',
                'name'                        => 'Nome',
                'orders'                      => 'Pedidos',
                'reviews'                     => 'Avaliações',
                'start-date'                  => 'Data de Início',
                'title'                       => 'Clientes',
                'top-customer-groups'         => 'Principais Grupos de Clientes',
                'total'                       => 'Total',
                'total-customers'             => 'Total de Clientes',
                'total-visitors'              => 'Total de Visitantes',
                'traffic-over-week'           => 'Tráfego ao Longo da Semana',
                'unique-visitors'             => 'Visitantes Únicos',
                'view-details'                => 'Ver Detalhes',
            ],
        ],

        'products' => [
            'index' => [
                'all-channels'                     => 'Todos os Canais',
                'channel'                          => 'Canal',
                'end-date'                         => 'Data de Término',
                'id'                               => 'ID',
                'interval'                         => 'Intervalo',
                'last-search-terms'                => 'Últimos termos de pesquisa',
                'locale'                           => 'Região',
                'name'                             => 'Nome',
                'orders'                           => 'Pedidos',
                'price'                            => 'Preço',
                'products-added-over-time'         => 'Produtos Adicionados ao Longo do Tempo',
                'products-with-most-reviews'       => 'Produtos com Mais Avaliações',
                'products-with-most-visits'        => 'Produtos com Mais Visitas',
                'quantities'                       => 'Quantidades',
                'quantities-sold-over-time'        => 'Quantidades Vendidas ao Longo do Tempo',
                'results'                          => 'Resultados',
                'revenue'                          => 'Receita',
                'reviews'                          => 'Avaliações',
                'search-term'                      => 'Termo de pesquisa',
                'start-date'                       => 'Data de Início',
                'title'                            => 'Produtos',
                'top-search-terms'                 => 'Termos de pesquisa principais',
                'top-selling-products-by-quantity' => 'Produtos Mais Vendidos por Quantidade',
                'top-selling-products-by-revenue'  => 'Produtos Mais Vendidos por Receita',
                'total'                            => 'Total',
                'total-products-added-to-wishlist' => 'Produtos Adicionados à Lista de Desejos',
                'total-sold-quantities'            => 'Quantidades Vendidas no Total',
                'uses'                             => 'Usos',
                'view-details'                     => 'Ver Detalhes',
                'visits'                           => 'Visitas',
            ],
        ],

        'view' => [
            'all-channels'  => 'Todos os Canais',
            'day'           => 'Dia',
            'end-date'      => 'Data de Término',
            'export-csv'    => 'Exportar para CSV',
            'export-xls'    => 'Exportar para XLS',
            'month'         => 'Mês',
            'not-available' => 'Nenhum registro disponível.',
            'start-date'    => 'Data de Início',
            'year'          => 'Ano',
        ],

        'empty' => [
            'info'  => 'Nenhum dado disponível para o intervalo selecionado',
            'title' => 'Nenhum dado disponível',
        ],
    ],

    'configuration' => [
        'index' => [
            'back-btn'                     => 'Voltar',
            'delete'                       => 'Excluir',
            'enable-at-least-one-payment'  => 'Ative pelo menos um método de pagamento.',
            'enable-at-least-one-shipping' => 'Ative pelo menos um método de envio.',
            'no-result-found'              => 'Nenhum resultado encontrado',
            'save-btn'                     => 'Salvar Configuração',
            'save-message'                 => 'Configuração salva com sucesso',
            'search'                       => 'Buscar',
            'select-country'               => 'Selecionar País',
            'select-state'                 => 'Selecionar Estado',
            'title'                        => 'Configuração',

            'general' => [
                'info'  => 'Definir opções de unidades.',
                'title' => 'Geral',

                'general' => [
                    'info'  => 'Definir opções de unidades.',
                    'title' => 'Geral',

                    'unit-options' => [
                        'info'        => 'Definir opções de unidades.',
                        'title'       => 'Opções de Unidade',
                        'title-info'  => 'Configure o peso em libras (lbs) ou quilogramas (kgs).',
                        'weight-unit' => 'Unidade de Peso',
                    ],

                    'breadcrumbs' => [
                        'shop'       => 'Migalhas de Pão da Loja',
                        'title'      => 'Migalhas de Pão',
                        'title-info' => 'Ativar ou desativar a navegação por migalhas de pão na loja.',
                    ],
                ],

                'content' => [
                    'info'  => 'Definir opções de comparação, opções de lista de desejos, opções de pesquisa de imagem, rodapé, alternar rodapé e scripts personalizados.',
                    'title' => 'Conteúdo',

                    'header-offer' => [
                        'title'             => 'Título da Oferta do Cabeçalho',
                        'title-info'        => 'Configure o Título da Oferta do Cabeçalho com título da oferta, título de redirecionamento e link de redirecionamento.',
                        'offer-title'       => 'Título da Oferta',
                        'redirection-title' => 'Título de Redirecionamento',
                        'redirection-link'  => 'Link de Redirecionamento',
                    ],

                    'custom-scripts' => [
                        'custom-css'        => 'CSS Personalizado',
                        'custom-javascript' => 'Javascript Personalizado',
                        'title'             => 'Scripts Personalizados',
                        'title-info'        => 'Scripts personalizados são pedaços de código personalizados criados para adicionar funções ou recursos específicos ao software, melhorando suas capacidades de forma única.',
                    ],
                ],

                'design' => [
                    'info'  => 'Definir logotipo e ícone de favicon.',
                    'title' => 'Design',

                    'admin-logo' => [
                        'favicon'    => 'Favicon',
                        'logo-image' => 'Imagem do Logotipo',
                        'title'      => 'Logotipo do Admin',
                        'title-info' => 'Configure imagens de logotipo e favicon para a interface do seu site para melhorar a marca e o reconhecimento.',
                    ],
                ],

                'magic-ai' => [
                    'info'  => 'Definir opções de Magic AI.',
                    'title' => 'Magic AI',

                    'settings' => [
                        'api-key'        => 'Chave da API',
                        'enabled'        => 'Habilitado',
                        'llm-api-domain' => 'Domínio da API LLM',
                        'organization'   => 'Organização',
                        'title'          => 'Configurações Gerais',
                        'title-info'     => 'Aprimore sua experiência com o recurso Magic AI inserindo sua exclusiva Chave da API e indicando a Organização pertinente para integração sem esforço. Assuma o controle de suas credenciais OpenAI e personalize as configurações de acordo com suas necessidades específicas.',
                    ],

                    'content-generation' => [
                        'category-description-prompt'      => 'Prompt de Descrição da Categoria',
                        'cms-page-content-prompt'          => 'Prompt de Conteúdo da Página CMS',
                        'enabled'                          => 'Habilitado',
                        'product-description-prompt'       => 'Prompt de Descrição do Produto',
                        'product-short-description-prompt' => 'Prompt de Descrição Curta do Produto',
                        'title'                            => 'Geração de Conteúdo',
                        'title-info'                       => 'Este recurso ativará o Magic AI para todos os editores WYSIWYG, onde você deseja gerenciar o conteúdo usando AI.<br/><br/>Quando ativado, vá para qualquer editor para gerar conteúdo.',
                    ],

                    'image-generation' => [
                        'enabled'    => 'Habilitado',
                        'title'      => 'Geração de Imagem',
                        'title-info' => 'Este recurso ativará o Magic AI para todos os uploads de imagem, onde você deseja gerar imagens usando DALL-E.<br/><br/>Quando ativado, vá para qualquer upload de imagem para gerar imagem.',
                    ],

                    'review-translation' => [
                        'dolphin-phi'       => 'Dolphin Phi',
                        'enabled'           => 'Habilitado',
                        'gpt-3-5-turbo'     => 'OpenAI gpt-3.5-turbo',
                        'llama2'            => 'Llama 2',
                        'llama2-uncensored' => 'Llama 2 Sem Censura',
                        'llama2:13b'        => 'Llama 2 13B',
                        'llama2:70b'        => 'Llama 2 70B',
                        'llava'             => 'LLaVA',
                        'mistral'           => 'Mistral',
                        'model'             => 'Modelo',
                        'orca-mini'         => 'Orca Mini',
                        'phi'               => 'Phi-2',
                        'starling-lm'       => 'Starling',
                        'title'             => 'Tradução de Avaliação',
                        'title-info'        => 'Forneça a opção ao cliente ou visitante de traduzir a avaliação do cliente para o inglês.<br/><br/>Quando ativado, vá para a avaliação e você encontrará o botão "Traduzir para o inglês" se a avaliação for diferente do inglês.',
                        'vicuna'            => 'Vicuna',
                    ],

                    'checkout-message' => [
                        'dolphin-phi'       => 'Dolphin Phi',
                        'enabled'           => 'Habilitado',
                        'gpt-3-5-turbo'     => 'OpenAI gpt-3.5-turbo',
                        'llama2'            => 'Llama 2',
                        'llama2-uncensored' => 'Llama 2 Sem Censura',
                        'llama2:13b'        => 'Llama 2 13B',
                        'llama2:70b'        => 'Llama 2 70B',
                        'llava'             => 'LLaVA',
                        'mistral'           => 'Mistral',
                        'model'             => 'Modelo',
                        'orca-mini'         => 'Orca Mini',
                        'phi'               => 'Phi-2',
                        'prompt'            => 'Prompt',
                        'starling-lm'       => 'Starling',
                        'title'             => 'Mensagem Personalizada de Checkout',
                        'title-info'        => 'Crie uma mensagem personalizada de checkout para os clientes na página de Agradecimento, adaptando o conteúdo para ressoar com as preferências individuais e aprimorar a experiência geral pós-compra.',
                        'vicuna'            => 'Vicuna',
                    ],
                ],
            ],

            'catalog' => [
                'info'  => 'Catálogo',
                'title' => 'Catálogo',

                'products' => [
                    'info'  => 'Página de visualização do produto, página de visualização do carrinho, vitrine, avaliação e compartilhamento social de atributos.',
                    'title' => 'Produtos',

                    'settings' => [
                        'compare-options'     => 'Opções de Comparação',
                        'image-search-option' => 'Opção de Busca por Imagem',
                        'title'               => 'Configurações',
                        'title-info'          => 'As configurações se referem a escolhas configuráveis que controlam o comportamento de um sistema, aplicativo ou dispositivo, adaptadas às preferências e requisitos do usuário.',
                        'wishlist-options'    => 'Opções de Lista de Desejos',
                    ],

                    'search' => [
                        'admin-mode'            => 'Modo de Busca do Admin',
                        'admin-mode-info'       => 'A Mega Busca, Datagrid e outras funcionalidades de busca no painel de administração serão baseadas no mecanismo de busca selecionado.',
                        'database'              => 'Banco de Dados',
                        'elastic'               => 'Elastic Search',
                        'max-query-length'      => 'Comprimento Máximo da Consulta',
                        'max-query-length-info' => 'Defina o comprimento máximo da consulta para consultas de pesquisa.',
                        'min-query-length'      => 'Comprimento Mínimo da Consulta',
                        'min-query-length-info' => 'Defina o comprimento mínimo da consulta para consultas de pesquisa.',
                        'search-engine'         => 'Mecanismo de Busca',
                        'storefront-mode'       => 'Modo de Busca da Frente da Loja',
                        'storefront-mode-info'  => 'A funcionalidade de busca na frente da loja será baseada no mecanismo de busca selecionado, incluindo a página de categoria, página de pesquisa e outras funcionalidades de busca.',
                        'title'                 => 'Busca',
                        'title-info'            => 'Para configurar o mecanismo de busca para pesquisas de produtos, você pode escolher entre um banco de dados e o Elasticsearch com base em seus requisitos. Se você tiver um grande número de produtos, o Elasticsearch é recomendado.',
                    ],

                    'guest-checkout' => [
                        'allow-guest-checkout'      => 'Permitir Checkout de Convidado',
                        'allow-guest-checkout-hint' => 'Dica: Se ativado, essa opção pode ser configurada para cada produto especificamente.',
                        'title'                     => 'Checkout de Convidado',
                        'title-info'                => 'O checkout de convidado permite que os clientes comprem produtos sem criar uma conta, agilizando o processo de compra para maior conveniência e transações mais rápidas.',
                    ],

                    'product-view-page' => [
                        'allow-no-of-related-products'  => 'Número Permitido de Produtos Relacionados',
                        'allow-no-of-up-sells-products' => 'Número Permitido de Produtos de Up-Sell',
                        'title'                         => 'Configuração da Página de Visualização do Produto',
                        'title-info'                    => 'A configuração da página de visualização do produto envolve ajustar o layout e os elementos na página de exibição de um produto, aprimorando a experiência do usuário e a apresentação de informações.',
                    ],

                    'cart-view-page' => [
                        'allow-no-of-cross-sells-products' => 'Número Permitido de Produtos de Cross-Sell',
                        'title'                            => 'Configuração da Página de Visualização do Carrinho',
                        'title-info'                       => 'A configuração da página de visualização do carrinho envolve a organização de itens, detalhes e opções na página do carrinho de compras, melhorando a interação do usuário e o fluxo de compra.',
                    ],

                    'storefront' => [
                        'buy-now-button-display' => 'Permitir que os clientes comprem produtos diretamente',
                        'cheapest-first'         => 'Mais Barato Primeiro',
                        'comma-separated'        => 'Separado por Vírgula',
                        'default-list-mode'      => 'Modo de Lista Padrão',
                        'expensive-first'        => 'Mais Caro Primeiro',
                        'from-a-z'               => 'De A-Z',
                        'from-z-a'               => 'De Z-A',
                        'grid'                   => 'Grade',
                        'latest-first'           => 'Mais Recentes Primeiro',
                        'list'                   => 'Lista',
                        'oldest-first'           => 'Mais Antigos Primeiro',
                        'products-per-page'      => 'Produtos por Página',
                        'sort-by'                => 'Ordenar Por',
                        'title'                  => 'Frente da Loja',
                        'title-info'             => 'A frente da loja é a interface voltada para o cliente de uma loja online, mostrando produtos, categorias e navegação para uma experiência de compra perfeita.',
                    ],

                    'small-image' => [
                        'height'      => 'Altura',
                        'placeholder' => 'Espaço Reservado para Imagem Pequena',
                        'title'       => 'Imagem Pequena',
                        'title-info'  => 'A imagem pequena é a interface voltada para o cliente de uma loja online, mostrando produtos, categorias e navegação para uma experiência de compra perfeita.',
                        'width'       => 'Largura',
                    ],

                    'medium-image' => [
                        'height'      => 'Altura',
                        'placeholder' => 'Espaço Reservado para Imagem Média',
                        'title'       => 'Imagem Média',
                        'title-info'  => 'A imagem média se refere a uma imagem de tamanho moderado que oferece um equilíbrio entre detalhes e espaço na tela, comumente usada para fins visuais.',
                        'width'       => 'Largura',
                    ],

                    'large-image' => [
                        'height'      => 'Altura',
                        'placeholder' => 'Espaço Reservado para Imagem Grande',
                        'title'       => 'Imagem Grande',
                        'title-info'  => 'A imagem grande representa uma imagem de alta resolução que fornece detalhes aprimorados e impacto visual, frequentemente usada para exibir produtos ou gráficos.',
                        'width'       => 'Largura',
                    ],

                    'review' => [
                        'allow-customer-review' => 'Permitir Avaliação do Cliente',
                        'allow-guest-review'    => 'Permitir Avaliação de Convidado',
                        'display-review-count'  => 'Exiba a contagem de avaliações para classificações.',
                        'display-star-count'    => 'Exiba a contagem de estrelas nas avaliações.',
                        'summary'               => 'Resumo',
                        'title'                 => 'Avaliação',
                        'title-info'            => 'Avaliação ou avaliação de algo, envolvendo frequentemente opiniões e feedback.',
                    ],

                    'attribute' => [
                        'file-upload-size'  => 'Tamanho Máximo de Upload de Arquivo (em Kb)',
                        'image-upload-size' => 'Tamanho Máximo de Upload de Imagem (em Kb)',
                        'title'             => 'Atributo',
                        'title-info'        => 'Característica ou propriedade que define um objeto, influenciando seu comportamento, aparência ou função.',
                    ],

                    'social-share' => [
                        'title-info'                  => 'Configure as configurações de compartilhamento social para permitir o compartilhamento de produtos no Instagram, Twitter, WhatsApp, Facebook, Pinterest, LinkedIn e por e-mail.',
                        'title'                       => 'Compartilhamento Social',
                        'share-message'               => 'Mensagem de Compartilhamento',
                        'share'                       => 'Compartilhar',
                        'enable-social-share'         => 'Ativar Compartilhamento Social?',
                        'enable-share-whatsapp-info'  => 'O link de compartilhamento do WhatsApp aparecerá apenas em dispositivos móveis.',
                        'enable-share-whatsapp'       => 'Ativar Compartilhamento no WhatsApp?',
                        'enable-share-twitter'        => 'Ativar Compartilhamento no Twitter?',
                        'enable-share-pinterest'      => 'Ativar Compartilhamento no Pinterest?',
                        'enable-share-linkedin'       => 'Ativar Compartilhamento no Linkedin?',
                        'enable-share-facebook'       => 'Ativar Compartilhamento no Facebook?',
                        'enable-share-email'          => 'Ativar Compartilhamento por Email?',
                    ],
                ],

                'rich-snippets' => [
                    'info'  => 'Defina produtos e categorias.',
                    'title' => 'Rich Snippets',

                    'products' => [
                        'enable'          => 'Ativar',
                        'show-categories' => 'Mostrar Categorias',
                        'show-images'     => 'Mostrar Imagens',
                        'show-offers'     => 'Mostrar Ofertas',
                        'show-ratings'    => 'Mostrar Avaliações',
                        'show-reviews'    => 'Mostrar Comentários',
                        'show-sku'        => 'Mostrar SKU',
                        'show-weight'     => 'Mostrar Peso',
                        'title'           => 'Produtos',
                        'title-info'      => 'Configurar configurações do produto incluindo SKU, peso, categorias, imagens, avaliações, classificações, ofertas e etc.',
                    ],

                    'categories' => [
                        'enable'                  => 'Ativar',
                        'show-search-input-field' => 'Mostrar Campo de Entrada de Pesquisa',
                        'title'                   => 'Categorias',
                        'title-info'              => '"Categorias" se referem a grupos ou classificações que ajudam a organizar e agrupar produtos ou itens semelhantes para facilitar a navegação e a pesquisa.',
                    ],
                ],

                'inventory' => [
                    'title'      => 'Inventário',
                    'title-info' => 'Configure as configurações de inventário para permitir pedidos pendentes, definir quantidades mínimas e máximas no carrinho e definir o limite de estoque esgotado.',

                    'product-stock-options' => [
                        'allow-back-orders'       => 'Permitir Pedidos Pendentes',
                        'max-qty-allowed-in-cart' => 'Quantidade Máxima Permitida no Carrinho de Compras',
                        'min-qty-allowed-in-cart' => 'Quantidade Mínima Permitida no Carrinho de Compras',
                        'out-of-stock-threshold'  => 'Limite de Estoque Esgotado',
                        'title'                   => 'Opção de Estoque do Produto',
                        'info'                    => 'Configure opções de estoque do produto para permitir pedidos pendentes, definir quantidades mínimas e máximas no carrinho e definir limites de falta de estoque.',
                    ],
                ],
            ],

            'customer' => [
                'info'  => 'Cliente',
                'title' => 'Cliente',

                'address' => [
                    'info'  => 'Definir país, estado, CEP e linhas em um endereço de rua.',
                    'title' => 'Endereço',

                    'requirements' => [
                        'city'       => 'Cidade',
                        'country'    => 'País',
                        'state'      => 'Estado',
                        'title'      => 'Requisitos',
                        'title-info' => 'Requisitos são as condições, características ou especificações necessárias para que algo seja cumprido, alcançado ou atendido com sucesso.',
                        'zip'        => 'CEP',
                    ],

                    'information' => [
                        'street-lines' => 'Linhas em um Endereço de Rua',
                        'title'        => 'Informação',
                        'title-info'   => '"Linhas em um endereço de rua" se referem a segmentos individuais de um endereço, frequentemente separados por vírgulas, fornecendo informações de localização como número da casa, rua, cidade e mais.',
                    ],
                ],

                'captcha' => [
                    'info'  => 'Definir chave do site, chave secreta e status.',
                    'title' => 'Captcha',

                    'credentials' => [
                        'secret-key' => 'Chave Secreta',
                        'site-key'   => 'Chave do Site',
                        'status'     => 'Status',
                        'title'      => 'Credenciais',
                        'title-info' => '"Sitemap: Mapa do layout do site para mecanismos de busca. Chave secreta: Código seguro para criptografia de dados, autenticação ou proteção de acesso à API."',
                    ],

                    'validations' => [
                        'captcha'  => 'Algo deu errado! Por favor, tente novamente.',
                        'required' => 'Por favor, selecione o CAPTCHA',
                    ],
                ],

                'settings' => [
                    'settings-info' => 'Definir inscrições de newsletter, verificações de e-mail e login social.',
                    'title'         => 'Configurações',

                    'login-as-customer' => [
                        'allow-option' => 'Permitir Login como Cliente',
                        'title'        => 'Login como Cliente',
                        'title-info'   => 'Ativar a funcionalidade "Login como Cliente".',
                    ],

                    'wishlist' => [
                        'allow-option' => 'Permitir opção de Lista de Desejos',
                        'title'        => 'Lista de Desejos',
                        'title-info'   => 'Ativar ou desativar a opção de lista de desejos.',
                    ],

                    'login-options' => [
                        'account'          => 'Conta',
                        'home'             => 'Página Inicial',
                        'redirect-to-page' => 'Redirecionar Cliente para a página selecionada',
                        'title'            => 'Opções de Login',
                        'title-info'       => 'Configurar opções de login para determinar a página de redirecionamento para os clientes após o login.',
                    ],

                    'create-new-account-option' => [
                        'news-letter'      => 'Permitir Newsletter',
                        'news-letter-info' => 'Ativar opção de assinatura de newsletter na página de cadastro.',
                        'title'            => 'Opções de Criação de Nova Conta',
                        'title-info'       => 'Definir opções para novas contas, incluindo atribuir um grupo de clientes padrão e habilitar a opção de assinatura de newsletter durante o cadastro.',

                        'default-group' => [
                            'general'    => 'Geral',
                            'guest'      => 'Convidado',
                            'title'      => 'Grupo Padrão',
                            'title-info' => 'Atribuir um grupo de clientes específico como padrão para novos clientes.',
                            'wholesale'  => 'Atacado',
                        ],
                    ],

                    'newsletter' => [
                        'subscription' => 'Permitir Assinatura de Newsletter',
                        'title'        => 'Assinatura de Newsletter',
                        'title-info'   => '"Informações de newsletter" contêm atualizações, ofertas ou conteúdo compartilhado regularmente por e-mail para assinantes, mantendo-os informados e engajados.',
                    ],

                    'email' => [
                        'email-verification' => 'Permitir Verificação de E-mail',
                        'title'              => 'Verificação de E-mail',
                        'title-info'         => '"Verificação de e-mail" confirma a autenticidade de um endereço de e-mail, geralmente enviando um link de confirmação, melhorando a segurança da conta e a confiabilidade da comunicação.',
                    ],

                    'social-login' => [
                        'enable-facebook'   => 'Ativar Facebook',
                        'enable-github'     => 'Ativar Github',
                        'enable-google'     => 'Ativar Google',
                        'enable-linkedin'   => 'Ativar LinkedIn',
                        'enable-twitter'    => 'Ativar Twitter',
                        'social-login'      => 'Login Social',
                        'social-login-info' => '"Login social" permite que os usuários acessem sites usando suas contas de mídia social, simplificando os processos de registro e login para maior conveniência.',
                    ],
                ],
            ],

            'email' => [
                'info'  => 'E-mail',
                'title' => 'E-mail',

                'email-settings' => [
                    'admin-email'           => 'E-mail do Administrador',
                    'admin-email-tip'       => 'O endereço de e-mail do administrador deste canal para receber e-mails',
                    'admin-name'            => 'Nome do Administrador',
                    'admin-name-tip'        => 'Este nome será exibido em todos os e-mails do administrador',
                    'admin-page-limit'      => 'Itens por página padrão (Admin)',
                    'contact-email'         => 'E-mail de Contato',
                    'contact-email-tip'     => 'O endereço de e-mail será exibido no rodapé dos seus e-mails',
                    'contact-name'          => 'Nome de Contato',
                    'contact-name-tip'      => 'Este nome será exibido no rodapé dos seus e-mails',
                    'email-sender-name'     => 'Nome do Remetente de E-mail',
                    'email-sender-name-tip' => 'Este nome será exibido na caixa de entrada dos clientes',
                    'info'                  => 'Defina o nome do remetente de e-mail, o endereço de e-mail da loja, o nome do administrador e o endereço de e-mail do administrador.',
                    'shop-email-from'       => 'Endereço de E-mail da Loja',
                    'shop-email-from-tip'   => 'O endereço de e-mail deste canal para enviar e-mails aos seus clientes',
                    'title'                 => 'Configurações de E-mail',
                ],

                'notifications' => [
                    'cancel-order'                                     => 'Enviar uma notificação após cancelar um pedido',
                    'customer'                                         => 'Enviar as credenciais da conta do cliente após o registro',
                    'customer-registration-confirmation-mail-to-admin' => 'Enviar um e-mail de confirmação para o administrador após o registro do cliente',
                    'info'                                             => 'Configure as opções de estoque do produto para permitir pedidos em atraso, definir quantidades mínimas e máximas no carrinho e definir limites de estoque indisponível.',
                    'new-admin'                                        => 'Enviar um e-mail de confirmação para o administrador após fazer um novo pedido',
                    'new-inventory-source'                             => 'Enviar um e-mail de notificação para a fonte de inventário após criar um envio',
                    'new-invoice'                                      => 'Enviar um e-mail de notificação para o cliente após criar uma nova fatura',
                    'new-order'                                        => 'Enviar um e-mail de confirmação para o cliente após fazer um novo pedido',
                    'new-refund'                                       => 'Enviar um e-mail de notificação para o cliente após criar um reembolso',
                    'new-shipment'                                     => 'Enviar um e-mail de notificação para o cliente após criar um envio',
                    'registration'                                     => 'Enviar um e-mail de confirmação após o registro do cliente',
                    'title'                                            => 'Notificações',
                    'verification'                                     => 'Enviar um e-mail de verificação após o registro do cliente',
                ],
            ],

            'sales' => [
                'info'  => 'Vendas',
                'title' => 'Vendas',

                'shipping-setting' => [
                    'info'  => 'Configurar as configurações de envio, incluindo País, Estado, Cidade, Endereço, Código Postal, Nome da Loja, Número de IVA e Detalhes Bancários.',
                    'title' => 'Configurações de Envio',

                    'origin' => [
                        'bank-details'   => 'Detalhes Bancários',
                        'city'           => 'Cidade',
                        'contact-number' => 'Número de Contato',
                        'country'        => 'País',
                        'state'          => 'Estado',
                        'store-name'     => 'Nome da Loja',
                        'street-address' => 'Endereço',
                        'title'          => 'Origem',
                        'title-info'     => 'A origem do envio refere-se ao local onde os produtos são originados antes de serem transportados para o destino.',
                        'vat-number'     => 'Número de IVA',
                        'zip'            => 'Código Postal',
                    ],
                ],

                'shipping-methods' => [
                    'info'  => 'Configurar os métodos de envio, incluindo Frete Grátis, Frete Fixo e outras opções conforme necessário.',
                    'title' => 'Métodos de Envio',

                    'free-shipping' => [
                        'description' => 'Descrição',
                        'page-title'  => 'Frete Grátis',
                        'status'      => 'Status',
                        'title'       => 'Título',
                        'title-info'  => '"Frete grátis" refere-se a um método de envio em que o custo do frete é isento, e o vendedor cobre as despesas de envio para entregar os produtos ao comprador.',
                    ],

                    'flat-rate-shipping' => [
                        'description' => 'Descrição',
                        'page-title'  => 'Frete Fixo',
                        'rate'        => 'Taxa',
                        'status'      => 'Status',
                        'title'       => 'Título',
                        'title-info'  => 'Frete fixo é um método de envio em que uma taxa fixa é cobrada pelo envio, independentemente do peso, tamanho ou distância do pacote. Isso simplifica os custos de envio e pode ser vantajoso tanto para compradores quanto para vendedores.',
                        'type'        => [
                            'per-order' => 'Por Pedido',
                            'per-unit'  => 'Por Unidade',
                            'title'     => 'Tipo',
                        ],
                    ],
                ],

                'payment-methods' => [
                    'accepted-currencies'            => 'Moedas Aceitas',
                    'accepted-currencies-info'       => 'Adicione os códigos de moeda separados por vírgula, por exemplo, USD, INR, ...',
                    'business-account'               => 'Conta Empresarial',
                    'cash-on-delivery'               => 'Pagamento na Entrega',
                    'cash-on-delivery-info'          => 'Método de pagamento em que os clientes pagam em dinheiro ao receber os produtos ou serviços em sua porta.',
                    'client-id'                      => 'ID do Cliente',
                    'client-id-info'                 => 'Use "sb" para testes.',
                    'client-secret'                  => 'Chave Secreta do Cliente',
                    'client-secret-info'             => 'Adicione sua chave secreta aqui',
                    'description'                    => 'Descrição',
                    'generate-invoice'               => 'Gerar automaticamente a fatura após fazer um pedido',
                    'generate-invoice-applicable'    => 'Aplicável se a geração automática de faturas estiver ativada',
                    'info'                           => 'Definir informações dos métodos de pagamento',
                    'instructions'                   => 'Instruções',
                    'logo'                           => 'Logotipo',
                    'logo-information'               => 'A resolução da imagem deve ser de 55px X 45px',
                    'mailing-address'                => 'Enviar Cheque para',
                    'money-transfer'                 => 'Transferência Bancária',
                    'money-transfer-info'            => 'Transferência de fundos de uma pessoa ou conta para outra, muitas vezes eletronicamente, para diversos fins, como transações ou remessas.',
                    'page-title'                     => 'Métodos de Pagamento',
                    'paid'                           => 'Pago',
                    'paypal-smart-button'            => 'PayPal',
                    'paypal-smart-button-info'       => 'Botão Inteligente do PayPal: Simplifica os pagamentos online com botões personalizáveis para transações seguras e multi-métodos em sites e aplicativos.',
                    'paypal-standard'                => 'PayPal Padrão',
                    'paypal-standard-info'           => 'O PayPal Padrão é uma opção básica de pagamento do PayPal para empresas online, permitindo que os clientes paguem usando suas contas do PayPal ou cartões de crédito/débito.',
                    'pending'                        => 'Pendente',
                    'pending-payment'                => 'Pagamento Pendente',
                    'processing'                     => 'Processando',
                    'sandbox'                        => 'Ambiente de Teste',
                    'set-invoice-status'             => 'Definir o status da fatura após criar a fatura para',
                    'set-order-status'               => 'Definir o status do pedido após criar a fatura para',
                    'sort-order'                     => 'Ordem de Classificação',
                    'status'                         => 'Status',
                    'title'                          => 'Título',
                ],

                'order-settings' => [
                    'info'               => 'Definir números de pedidos, pedidos mínimos e pedidos em atraso.',
                    'title'              => 'Configurações de Pedido',

                    'order-number' => [
                        'generator'   => 'Gerador de Número de Pedido',
                        'info'        => 'Identificador único atribuído a um pedido específico do cliente, auxiliando no rastreamento, comunicação e referência durante o processo de compra.',
                        'length'      => 'Comprimento do Número de Pedido',
                        'prefix'      => 'Prefixo do Número de Pedido',
                        'suffix'      => 'Sufixo do Número de Pedido',
                        'title'       => 'Configurações do Número de Pedido',
                    ],

                    'minimum-order' => [
                        'description'             => 'Descrição',
                        'enable'                  => 'Ativar',
                        'include-discount-amount' => 'Incluir Valor do Desconto',
                        'include-tax-amount'      => 'Incluir Valor do Imposto',
                        'info'                    => 'Critérios configurados especificando a quantidade ou valor mínimo necessários para que um pedido seja processado ou se qualifique para benefícios.',
                        'minimum-order-amount'    => 'Valor Mínimo do Pedido',
                        'title'                   => 'Configurações de Pedido Mínimo',
                    ],

                    'reorder' => [
                        'admin-reorder'      => 'Reordenar pelo Admin',
                        'admin-reorder-info' => 'Ativar ou desativar a funcionalidade de reordenar para usuários administradores.',
                        'info'               => 'Ativar ou desativar a funcionalidade de reordenar para usuários administradores.',
                        'shop-reorder'       => 'Reordenar pela Loja',
                        'shop-reorder-info'  => 'Ativar ou desativar a funcionalidade de reordenar para usuários da loja.',
                        'title'              => 'Permitir Reordenar',
                    ],

                    'stock-options' => [
                        'allow-back-orders' => 'Permitir Pedidos em Atraso',
                        'info'              => 'Opções de estoque são contratos de investimento que concedem o direito de comprar ou vender ações de uma empresa a um preço predeterminado, influenciando os lucros potenciais.',
                        'title'             => 'Opções de Estoque',
                    ],
                ],

                'invoice-settings' => [
                    'info'  => 'Definir número de fatura, prazos de pagamento, design do recibo de fatura e lembretes de fatura.',
                    'title' => 'Configurações de Fatura',

                    'invoice-number' => [
                        'generator'  => 'Gerador de Número de Fatura',
                        'info'       => 'Configuração de regras ou parâmetros para gerar e atribuir números de identificação únicos às faturas para fins organizacionais e de rastreamento.',
                        'length'     => 'Comprimento do Número de Fatura',
                        'prefix'     => 'Prefixo do Número de Fatura',
                        'suffix'     => 'Sufixo do Número de Fatura',
                        'title'      => 'Configurações do Número de Fatura',
                    ],

                    'payment-terms' => [
                        'due-duration'      => 'Duração do Vencimento',
                        'due-duration-day'  => ':due-duration Dia',
                        'due-duration-days' => ':due-duration Dias',
                        'info'              => 'Condições acordadas que ditam quando e como o pagamento de bens ou serviços deve ser feito pelo comprador ao vendedor.',
                        'title'             => 'Termos de Pagamento',
                    ],

                    'pdf-print-outs' => [
                        'info'             => 'Configurar Impressões em PDF para exibir o ID da Fatura, ID do Pedido no cabeçalho e incluir o logotipo da fatura.',
                        'invoice-id-info'  => 'Configurar a exibição do ID da Fatura no Cabeçalho da Fatura.',
                        'invoice-id-title' => 'Exibir ID da Fatura no Cabeçalho',
                        'logo'             => 'Logotipo',
                        'logo-info'        => 'A resolução da imagem deve ser de 131px X 30px.',
                        'order-id-info'    => 'Configurar a exibição do ID do Pedido no Cabeçalho da Fatura.',
                        'order-id-title'   => 'Exibir ID do Pedido no Cabeçalho',
                        'title'            => 'Impressões em PDF',
                    ],

                    'invoice-reminders' => [
                        'info'                       => 'Notificações ou comunicações automatizadas enviadas aos clientes para lembrá-los de pagamentos futuros ou atrasados de faturas.',
                        'interval-between-reminders' => 'Intervalo entre lembretes',
                        'maximum-limit-of-reminders' => 'Limite máximo de lembretes',
                        'title'                      => 'Lembretes de Fatura',
                    ],
                ],

                'taxes' => [
                    'title'      => 'Impostos',
                    'title-info' => 'Impostos são taxas obrigatórias impostas pelos governos sobre bens, serviços ou transações, coletadas pelos vendedores e repassadas às autoridades.',

                    'categories' => [
                        'title'      => 'Categorias de Impostos',
                        'title-info' => 'Categorias de impostos são classificações para diferentes tipos de impostos, como imposto sobre vendas, imposto sobre valor agregado ou imposto sobre produtos, usadas para categorizar e aplicar alíquotas de imposto a produtos ou serviços.',
                        'product'    => 'Categoria de Imposto Padrão do Produto',
                        'shipping'   => 'Categoria de Imposto do Envio',
                        'none'       => 'Nenhum',
                    ],

                    'calculation' => [
                        'title'            => 'Configurações de Cálculo',
                        'title-info'       => 'Detalhes sobre o custo de bens ou serviços, incluindo preço base, descontos, impostos e cobranças adicionais.',
                        'based-on'         => 'Cálculo Baseado Em',
                        'shipping-address' => 'Endereço de Envio',
                        'billing-address'  => 'Endereço de Cobrança',
                        'shipping-origin'  => 'Origem do Envio',
                        'product-prices'   => 'Preços dos Produtos',
                        'shipping-prices'  => 'Preços de Envio',
                        'excluding-tax'    => 'Excluindo Imposto',
                        'including-tax'    => 'Incluindo Imposto',
                    ],

                    'default-destination-calculation' => [
                        'default-country'   => 'País Padrão',
                        'default-post-code' => 'Código Postal Padrão',
                        'default-state'     => 'Estado Padrão',
                        'title'             => 'Cálculo de Destino Padrão',
                        'title-info'        => 'Determinação automatizada de um destino padrão ou inicial com base em fatores ou configurações predefinidos.',
                    ],

                    'shopping-cart' => [
                        'title'                   => 'Configurações de Exibição do Carrinho de Compras',
                        'title-info'              => 'Definir a exibição de impostos no carrinho de compras',
                        'display-prices'          => 'Exibir Preços',
                        'display-subtotal'        => 'Exibir Subtotal',
                        'display-shipping-amount' => 'Exibir Valor do Envio',
                        'excluding-tax'           => 'Excluindo Imposto',
                        'including-tax'           => 'Incluindo Imposto',
                        'both'                    => 'Excluindo e Incluindo Ambos',
                    ],

                    'sales' => [
                        'title'                   => 'Configurações de Exibição de Pedidos, Faturas e Reembolsos',
                        'title-info'              => 'Definir a exibição de impostos nos pedidos, faturas e reembolsos',
                        'display-prices'          => 'Exibir Preços',
                        'display-subtotal'        => 'Exibir Subtotal',
                        'display-shipping-amount' => 'Exibir Valor do Envio',
                        'excluding-tax'           => 'Excluindo Imposto',
                        'including-tax'           => 'Incluindo Imposto',
                        'both'                    => 'Excluindo e Incluindo Ambos',
                    ],
                ],

                'checkout' => [
                    'title' => 'Finalizar Compra',
                    'info'  => 'Definir checkout de convidado, habilitar ou desabilitar Mini Carrinho, resumo do carrinho.',

                    'shopping-cart' => [
                        'cart-page'              => 'Página do Carrinho',
                        'cart-page-info'         => 'Controlar a visibilidade da página do carrinho para melhorar a experiência de compra do usuário.',
                        'cross-sell'             => 'Produtos de Venda Cruzada',
                        'cross-sell-info'        => 'Ativar produtos de venda cruzada para aumentar as oportunidades de vendas adicionais.',
                        'estimate-shipping'      => 'Envio Estimado',
                        'estimate-shipping-info' => 'Ativar envio estimado para fornecer os custos de envio antecipadamente.',
                        'guest-checkout'         => 'Permitir compra como convidado',
                        'guest-checkout-info'    => 'Ativar compra como convidado para um processo de compra mais rápido e sem complicações.',
                        'info'                   => 'Ativar compra como convidado, página do carrinho, produtos de venda cruzada e envio estimado para melhorar a conveniência do usuário e otimizar o processo de compra para aumentar as vendas.',
                        'title'                  => 'Carrinho de Compras',
                    ],

                    'my-cart' => [
                        'display-item-quantities' => 'Exibir quantidades dos itens',
                        'display-number-in-cart'  => 'Exibir número de itens no carrinho',
                        'info'                    => 'Ativar configurações para Meu Carrinho para mostrar um resumo das quantidades dos itens e exibir o número total de itens no carrinho para facilitar o acompanhamento.',
                        'summary'                 => 'Resumo',
                        'title'                   => 'Meu Carrinho',
                    ],

                    'mini-cart' => [
                        'display-mini-cart'    => 'Exibir Mini Carrinho',
                        'info'                 => 'Ativar configurações do Mini Carrinho para exibir o mini carrinho e mostrar informações de oferta do Mini Carrinho para acesso rápido aos detalhes do carrinho e promoções.',
                        'mini-cart-offer-info' => 'Informações de Oferta do Mini Carrinho',
                        'title'                => 'Mini Carrinho',
                    ],
                ],
            ],
        ],
    ],

    'components' => [
        'layouts' => [
            'header' => [
                'account-title' => 'Compte',
                'app-version'   => 'Version : :version',
                'logout'        => 'Déconnexion',
                'my-account'    => 'Mon compte',
                'notifications' => 'Notifications',
                'visit-shop'    => 'Visiter la boutique',

                'mega-search' => [
                    'categories'                      => 'Catégories',
                    'customers'                       => 'Clients',
                    'explore-all-categories'          => 'Explorer toutes les catégories',
                    'explore-all-customers'           => 'Explorer tous les clients',
                    'explore-all-matching-categories' => 'Explorer toutes les catégories correspondantes à “:query” (:count)',
                    'explore-all-matching-customers'  => 'Explorer tous les clients correspondants à “:query” (:count)',
                    'explore-all-matching-orders'     => 'Explorer toutes les commandes correspondantes à “:query” (:count)',
                    'explore-all-matching-products'   => 'Explorer tous les produits correspondants à “:query” (:count)',
                    'explore-all-orders'              => 'Explorer toutes les commandes',
                    'explore-all-products'            => 'Explorer tous les produits',
                    'orders'                          => 'Commandes',
                    'products'                        => 'Produits',
                    'sku'                             => 'SKU : :sku',
                    'title'                           => 'Méga recherche',
                ],
            ],

            'sidebar' => [
                'attribute-families'       => 'Famílias de Atributos',
                'attributes'               => 'Atributos',
                'campaigns'                => 'Campanhas',
                'catalog'                  => 'Catálogo',
                'categories'               => 'Categorias',
                'channels'                 => 'Canais',
                'cms'                      => 'CMS',
                'collapse'                 => 'Recolher',
                'communications'           => 'Comunicações',
                'configure'                => 'Configurar',
                'currencies'               => 'Moedas',
                'customers'                => 'Clientes',
                'dashboard'                => 'Painel de Controle',
                'data-transfer'            => 'Transferência de dados',
                'discount'                 => 'Desconto',
                'email-templates'          => 'Modelos de E-mail',
                'events'                   => 'Eventos',
                'exchange-rates'           => 'Taxas de Câmbio',
                'groups'                   => 'Grupos',
                'imports'                  => 'Importações',
                'inventory-sources'        => 'Fontes de Estoque',
                'invoices'                 => 'Faturas',
                'locales'                  => 'Localizações',
                'marketing'                => 'Marketing',
                'mode'                     => 'Modo Escuro',
                'newsletter-subscriptions' => 'Inscrições na Newsletter',
                'orders'                   => 'Pedidos',
                'products'                 => 'Produtos',
                'promotions'               => 'Promoções',
                'refunds'                  => 'Reembolsos',
                'reporting'                => 'Relatórios',
                'reviews'                  => 'Avaliações',
                'roles'                    => 'Funções',
                'sales'                    => 'Vendas',
                'search-seo'               => 'Busca & SEO',
                'search-synonyms'          => 'Sinônimos de Pesquisa',
                'search-terms'             => 'Termos de Pesquisa',
                'settings'                 => 'Configurações',
                'shipments'                => 'Remessas',
                'sitemaps'                 => 'Mapas do Site',
                'tax-categories'           => 'Categorias de Impostos',
                'tax-rates'                => 'Taxas de Impostos',
                'taxes'                    => 'Impostos',
                'themes'                   => 'Temas',
                'transactions'             => 'Transações',
                'url-rewrites'             => 'Reescritas de URL',
                'users'                    => 'Usuários',
            ],
        ],

        'datagrid' => [
            'index' => [
                'no-records-selected'              => 'Nenhum registro foi selecionado.',
                'must-select-a-mass-action-option' => 'Você deve selecionar uma opção de ação em massa.',
                'must-select-a-mass-action'        => 'Você deve selecionar uma ação em massa.',
            ],

            'toolbar' => [
                'length-of' => ':length de',
                'of'        => 'de',
                'per-page'  => 'Por página',
                'results'   => ':total Resultados',
                'selected'  => ':total Selecionados',

                'mass-actions' => [
                    'submit'        => 'Soumettre',
                    'select-option' => 'Sélectionner une option',
                    'select-action' => 'Sélectionner une action',
                ],

                'filter' => [
                    'apply-filters-btn' => 'Aplicar filtros',
                    'back-btn'          => 'Voltar',
                    'create-new-filter' => 'Criar novo filtro',
                    'custom-filters'    => 'Filtros personalizados',
                    'delete-error'      => 'Algo deu errado ao excluir o filtro, por favor tente novamente.',
                    'delete-success'    => 'O filtro foi excluído com sucesso.',
                    'empty-description' => 'Não há filtros selecionados disponíveis para salvar. Por favor, selecione filtros para salvar.',
                    'empty-title'       => 'Adicionar filtros para salvar',
                    'name'              => 'Nome',
                    'quick-filters'     => 'Filtros rápidos',
                    'save-btn'          => 'Salvar',
                    'save-filter'       => 'Salvar filtro',
                    'saved-success'     => 'O filtro foi salvo com sucesso.',
                    'selected-filters'  => 'Filtros selecionados',
                    'title'             => 'Filtro',
                    'update'            => 'Atualizar',
                    'update-filter'     => 'Atualizar filtro',
                    'updated-success'   => 'O filtro foi atualizado com sucesso.',
                ],

                'search' => [
                    'title' => 'Rechercher',
                ],
            ],

            'filters' => [
                'select' => 'Selecionar.',
                'title'  => ' Filtros',

                'dropdown' => [
                    'searchable' => [
                        'atleast-two-chars' => 'Digite pelo menos 2 caracteres...',
                        'no-results'        => 'Nenhum resultado encontrado...',
                    ],
                ],

                'custom-filters' => [
                    'clear-all' => 'Effacer tout',
                    'title'     => 'Filtres personnalisés',
                ],

                'boolean-options' => [
                    'false' => 'Falso',
                    'true'  => 'Verdadeiro',
                ],

                'date-options' => [
                    'last-month'        => 'Le mois dernier',
                    'last-six-months'   => '6 derniers mois',
                    'last-three-months' => '3 derniers mois',
                    'this-month'        => 'Ce mois-ci',
                    'this-week'         => 'Cette semaine',
                    'this-year'         => 'Cette année',
                    'today'             => 'Aujourd\'hui',
                    'yesterday'         => 'Hier',
                ],
            ],

            'table' => [
                'actions'              => 'Actions',
                'no-records-available' => 'Aucun enregistrement disponible.',
            ],
        ],

        'modal' => [
            'confirm' => [
                'agree-btn'    => 'Concordar',
                'disagree-btn' => 'Discordar',
                'message'      => 'Tem certeza de que deseja realizar esta ação?',
                'title'        => 'Tem certeza?',
            ],
        ],

        'products' => [
            'search' => [
                'add-btn'       => 'Adicionar Produto Selecionado',
                'empty-info'    => 'Não há produtos disponíveis para o termo de pesquisa.',
                'empty-title'   => 'Nenhum produto encontrado',
                'product-image' => 'Imagem do Produto',
                'qty'           => ':qty disponível',
                'sku'           => 'SKU - :sku',
                'title'         => 'Selecionar Produtos',
            ],
        ],

        'media' => [
            'images' => [
                'add-image-btn'     => 'Adicionar Imagem',
                'ai-add-image-btn'  => 'Magia IA',
                'ai-btn-info'       => 'Gerar Imagem',
                'allowed-types'     => 'png, jpeg, jpg',
                'not-allowed-error' => 'Apenas arquivos de imagem (.jpeg, .jpg, .png, ..) são permitidos.',

                'ai-generation' => [
                    '1024x1024'        => '1024x1024',
                    '1024x1792'        => '1024x1792',
                    '1792x1024'        => '1792x1024',
                    'apply'            => 'Aplicar',
                    'dall-e-2'         => 'Dall.E 2',
                    'dall-e-3'         => 'Dall.E 3',
                    'generate'         => 'Gerar',
                    'generating'       => 'Gerando...',
                    'hd'               => 'HD',
                    'model'            => 'Modelo',
                    'number-of-images' => 'Número de Imagens',
                    'prompt'           => 'Prompt',
                    'quality'          => 'Qualidade',
                    'regenerate'       => 'Regenerar',
                    'regenerating'     => 'Regenerando...',
                    'size'             => 'Tamanho',
                    'standard'         => 'Padrão',
                    'title'            => 'Geração de Imagem com IA',
                ],

                'placeholders' => [
                    'front'     => 'Frente',
                    'next'      => 'Próximo',
                    'size'      => 'Tamanho',
                    'use-cases' => 'Casos de Uso',
                    'zoom'      => 'Ampliar',
                ],
            ],

            'videos' => [
                'add-video-btn'     => 'Adicionar Vídeo',
                'allowed-types'     => 'mp4, webm, mkv',
                'not-allowed-error' => 'Apenas arquivos de vídeo (.mp4, .mov, .ogg ..) são permitidos.',
            ],
        ],

        'tinymce' => [
            'ai-btn-tile' => 'Magia IA',

            'ai-generation' => [
                'apply'                  => 'Aplicar',
                'dolphin-phi'            => 'Dolphin Phi',
                'generate'               => 'Gerar',
                'generated-content'      => 'Conteúdo Gerado',
                'generated-content-info' => 'O conteúdo gerado por AI pode ser enganoso. Por favor, revise o conteúdo gerado antes de aplicá-lo.',
                'generating'             => 'Gerando...',
                'gpt-3-5-turbo'          => 'OpenAI gpt-3.5-turbo',
                'llama2'                 => 'Llama 2',
                'llama2-uncensored'      => 'Llama 2 Sem Censura',
                'llama2:13b'             => 'Llama 2 13B',
                'llama2:70b'             => 'Llama 2 70B',
                'llava'                  => 'LLaVA',
                'mistral'                => 'Mistral',
                'model'                  => 'Modelo',
                'orca-mini'              => 'Orca Mini',
                'phi'                    => 'Phi-2',
                'prompt'                 => 'Prompt',
                'starling-lm'            => 'Starling',
                'title'                  => 'Assistência de IA',
                'vicuna'                 => 'Vicuna',
            ],
        ],
    ],

    'acl' => [
        'addresses'                => 'Endereços',
        'attribute-families'       => 'Famílias de Atributos',
        'attributes'               => 'Atributos',
        'campaigns'                => 'Campanhas',
        'cancel'                   => 'Cancelar',
        'cart-rules'               => 'Regras do Carrinho',
        'catalog-rules'            => 'Regras do Catálogo',
        'catalog'                  => 'Catálogo',
        'categories'               => 'Categorias',
        'channels'                 => 'Canais',
        'cms'                      => 'CMS',
        'communications'           => 'Comunicações',
        'configure'                => 'Configurar',
        'copy'                     => 'Copiar',
        'create'                   => 'Criar',
        'currencies'               => 'Moedas',
        'customers'                => 'Clientes',
        'dashboard'                => 'Painel de Controlo',
        'data-transfer'            => 'Transferência de dados',
        'delete'                   => 'Eliminar',
        'edit'                     => 'Editar',
        'email-templates'          => 'Modelos de Email',
        'events'                   => 'Eventos',
        'exchange-rates'           => 'Taxas de Câmbio',
        'groups'                   => 'Grupos',
        'import'                   => 'Importar',
        'imports'                  => 'Importações',
        'inventory-sources'        => 'Fontes de Inventário',
        'invoices'                 => 'Faturas',
        'locales'                  => 'Localidades',
        'marketing'                => 'Marketing',
        'newsletter-subscriptions' => 'Subscrições de Newsletter',
        'note'                     => 'Nota',
        'orders'                   => 'Encomendas',
        'products'                 => 'Produtos',
        'promotions'               => 'Promoções',
        'refunds'                  => 'Devoluções',
        'reporting'                => 'Relatórios',
        'reviews'                  => 'Avaliações',
        'roles'                    => 'Funções',
        'sales'                    => 'Vendas',
        'search-seo'               => 'Busca & SEO',
        'search-synonyms'          => 'Sinônimos de Pesquisa',
        'search-terms'             => 'Termos de Pesquisa',
        'settings'                 => 'Definições',
        'shipments'                => 'Envios',
        'sitemaps'                 => 'Mapas do Site',
        'subscribers'              => 'Subscritores de Newsletter',
        'tax-categories'           => 'Categorias de Impostos',
        'tax-rates'                => 'Taxas de Imposto',
        'taxes'                    => 'Impostos',
        'themes'                   => 'Temas',
        'transactions'             => 'Transações',
        'url-rewrites'             => 'Reescritas de URL',
        'users'                    => 'Utilizadores',
        'view'                     => 'Ver',
    ],

    'errors' => [
        'dashboard' => 'Tableau de bord',
        'go-back'   => 'Revenir en arrière',
        'support'   => 'Si le problème persiste, contactez-nous à l\'adresse <a href=":link" class=":class">:email</a> pour obtenir de l\'aide.',

        '404' => [
            'description' => 'Oups ! La page que vous recherchez est en vacances. Il semble que nous n\'ayons pas pu trouver ce que vous cherchiez.',
            'title'       => '404 Page non trouvée',
        ],

        '401' => [
            'description' => 'Oups ! On dirait que vous n\'êtes pas autorisé à accéder à cette page. Il semble que vous ne disposiez pas des informations d\'identification nécessaires.',
            'title'       => '401 Non autorisé',
        ],

        '403' => [
            'description' => 'Oups ! Cette page est interdite. Il semble que vous n\'ayez pas les autorisations nécessaires pour afficher ce contenu.',
            'title'       => '403 Interdit',
        ],

        '500' => [
            'description' => 'Oups ! Quelque chose s\'est mal passé. Il semble que nous ayons des difficultés à charger la page que vous recherchez.',
            'title'       => '500 Erreur interne du serveur',
        ],

        '503' => [
            'description' => 'Oups ! On dirait que nous sommes temporairement hors service pour maintenance. Revenez dans un moment.',
            'title'       => '503 Service non disponible',
        ],
    ],

    'export' => [
        'csv'        => 'CSV',
        'download'   => 'Télécharger',
        'export'     => 'Exporter',
        'no-records' => 'Rien à exporter',
        'xls'        => 'XLS',
        'xlsx'       => 'XLSX',
    ],

    'validations' => [
        'slug-being-used' => 'Ce slug est utilisé dans les catégories ou les produits.',
        'slug-reserved'   => 'Ce slug est réservé.',
    ],

    'footer' => [
        'copy-right' => 'Propulsé par <a href="https://bagisto.com/" target="_blank">Bagisto</a>, un projet de la communauté de <a href="https://webkul.com/" target="_blank">Webkul</a>',
    ],

    'emails' => [
        'dear'   => 'Estimado/a :admin_name',
        'thanks' => 'Si necesita cualquier tipo de ayuda, por favor contáctenos en <a href=":link" style=":style">:email</a>.<br/>¡Gracias!',

        'admin' => [
            'forgot-password' => [
                'description'    => 'Está a receber este email porque recebemos um pedido de redefinição de senha para a sua conta.',
                'greeting'       => 'Esqueceu a Senha!',
                'reset-password' => 'Redefinir Senha',
                'subject'        => 'Email de Redefinição de Senha',
            ],
        ],

        'customers' => [
            'registration' => [
                'description' => 'Uma nova conta de cliente foi criada com sucesso. Agora eles podem fazer login usando seu endereço de e-mail e credenciais de senha. Uma vez logados, eles terão acesso a vários serviços, incluindo a capacidade de revisar pedidos anteriores, gerenciar listas de desejos e atualizar as informações de sua conta.',
                'greeting'    => 'Damos as boas-vindas ao novo cliente, :customer_name que acaba de se registrar conosco!',
                'subject'     => 'Cadastro de Novo Cliente',
            ],
        ],

        'orders' => [
            'created' => [
                'greeting' => 'Você tem um novo pedido :order_id feito em :created_at',
                'subject'  => 'Confirmação de Novo Pedido',
                'summary'  => 'Resumo do Pedido',
                'title'    => 'Confirmação de Pedido!',
            ],

            'invoiced' => [
                'greeting' => 'Sua fatura #:invoice_id para o pedido :order_id criado em :created_at',
                'subject'  => 'Confirmação de Nova Fatura',
                'summary'  => 'Resumo da Fatura',
                'title'    => 'Confirmação de Fatura!',
            ],

            'shipped' => [
                'greeting' => 'Você enviou o pedido :order_id feito em :created_at',
                'subject'  => 'Confirmação de Novo Envio',
                'summary'  => 'Resumo do Envio',
                'title'    => 'Pedido Enviado!',
            ],

            'inventory-source' => [
                'greeting' => 'Você enviou o pedido :order_id feito em :created_at',
                'subject'  => 'Confirmação de Novo Envio',
                'summary'  => 'Resumo do Envio',
                'title'    => 'Pedido Enviado!',
            ],

            'refunded' => [
                'greeting' => 'Você reembolsou o pedido :order_id feito em :created_at',
                'subject'  => 'Confirmação de Novo Reembolso',
                'summary'  => 'Resumo do Reembolso',
                'title'    => 'Pedido Reembolsado!',
            ],

            'canceled' => [
                'greeting' => 'Você cancelou o pedido :order_id feito em :created_at',
                'subject'  => 'Novo Pedido Cancelado',
                'summary'  => 'Resumo do Pedido',
                'title'    => 'Pedido Cancelado!',
            ],

            'billing-address'            => 'Endereço de Cobrança',
            'carrier'                    => 'Transportadora',
            'contact'                    => 'Contato',
            'discount'                   => 'Desconto',
            'excl-tax'                   => 'Excl. Imposto: ',
            'grand-total'                => 'Total Geral',
            'name'                       => 'Nome',
            'payment'                    => 'Pagamento',
            'price'                      => 'Preço',
            'qty'                        => 'Quantidade',
            'shipping-address'           => 'Endereço de Envio',
            'shipping-handling-excl-tax' => 'Frete e Manuseio (Excl. Imposto)',
            'shipping-handling-incl-tax' => 'Frete e Manuseio (Incl. Imposto)',
            'shipping-handling'          => 'Frete e Manuseio',
            'shipping'                   => 'Envio',
            'sku'                        => 'SKU',
            'subtotal-excl-tax'          => 'Subtotal (Excl. Imposto)',
            'subtotal-incl-tax'          => 'Subtotal (Incl. Imposto)',
            'subtotal'                   => 'Subtotal',
            'tax'                        => 'Imposto',
            'tracking-number'            => 'Número de Rastreamento: :tracking_number',
        ],
    ],
];
