<?php

return [
    'users' => [
        'sessions' => [
            'email'                => 'メールアドレス',
            'forget-password-link' => 'パスワードを忘れましたか？',
            'password'             => 'パスワード',
            'submit-btn'           => 'サインイン',
            'title'                => 'サインイン',
        ],

        'forget-password' => [
            'create'    => [
                'email'           => '登録済みメールアドレス',
                'email-not-exist' => 'メールアドレスが存在しません',
                'page-title'      => 'パスワードを忘れる',
                'reset-link-sent' => 'パスワードリセットリンク送信済み',
                'sign-in-link'    => 'サインイン画面に戻る？',
                'submit-btn'      => 'リセット',
                'title'           => 'パスワードを回復',
            ],
        ],

        'reset-password' => [
            'back-link-title'  => 'サインイン画面に戻る？',
            'confirm-password' => 'パスワードを確認',
            'email'            => '登録済みメールアドレス',
            'password'         => 'パスワード',
            'submit-btn'       => 'パスワードをリセット',
            'title'            => 'パスワードをリセット',
        ],
    ],

    'notifications' => [
        'description-text' => 'すべての通知をリストアップ',
        'marked-success'   => 'お知らせが正常にマークされました',
        'no-record'        => '記録が見つかりません',
        'of'               => 'の',
        'per-page'         => 'ページごと',
        'read-all'         => 'すべてを既読にする',
        'title'            => 'お知らせ',
        'view-all'         => 'すべて表示',

        'order-status-messages' => [
            'all'             => 'すべて',
            'canceled'        => '注文キャンセル',
            'closed'          => '注文終了',
            'completed'       => '注文完了',
            'pending'         => '注文保留中',
            'pending-payment' => '支払い保留中',
            'processing'      => '注文処理中',
        ],
    ],

    'account' => [
        'edit' => [
            'back-btn'          => '戻る',
            'change-password'   => 'パスワードを変更',
            'confirm-password'  => 'パスワードを確認',
            'current-password'  => '現在のパスワード',
            'email'             => 'メールアドレス',
            'general'           => '一般',
            'invalid-password'  => '入力した現在のパスワードが正しくありません。',
            'name'              => '名前',
            'password'          => 'パスワード',
            'profile-image'     => 'プロフィール画像',
            'save-btn'          => 'アカウントを保存',
            'title'             => 'マイアカウント',
            'update-success'    => 'アカウントが正常に更新されました',
            'upload-image-info' => 'プロフィール画像をアップロード（110px X 110px）PNGまたはJPG形式',
        ],
    ],

    'dashboard' => [
        'index' => [
            'add-customer'                => '顧客を追加',
            'add-product'                 => '製品を追加',
            'all-channels'                => 'すべてのチャネル',
            'attribute-code'              => '属性コード',
            'average-sale'                => '平均注文売上',
            'color'                       => 'カラー',
            'customer-info'               => '最も売上の多い顧客が見つかりません',
            'customer-with-most-sales'    => '最も売上の多い顧客',
            'date-duration'               => ':start - :end',
            'decreased'                   => ':progress%',
            'empty-threshold'             => '空のしきい値',
            'empty-threshold-description' => '商品は利用できません',
            'end-date'                    => '終了日',
            'from'                        => '開始',
            'increased'                   => ':progress%',
            'more-products'               => ':product_count+ 画像以上',
            'order'                       => ':total_orders 注文',
            'order-count'                 => ':count 注文',
            'order-id'                    => '#:id',
            'overall-details'             => '全体の詳細',
            'pay-by'                      => '支払い方法 - :method',
            'product-count'               => ':count 製品',
            'product-image'               => '製品画像',
            'product-info'                => ' 移動中に関連する製品を追加します。',
            'product-number'              => '製品 - :product_number',
            'revenue'                     => '収益 :total',
            'sale-count'                  => ':count 販売',
            'sales'                       => '売上',
            'sku'                         => 'SKU - :sku',
            'start-date'                  => '開始日',
            'stock-threshold'             => '在庫閾値',
            'store-stats'                 => 'ストア統計',
            'title'                       => 'ダッシュボード',
            'to'                          => '終了',
            'today-customers'             => '今日の顧客',
            'today-details'               => '今日の詳細',
            'today-orders'                => '今日の注文',
            'today-sales'                 => '今日の売上',
            'top-performing-categories'   => 'トップパフォーマンスのカテゴリ',
            'top-selling-products'        => 'トップセリング製品',
            'total-customers'             => '顧客総数',
            'total-orders'                => '総注文数',
            'total-sales'                 => '総売上高',
            'total-stock'                 => ':total_stock 在庫',
            'total-unpaid-invoices'       => '未払い請求総額',
            'unique-visitors'             => ':count ユニーク',
            'user-info'                   => 'ストアで何が起こっているかをすばやく確認',
            'user-name'                   => 'こんにちは！ :user_name さん',
            'visitors'                    => '訪問者',
        ],
    ],

    'sales' => [
        'orders' => [
            'index' => [
                'create-btn' => '注文を作成する',
                'title'      => '注文',

                'search-customer' => [
                    'create-btn'  => '顧客を作成',
                    'empty-info'  => '検索条件に一致する顧客はありません。',
                    'empty-title' => '顧客が見つかりません',
                    'search-by'   => 'メールアドレスまたは名前で検索',
                    'title'       => '顧客を選択',
                ],

                'datagrid' => [
                    'canceled'        => 'キャンセル',
                    'channel-name'    => 'チャネル',
                    'closed'          => '終了',
                    'completed'       => '完了',
                    'customer'        => '顧客',
                    'date'            => '日付',
                    'email'           => 'メール',
                    'fraud'           => '詐欺',
                    'grand-total'     => '合計金額',
                    'id'              => '#:id',
                    'items'           => 'アイテム',
                    'location'        => '場所',
                    'order-id'        => '注文ID',
                    'pay-by'          => ':method で支払う',
                    'pay-via'         => '支払い方法',
                    'pending-payment' => '支払い保留中',
                    'pending'         => '保留中',
                    'processing'      => '処理中',
                    'product-count'   => ':count + 他の製品',
                    'status'          => 'ステータス',
                    'success'         => '成功',
                    'view'            => '表示',
                ],
            ],

            'create' => [
                'add-to-cart'             => 'カートに追加',
                'back-btn'                => '戻る',
                'check-billing-address'   => '請求先住所がありません。',
                'check-shipping-address'  => '配送先住所がありません。',
                'configuration'           => '設定',
                'coupon-already-applied'  => 'クーポンコードは既に適用されています。',
                'coupon-applied'          => 'クーポンコードが正常に適用されました。',
                'coupon-error'            => 'クーポンコードは適用できません。',
                'coupon-not-found'        => 'クーポンが見つかりません',
                'coupon-remove'           => 'クーポンコードが正常に削除されました。',
                'error'                   => 'エラーが発生しました',
                'minimum-order-error'     => '最小注文金額が満たされていません。',
                'order-placed-success'    => '注文が正常に完了しました。',
                'payment-not-supported'   => 'この支払い方法はサポートされていません',
                'save-btn'                => '注文を作成',
                'specify-payment-method'  => '支払い方法がありません。',
                'specify-shipping-method' => '配送方法がありません。',
                'title'                   => ':name の注文を作成',

                'types' => [
                    'configurable' => [
                        'select-options' => 'オプションを選択してください',
                    ],

                    'bundle' => [
                        'none'         => 'なし',
                        'total-amount' => '合計金額',
                    ],

                    'grouped' => [
                        'name' => '名前',
                    ],

                    'downloadable' => [
                        'title' => 'リンク',
                    ],
                ],

                'cart' => [
                    'success-add-to-cart' => '商品がカートに追加されました',
                    'success-remove'      => 'アイテムがカートから正常に削除されました',
                    'success-update'      => 'カートアイテムが正常に更新されました',

                    'items' => [
                        'add-product'       => '商品を追加',
                        'amount-per-unit'   => ':amount 単位あたり x :qty 個数',
                        'delete'            => '削除',
                        'empty-description' => 'カートに商品が見つかりません。',
                        'empty-title'       => 'カートが空です',
                        'excl-tax'          => '税抜き',
                        'move-to-wishlist'  => 'ウィッシュリストに移動',
                        'see-details'       => '詳細を見る',
                        'sku'               => 'SKU - :sku',
                        'sub-total'         => '小計 - :sub_total',
                        'title'             => 'カートアイテム',

                        'search' => [
                            'add-to-cart'   => 'カートに追加',
                            'available-qty' => ':qty 個利用可能',
                            'empty-info'    => '検索用語に該当する商品はありません。',
                            'empty-title'   => '商品が見つかりません',
                            'product-image' => '商品画像',
                            'qty'           => '数量',
                            'sku'           => 'SKU - :sku',
                            'title'         => '商品を検索',
                        ],
                    ],

                    'address' => [
                        'add-btn'          => '住所を追加',
                        'add-new'          => '新しい住所を追加',
                        'add-new-address'  => '新しい住所を追加',
                        'addresses'        => '住所',
                        'back'             => '戻る',
                        'billing-address'  => '請求先住所',
                        'city'             => '市区町村',
                        'company-name'     => '会社名',
                        'confirm'          => '確認',
                        'country'          => '国',
                        'edit-btn'         => '住所を編集',
                        'email'            => 'メール',
                        'first-name'       => '名',
                        'last-name'        => '姓',
                        'postcode'         => '郵便番号',
                        'proceed'          => '進む',
                        'same-as-billing'  => '配送先にも同じ住所を使用しますか？',
                        'save'             => '保存',
                        'save-address'     => 'この住所を住所帳に保存',
                        'select-country'   => '国を選択',
                        'select-state'     => '都道府県を選択',
                        'shipping-address' => '配送先住所',
                        'state'            => '都道府県',
                        'street-address'   => '住所',
                        'telephone'        => '電話番号',
                        'title'            => '住所',
                        'vat-id'           => 'VAT番号',
                    ],

                    'payment' => [
                        'title' => '支払い',
                    ],

                    'shipping' => [
                        'title' => '配送',
                    ],

                    'summary' => [
                        'apply-coupon'             => 'クーポンを適用',
                        'discount-amount'          => '割引額',
                        'enter-your-code'          => 'コードを入力してください',
                        'grand-total'              => '合計金額',
                        'place-order'              => '注文する',
                        'processing'               => '処理中',
                        'shipping-amount-excl-tax' => '送料（税抜き）',
                        'shipping-amount-incl-tax' => '送料（税込み）',
                        'shipping-amount'          => '送料',
                        'sub-total-excl-tax'       => '小計（税抜き）',
                        'sub-total-incl-tax'       => '小計（税込み）',
                        'sub-total'                => '小計',
                        'tax'                      => '税金',
                        'title'                    => '注文の概要',
                    ],
                ],

                'cart-items' => [
                    'add-to-cart'       => 'カートに追加',
                    'delete'            => '削除',
                    'empty-description' => 'カートに商品が見つかりません。',
                    'empty-title'       => 'カートが空です',
                    'excl-tax'          => '税抜き: ',
                    'see-details'       => '詳細を見る',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'カートアイテム',
                ],

                'recent-order-items' => [
                    'add-to-cart'       => 'カートに追加',
                    'empty-description' => '最近の注文で商品が見つかりません。',
                    'empty-title'       => '注文がありません',
                    'see-details'       => '詳細を見る',
                    'sku'               => 'SKU - :sku',
                    'title'             => '最近の注文アイテム',
                    'view'              => '表示',
                ],

                'wishlist-items' => [
                    'add-to-cart'       => 'カートに追加',
                    'delete'            => '削除',
                    'empty-description' => 'ウィッシュリストに商品が見つかりません。',
                    'empty-title'       => 'ウィッシュリストが空です',
                    'see-details'       => '詳細を見る',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'ウィッシュリストアイテム',
                ],

                'compare-items' => [
                    'add-to-cart'       => 'カートに追加',
                    'delete'            => '削除',
                    'empty-description' => '比較リストに商品が見つかりません。',
                    'empty-title'       => '比較リストが空です',
                    'sku'               => 'SKU - :sku',
                    'title'             => '比較アイテム',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount ユニットあたり :qty 個',
                'billing-address'                => '請求先住所',
                'cancel'                         => 'キャンセル',
                'cancel-msg'                     => 'この注文をキャンセルしてもよろしいですか？',
                'cancel-success'                 => '注文が正常にキャンセルされました',
                'canceled'                       => 'キャンセル済み',
                'channel'                        => 'チャネル',
                'closed'                         => 'クローズ',
                'comment-success'                => 'コメントが正常に追加されました。',
                'comments'                       => 'コメント',
                'completed'                      => '完了',
                'contact'                        => '連絡先',
                'create-success'                 => '注文が正常に作成されました',
                'currency'                       => '通貨',
                'customer'                       => '顧客',
                'customer-group'                 => '顧客グループ',
                'customer-not-notified'          => ':date | 顧客 <b>未通知</b>',
                'customer-notified'              => ':date | 顧客 <b>通知済み</b>',
                'discount'                       => '割引 - :discount',
                'download-pdf'                   => 'PDFをダウンロード',
                'fraud'                          => '詐欺',
                'grand-total'                    => '合計 - :grand_total',
                'invoice-id'                     => '請求書 #:invoice',
                'invoices'                       => '請求書',
                'item-canceled'                  => 'キャンセル済み (:qty_canceled)',
                'item-invoice'                   => '請求済み (:qty_invoiced)',
                'item-ordered'                   => '注文済み (:qty_ordered)',
                'item-refunded'                  => '返金済み (:qty_refunded)',
                'item-shipped'                   => '出荷済み (:qty_shipped)',
                'name'                           => '名前',
                'no-invoice-found'               => '請求書が見つかりません',
                'no-refund-found'                => '返金が見つかりません',
                'no-shipment-found'              => '出荷が見つかりません',
                'notify-customer'                => '顧客に通知',
                'order-date'                     => '注文日',
                'order-information'              => '注文情報',
                'order-status'                   => '注文ステータス',
                'payment-and-shipping'           => '支払いと配送',
                'payment-method'                 => '支払い方法',
                'pending'                        => '保留中',
                'pending_payment'                => '支払い保留中',
                'per-unit'                       => 'ユニットあたり',
                'price'                          => '価格 - :price',
                'price-excl-tax'                 => '価格（税抜き） - :price',
                'price-incl-tax'                 => '価格（税込み） - :price',
                'processing'                     => '処理中',
                'quantity'                       => '数量',
                'refund'                         => '返金',
                'refund-id'                      => '返金 #:refund',
                'refunded'                       => '返金済み',
                'reorder'                        => '再注文',
                'ship'                           => '出荷',
                'shipment'                       => '出荷 #:shipment',
                'shipments'                      => '出荷',
                'shipping-address'               => '配送先住所',
                'shipping-and-handling'          => '配送料と手数料',
                'shipping-and-handling-excl-tax' => '配送料と手数料（税抜き）',
                'shipping-and-handling-incl-tax' => '配送料と手数料（税込み）',
                'shipping-method'                => '配送方法',
                'shipping-price'                 => '配送料',
                'sku'                            => 'SKU - :sku',
                'status'                         => 'ステータス',
                'sub-total'                      => '小計 - :sub_total',
                'sub-total-excl-tax'             => '小計（税抜き） - :sub_total',
                'sub-total-incl-tax'             => '小計（税込み） - :sub_total',
                'submit-comment'                 => 'コメントを送信',
                'summary-discount'               => '割引',
                'summary-grand-total'            => '合計',
                'summary-sub-total'              => '小計',
                'summary-sub-total-excl-tax'     => '小計（税抜き）',
                'summary-sub-total-incl-tax'     => '小計（税込み）',
                'summary-tax'                    => '税金',
                'tax'                            => '税金 (:percent) - :tax',
                'title'                          => '注文 #:order_id',
                'total-due'                      => '合計額',
                'total-paid'                     => '支払い済み合計',
                'total-refund'                   => '返金合計',
                'view'                           => '表示',
                'write-your-comment'             => 'コメントを書く',
            ],
        ],

        'shipments' => [
            'index' => [
                'title' => '出荷',

                'datagrid' => [
                    'id'               => 'ID',
                    'inventory-source' => '在庫ソース',
                    'order-date'       => '注文日',
                    'order-id'         => '注文ID',
                    'shipment-date'    => '出荷日',
                    'shipment-to'      => '出荷先',
                    'total-qty'        => '総数量',
                    'view'             => '表示',
                ],
            ],

            'create' => [
                'amount-per-unit'  => ':amount 単位あたり x :qty 個数',
                'cancel-error'     => '注文はキャンセルできません',
                'carrier-name'     => '運送会社名',
                'create-btn'       => '出荷を作成',
                'creation-error'   => '出荷の作成エラー',
                'item-canceled'    => 'キャンセル済み (:qty_canceled)',
                'item-invoice'     => '請求済み (:qty_invoiced)',
                'item-ordered'     => '注文済み (:qty_ordered)',
                'item-refunded'    => '返金済み (:qty_refunded)',
                'item-shipped'     => '出荷済み (:qty_shipped)',
                'order-error'      => '出荷が無効です',
                'per-unit'         => '単位あたり',
                'qty-available'    => '利用可能数量',
                'qty-to-ship'      => '出荷予定数量',
                'quantity-invalid' => '数量が無効です',
                'sku'              => 'SKU - :sku',
                'source'           => 'ソース',
                'success'          => '出荷が正常に作成されました',
                'title'            => '新しい出荷を作成',
                'tracking-number'  => '追跡番号',
            ],

            'view' => [
                'billing-address'      => '請求先住所',
                'carrier-title'        => '運送会社タイトル',
                'channel'              => 'チャネル',
                'currency'             => '通貨',
                'customer'             => '顧客',
                'email'                => 'メール - :email',
                'inventory-source'     => '在庫ソース',
                'order-date'           => '注文日',
                'order-id'             => '注文ID',
                'order-information'    => '注文情報',
                'order-status'         => '注文ステータス',
                'ordered-items'        => '注文済み商品',
                'payment-and-shipping' => '支払いと発送',
                'payment-method'       => '支払い方法',
                'product-image'        => '商品画像',
                'qty'                  => '数量 - :qty',
                'shipping-address'     => '配送先住所',
                'shipping-method'      => '配送方法',
                'shipping-price'       => '配送料',
                'sku'                  => 'SKU - :sku ',
                'title'                => '出荷 #:shipment_id',
                'tracking-number'      => '追跡番号',
            ],
        ],

        'refunds' => [
            'index' => [
                'title' => '返金',

                'datagrid' => [
                    'billed-to'       => '請求先',
                    'id'              => 'ID',
                    'order-id'        => '注文ID',
                    'refund-date'     => '返金日',
                    'refunded-amount' => '払い戻し額',
                    'view'            => '表示',
                ],
            ],

            'view' => [
                'account-information'        => 'アカウント情報',
                'adjustment-fee'             => '調整手数料',
                'adjustment-refund'          => '調整返金',
                'base-discounted-amount'     => '割引額 - :base_discounted_amount',
                'billing-address'            => '請求先住所',
                'currency'                   => '通貨',
                'sub-total-amount-excl-tax'  => '小計（税抜き） - :discounted_amount',
                'sub-total-amount-incl-tax'  => '小計（税込み） - :discounted_amount',
                'sub-total-amount'           => '小計 - :discounted_amount',
                'grand-total'                => '合計',
                'order-channel'              => '注文チャネル',
                'order-date'                 => '注文日',
                'order-id'                   => '注文ID',
                'order-information'          => '注文情報',
                'order-status'               => '注文ステータス',
                'payment-information'        => '支払い情報',
                'payment-method'             => '支払い方法',
                'price-excl-tax'             => '価格（税抜き） - :price',
                'price-incl-tax'             => '価格（税込み） - :price',
                'price'                      => '価格 - :price',
                'product-image'              => '商品画像',
                'product-ordered'            => '注文商品',
                'qty'                        => '数量 - :qty',
                'refund'                     => '返金',
                'shipping-address'           => '配送先住所',
                'shipping-handling-excl-tax' => '送料・手数料（税抜き）',
                'shipping-handling-incl-tax' => '送料・手数料（税込み）',
                'shipping-handling'          => '送料・手数料',
                'shipping-method'            => '配送方法',
                'shipping-price'             => '配送料',
                'sku'                        => 'SKU - :sku',
                'sub-total-excl-tax'         => '小計（税抜き）',
                'sub-total-incl-tax'         => '小計（税込み）',
                'sub-total'                  => '小計',
                'tax'                        => '税金',
                'tax-amount'                 => '税額 - :tax_amount',
                'title'                      => '返金 #:refund_id',
            ],

            'create' => [
                'adjustment-fee'              => '調整手数料',
                'adjustment-refund'           => '調整返金',
                'amount-per-unit'             => ':amount 単位あたり x :qty 個数',
                'create-success'              => '返金が正常に作成されました',
                'creation-error'              => '払い戻しの作成は許可されていません。',
                'discount-amount'             => '割引額',
                'grand-total'                 => '総合計',
                'invalid-qty'                 => '請求アイテムの無効な数量が見つかりました。',
                'invalid-refund-amount-error' => '返金額はゼロ以外である必要があります。',
                'item-canceled'               => 'キャンセル済み (:qty_canceled)',
                'item-invoice'                => '請求済み (:qty_invoiced)',
                'item-ordered'                => '注文済み (:qty_ordered)',
                'item-refunded'               => '返金済み (:qty_refunded)',
                'item-shipped'                => '出荷済み (:qty_shipped)',
                'per-unit'                    => '単位あたり',
                'price'                       => '価格',
                'qty-to-refund'               => '返金数量',
                'refund-btn'                  => '返金',
                'refund-limit-error'          => '返金金額 :amount は処理できません。',
                'refund-shipping'             => '送料を返金',
                'sku'                         => 'SKU - :sku',
                'subtotal'                    => '小計',
                'tax-amount'                  => '税額',
                'title'                       => '返金を作成',
                'update-totals-btn'           => '合計を更新',
            ],
        ],

        'invoices' => [
            'index' => [
                'title' => '請求書',

                'datagrid' => [
                    'action'       => 'アクション',
                    'grand-total'  => '総合計',
                    'id'           => 'ID',
                    'invoice-date' => '請求書の日付',
                    'order-id'     => '注文ID',
                    'overdue'      => '延滞',
                    'paid'         => '支払済み',
                    'pending'      => '保留中',
                    'status'       => 'ステータス',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount 単位あたり × :qty 個数',
                'channel'                        => 'チャネル',
                'customer-email'                 => 'メール - :email',
                'customer'                       => '顧客',
                'discount'                       => '割引額 - :discount',
                'email'                          => 'メール',
                'grand-total'                    => '総合計',
                'invoice-items'                  => '請求書アイテム',
                'invoice-sent'                   => '請求書が正常に送信されました',
                'invoice-status'                 => '請求書のステータス',
                'order-date'                     => '注文日',
                'order-id'                       => '注文ID',
                'order-information'              => '注文情報',
                'order-status'                   => '注文ステータス',
                'price-excl-tax'                 => '価格（税抜き） - :price',
                'price-incl-tax'                 => '価格（税込み） - :price',
                'price'                          => '価格 - :price',
                'print'                          => '印刷',
                'product-image'                  => '商品画像',
                'qty'                            => '数量 - :qty',
                'send-btn'                       => '送信',
                'send-duplicate-invoice'         => '複製請求書を送信',
                'send'                           => '送信',
                'shipping-and-handling-excl-tax' => '送料・手数料（税抜き）',
                'shipping-and-handling-incl-tax' => '送料・手数料（税込み）',
                'shipping-and-handling'          => '送料・手数料',
                'sku'                            => 'SKU - :sku',
                'sub-total-excl-tax'             => '小計（税抜き） - :sub_total',
                'sub-total-incl-tax'             => '小計（税込み） - :sub_total',
                'sub-total-summary-excl-tax'     => '小計（税抜き）',
                'sub-total-summary-incl-tax'     => '小計（税込み）',
                'sub-total-summary'              => '小計',
                'sub-total'                      => '小計 - :sub_total',
                'summary-discount'               => '割引額',
                'summary-tax'                    => '税額',
                'tax'                            => '税額 - :tax',
                'title'                          => '請求書 #:invoice_id',
            ],

            'create' => [
                'amount-per-unit'    => '1単位あたりの:amount × :qty 個数',
                'create-invoice'     => '請求書を作成する',
                'create-success'     => '請求書が正常に作成されました',
                'create-transaction' => '取引を作成する',
                'creation-error'     => '注文請求書の作成は許可されていません。',
                'invalid-qty'        => '請求書アイテムの数量が無効です。',
                'invoice'            => '請求書',
                'new-invoice'        => '新しい請求書',
                'product-error'      => '製品なしでは請求書を作成できません。',
                'product-image'      => '製品画像',
                'qty-to-invoiced'    => '請求数',
                'sku'                => 'SKU - :sku',
            ],

            'invoice-pdf' => [
                'bank-details'               => '銀行詳細',
                'bill-to'                    => '請求先',
                'contact-number'             => '連絡先番号',
                'contact'                    => '連絡先',
                'date'                       => '請求日',
                'discount'                   => '割引',
                'excl-tax'                   => '税抜き:',
                'grand-total'                => '総合計',
                'invoice-id'                 => '請求書ID',
                'invoice'                    => '請求書',
                'order-date'                 => '注文日',
                'order-id'                   => '注文ID',
                'payment-method'             => '支払方法',
                'payment-terms'              => '支払条件',
                'price'                      => '価格',
                'product-name'               => '商品名',
                'qty'                        => '数量',
                'ship-to'                    => '配送先',
                'shipping-handling-excl-tax' => '送料・手数料（税抜き）',
                'shipping-handling-incl-tax' => '送料・手数料（税込み）',
                'shipping-handling'          => '送料・手数料',
                'shipping-method'            => '配送方法',
                'sku'                        => 'SKU',
                'subtotal-excl-tax'          => '小計（税抜き）',
                'subtotal-incl-tax'          => '小計（税込み）',
                'subtotal'                   => '小計',
                'tax-amount'                 => '税額',
                'tax'                        => '税金',
                'vat-number'                 => 'VAT番号',
            ],
        ],

        'invoice-transaction' => [
            'id'               => 'ID',
            'transaction-date' => '取引日',
            'transaction-id'   => '取引ID',
            'view'             => '表示',
        ],

        'transactions' => [
            'index' => [
                'create-btn' => '取引を作成',
                'title'      => '取引',

                'datagrid' => [
                    'completed'          => '完了',
                    'id'                 => 'ID',
                    'invoice-id'         => '請求書ID',
                    'order-id'           => '注文ID',
                    'paid'               => '支払済み',
                    'pending'            => '保留中',
                    'status'             => 'ステータス',
                    'transaction-amount' => '金額',
                    'transaction-date'   => '日付',
                    'transaction-id'     => '取引ID',
                    'view'               => '表示',
                ],

                'create' => [
                    'already-paid'               => 'すでに支払い済み',
                    'amount'                     => '金額',
                    'create-transaction'         => '取引を作成',
                    'invoice-id'                 => '請求書ID',
                    'invoice-missing'            => '請求書が見つかりません',
                    'payment-method'             => '支払い方法',
                    'save-transaction'           => '取引を保存',
                    'transaction-amount-exceeds' => '取引金額が超過しています',
                    'transaction-amount-zero'    => '取引金額がゼロです',
                    'transaction-saved'          => '取引が正常に保存されました。',
                ],

                'view' => [
                    'amount'           => '金額',
                    'created-at'       => '作成日時',
                    'invoice-id'       => '請求書ID',
                    'order-id'         => '注文ID',
                    'payment-details'  => '支払い詳細',
                    'payment-method'   => '支払い方法',
                    'status'           => 'ステータス',
                    'title'            => '取引の詳細',
                    'transaction-data' => '取引データ',
                    'transaction-id'   => '取引ID',
                ],
            ],
        ],
    ],

    'catalog' => [
        'products' => [
            'index' => [
                'already-taken' => ':name は既に使用されています。',
                'create-btn'    => '製品を作成',
                'title'         => '製品',

                'create'     => [
                    'back-btn'                => '戻る',
                    'configurable-attributes' => '設定可能な属性',
                    'create-btn'              => '製品を作成',
                    'family'                  => 'ファミリー',
                    'save-btn'                => '製品を保存',
                    'sku'                     => 'SKU',
                    'title'                   => '新しい製品を作成',
                    'type'                    => 'タイプ',
                ],

                'datagrid'   => [
                    'active'                 => 'アクティブ',
                    'attribute-family'       => '属性ファミリー',
                    'attribute-family-value' => '属性ファミリー - :attribute_family',
                    'category'               => 'カテゴリー',
                    'channel'                => 'チャンネル',
                    'copy-of'                => 'コピー :value',
                    'copy-of-slug'           => 'コピー-:value',
                    'delete'                 => '削除',
                    'disable'                => '無効',
                    'id'                     => 'ID',
                    'id-value'               => 'ID - :id',
                    'image'                  => '画像',
                    'mass-delete-success'    => '選択した製品が正常に削除されました',
                    'mass-update-success'    => '選択した製品が正常に更新されました',
                    'name'                   => '名前',
                    'out-of-stock'           => '在庫切れ',
                    'price'                  => '価格',
                    'product-image'          => '製品画像',
                    'qty'                    => '数量',
                    'qty-value'              => ':qty 個の利用可能',
                    'sku'                    => 'SKU',
                    'sku-value'              => 'SKU - :sku',
                    'status'                 => 'ステータス',
                    'type'                   => 'タイプ',
                    'update-status'          => 'ステータスを更新',
                ],
            ],

            'edit' => [
                'preview'  => 'プレビュー',
                'remove'   => '削除',
                'save-btn' => '製品を保存',
                'title'    => '製品を編集',

                'channels' => [
                    'title' => 'チャンネル',
                ],

                'price' => [
                    'group' => [
                        'add-group-price'           => 'グループ価格を追加',
                        'all-groups'                => 'すべてのグループ',
                        'create-btn'                => '新規追加',
                        'discount-group-price-info' => ':price の割引価格で :qty 個の数量に対して',
                        'edit-btn'                  => '編集',
                        'empty-info'                => '特定のグループに所属する顧客のための特別価格',
                        'fixed-group-price-info'    => ':price の固定価格で :qty 個の数量に対して',
                        'title'                     => '顧客グループ価格',

                        'create' => [
                            'all-groups'     => 'すべてのグループ',
                            'create-title'   => '顧客グループ価格を作成',
                            'customer-group' => '顧客グループ',
                            'delete-btn'     => '削除',
                            'discount'       => '割引',
                            'fixed'          => '固定',
                            'price'          => '価格',
                            'price-type'     => '価格タイプ',
                            'qty'            => '最小数量',
                            'save-btn'       => '保存',
                            'update-title'   => '顧客グループ価格を更新',
                        ],
                    ],
                ],

                'inventories' => [
                    'pending-ordered-qty'      => '保留中の注文数量: :qty',
                    'pending-ordered-qty-info' => '出荷後、対応する在庫ソースから保留中の注文数量が差し引かれます。キャンセルの場合、保留中の数量は販売可能になります。',
                    'title'                    => '在庫',
                ],

                'categories' => [
                    'title' => 'カテゴリー',
                ],

                'images' => [
                    'info'  => '画像の解像度は560px X 609pxのようにする必要があります',
                    'title' => '画像',
                ],

                'videos' => [
                    'error' => 'エラー：:attribute は :max キロバイトを超えてはいけません。小さいファイルを選択してください。',
                    'info'  => '最大ビデオサイズは :size となります',
                    'title' => 'ビデオ',
                ],

                'links' => [
                    'related-products' => [
                        'empty-info' => '移動中に関連する製品を追加します。',
                        'info'       => 'お客様が表示中の製品に加えて、関連製品が表示されます。',
                        'title'      => '関連製品',
                    ],

                    'up-sells' => [
                        'empty-info' => '移動中に追加の販売商品を追加します。',
                        'info'       => 'お客様には、現在表示している製品のプレミアムまたは高品質の代替製品として機能するアップセル製品が提示されます。',
                        'title'      => 'アップセル製品',
                    ],

                    'cross-sells' => [
                        'empty-info' => '移動中にクロスセル商品を追加します。',
                        'info'       => 'ショッピングカートの隣には、「インパルス購入」商品として配置されるクロスセル製品が表示され、すでにカートに追加された商品を補完します。',
                        'title'      => 'クロスセル製品',
                    ],

                    'add-btn'           => '製品を追加',
                    'delete'            => '削除',
                    'empty-info'        => ':type 製品を追加するには。',
                    'empty-title'       => '製品を追加',
                    'image-placeholder' => '製品画像',
                    'sku'               => 'SKU - :sku',
                ],

                'types' => [
                    'configurable' => [
                        'add-btn'           => 'バリエーションを追加',
                        'delete-btn'        => '削除',
                        'edit-btn'          => '編集',
                        'empty-info'        => '製品のさまざまな組み合わせをすぐに作成するには。',
                        'empty-title'       => 'バリエーションを追加',
                        'image-placeholder' => '製品画像',
                        'info'              => 'バリエーション製品は、属性のすべての可能な組み合わせに依存しています。',
                        'qty'               => ':qty 個',
                        'sku'               => 'SKU - :sku',
                        'title'             => 'バリエーション',

                        'create' => [
                            'description'            => '説明',
                            'name'                   => '名前',
                            'save-btn'               => '追加',
                            'title'                  => 'バリエーションを追加',
                            'variant-already-exists' => 'このバリエーションはすでに存在します',
                        ],

                        'edit' => [
                            'disabled'        => '無効',
                            'edit-info'       => '製品情報を詳細に更新する場合は、次の',
                            'edit-link-title' => '製品詳細ページ',
                            'enabled'         => '有効',
                            'images'          => '画像',
                            'name'            => '名前',
                            'price'           => '価格',
                            'quantities'      => '数量',
                            'save-btn'        => '保存',
                            'sku'             => 'SKU',
                            'status'          => 'ステータス',
                            'title'           => '製品',
                            'weight'          => '重さ',
                        ],

                        'mass-edit' => [
                            'add-images'          => '画像を追加',
                            'apply-to-all-btn'    => 'すべてに適用',
                            'apply-to-all-name'   => 'すべてのバリアントに名前を適用',
                            'apply-to-all-sku'    => 'すべてのSKUに価格を適用',
                            'apply-to-all-status' => 'すべてのバリアントにステータスを適用',
                            'apply-to-all-weight' => 'すべてのバリエーションに重みを適用する。',
                            'edit-inventories'    => '在庫を編集',
                            'edit-names'          => '名前を編集',
                            'edit-prices'         => '価格を編集',
                            'edit-sku'            => 'SKUを編集',
                            'edit-status'         => 'ステータスを編集',
                            'edit-weight'         => '重さを編集',
                            'name'                => '名前',
                            'price'               => '価格',
                            'remove-images'       => '画像を削除',
                            'remove-variants'     => 'バリアントを削除',
                            'select-action'       => 'アクションを選択',
                            'select-variants'     => 'バリアントを選択',
                            'status'              => 'ステータス',
                            'variant-name'        => 'バリアント名',
                            'variant-sku'         => 'バリアントSKU',
                            'weight'              => '重さ',
                        ],
                    ],

                    'grouped' => [
                        'add-btn'           => '製品を追加',
                        'default-qty'       => 'デフォルト数量',
                        'delete'            => '削除',
                        'empty-info'        => 'さまざまな製品の組み合わせをすぐに作成するには。',
                        'empty-title'       => '製品を追加',
                        'image-placeholder' => '製品画像',
                        'info'              => 'グループ化された製品は、セットとして表示されるスタンドアロンのアイテムから構成され、シーズンやテーマによる変更や調整が可能です。各製品は個別に購入するか、グループの一部として購入できます。',
                        'sku'               => 'SKU - :sku',
                        'title'             => 'グループ化された製品',
                    ],

                    'bundle' => [
                        'add-btn'           => 'オプションを追加',
                        'empty-info'        => 'バンドルオプションをすぐに作成するには。',
                        'empty-title'       => 'オプションを追加',
                        'image-placeholder' => '製品画像',
                        'info'              => 'バンドル製品は、複数のアイテムまたはサービスが特別価格で一緒に販売されるパッケージで、顧客にとって価値と便益を提供します。',
                        'title'             => 'バンドルアイテム',

                        'update-create' => [
                            'checkbox'    => 'チェックボックス',
                            'is-required' => '必須',
                            'multiselect' => 'マルチセレクト',
                            'name'        => 'タイトル',
                            'no'          => 'いいえ',
                            'radio'       => 'ラジオ',
                            'save-btn'    => '保存',
                            'select'      => '選択',
                            'title'       => 'オプション',
                            'type'        => 'タイプ',
                            'yes'         => 'はい',
                        ],

                        'option' => [
                            'add-btn'     => '製品を追加',
                            'default-qty' => 'デフォルト数量',
                            'delete'      => '削除',
                            'delete-btn'  => '削除',
                            'edit-btn'    => '編集',
                            'empty-info'  => 'さまざまな製品の組み合わせをすぐに作成するには。',
                            'empty-title' => '製品を追加',
                            'sku'         => 'SKU - :sku',

                            'types' => [
                                'checkbox' => [
                                    'info'  => 'チェックボックスを使用してデフォルトの製品を設定します。',
                                    'title' => 'チェックボックス',
                                ],

                                'multiselect' => [
                                    'info'  => 'チェックボックスボタンを使用してデフォルトの製品を設定します。',
                                    'title' => 'マルチセレクト',
                                ],

                                'radio' => [
                                    'info'  => 'ラジオボタンを使用してデフォルトの製品を設定します。',
                                    'title' => 'ラジオ',
                                ],

                                'select' => [
                                    'info'  => 'ラジオボタンを使用してデフォルトの製品を設定します。',
                                    'title' => '選択',
                                ],
                            ],
                        ],
                    ],

                    'downloadable' => [
                        'links' => [
                            'add-btn'     => 'リンクを追加',
                            'delete-btn'  => '削除',
                            'edit-btn'    => '編集',
                            'empty-info'  => 'すぐにリンクを作成するには。',
                            'empty-title' => 'リンクを追加',
                            'file'        => 'ファイル：',
                            'info'        => 'ダウンロード可能な製品タイプは、電子書籍、ソフトウェアアプリケーション、音楽、ゲームなどのデジタル製品を販売できます。',
                            'sample-file' => 'サンプルファイル：',
                            'sample-url'  => 'サンプルURL：',
                            'title'       => 'ダウンロード可能なリンク',
                            'url'         => 'URL：',

                            'update-create' => [
                                'downloads'   => 'ダウンロード許可',
                                'file'        => 'ファイル',
                                'file-type'   => 'ファイルタイプ',
                                'name'        => 'タイトル',
                                'price'       => '価格',
                                'sample'      => 'サンプル',
                                'sample-type' => 'サンプルタイプ',
                                'save-btn'    => '保存',
                                'title'       => 'リンク',
                                'url'         => 'URL',
                            ],
                        ],

                        'samples' => [
                            'add-btn'     => 'サンプルを追加',
                            'delete-btn'  => '削除',
                            'edit-btn'    => '編集',
                            'empty-info'  => 'すぐにサンプルを作成するには。',
                            'empty-title' => 'サンプルを追加',
                            'file'        => 'ファイル：',
                            'info'        => 'ダウンロード可能な製品タイプは、電子書籍、ソフトウェアアプリケーション、音楽、ゲームなどのデジタル製品を販売できます。',
                            'title'       => 'ダウンロード可能なサンプル',
                            'url'         => 'URL：',

                            'update-create' => [
                                'url'       => 'URL',
                                'title'     => 'リンク',
                                'save-btn'  => '保存',
                                'name'      => 'タイトル',
                                'file-type' => 'ファイルタイプ',
                                'file'      => 'ファイル',
                            ],
                        ],
                    ],
                ],
            ],

            'create-success'          => '商品が正常に作成されました',
            'delete-failed'           => '商品の削除に失敗しました',
            'delete-success'          => '商品が正常に削除されました',
            'product-copied'          => '商品が正常にコピーされました',
            'saved-inventory-message' => '商品が正常に保存されました',
            'update-success'          => '商品が正常に更新されました',
        ],

        'attributes' => [
            'index' => [
                'create-btn' => '属性を作成',
                'title'      => '属性',

                'datagrid' => [
                    'boolean'             => '真偽値',
                    'channel-based'       => 'チャネルベース',
                    'checkbox'            => 'チェックボックス',
                    'code'                => 'コード',
                    'created-at'          => '作成日時',
                    'date'                => '日付',
                    'date-time'           => '日付と時刻',
                    'delete'              => '削除',
                    'edit'                => '編集',
                    'file'                => 'ファイル',
                    'id'                  => 'ID',
                    'image'               => '画像',
                    'locale-based'        => 'ロケールベース',
                    'mass-delete-success' => '選択した属性が正常に削除されました',
                    'multiselect'         => 'マルチセレクト',
                    'name'                => '名前',
                    'price'               => '価格',
                    'required'            => '必須',
                    'select'              => '選択',
                    'text'                => 'テキスト',
                    'textarea'            => 'テキストエリア',
                    'type'                => 'タイプ',
                    'unique'              => 'ユニーク',
                ],
            ],

            'create' => [
                'add-attribute-options' => '属性オプションを追加',
                'add-option'            => 'オプションを追加',
                'add-options-info'      => '属性オプションのさまざまな組み合わせを作成するには。',
                'add-row'               => '行を追加',
                'admin'                 => '管理者',
                'admin-name'            => '管理者名',
                'back-btn'              => '戻る',
                'boolean'               => '真偽値',
                'checkbox'              => 'チェックボックス',
                'code'                  => '属性コード',
                'color'                 => '色',
                'configuration'         => '構成',
                'create-empty-option'   => 'デフォルトの空のオプションを作成',
                'date'                  => '日付',
                'datetime'              => '日時',
                'decimal'               => '小数',
                'default-value'         => 'デフォルト値',
                'email'                 => 'Eメール',
                'enable-wysiwyg'        => 'WYSIWYGエディタを有効にする',
                'file'                  => 'ファイル',
                'general'               => '一般',
                'image'                 => '画像',
                'input-options'         => '入力オプション',
                'input-validation'      => '入力検証',
                'is-comparable'         => '属性は比較可能です',
                'is-configurable'       => '設定可能な製品を作成するために使用',
                'is-filterable'         => '層別ナビゲーションで使用',
                'is-required'           => '必須です',
                'is-unique'             => 'ユニークです',
                'is-visible-on-front'   => 'フロントエンドの商品表示ページに表示',
                'label'                 => 'ラベル',
                'multiselect'           => 'マルチセレクト',
                'no'                    => 'いいえ',
                'numeric'               => '数値',
                'option-deleted'        => 'オプションが正常に削除されました',
                'options'               => 'オプション',
                'position'              => '位置',
                'price'                 => '価格',
                'regex'                 => '正規表現',
                'regex-info'            => '式はダブルクォートで囲む必要があります。',
                'save-btn'              => '属性を保存',
                'select'                => '選択',
                'select-type'           => '属性タイプを選択',
                'swatch'                => 'スウォッチ',
                'text'                  => 'テキスト',
                'textarea'              => 'テキストエリア',
                'title'                 => '属性を追加',
                'type'                  => '属性タイプ',
                'url'                   => 'URL',
                'use-in-flat'           => '製品フラットテーブルに作成',
                'validations'           => '検証',
                'value-per-channel'     => 'チャネルごとの値',
                'value-per-locale'      => 'ロケールごとの値',
                'yes'                   => 'はい',

                'option'                => [
                    'color'    => 'カラースウォッチ',
                    'dropdown' => 'ドロップダウン',
                    'image'    => '画像スウォッチ',
                    'save-btn' => 'オプションを保存',
                    'text'     => 'テキストスウォッチ',
                ],
            ],

            'edit' => [
                'add-attribute-options' => '属性オプションを追加',
                'add-option'            => 'オプションを追加',
                'add-options-info'      => '属性オプションのさまざまな組み合わせを作成するには。',
                'add-row'               => '行を追加',
                'admin'                 => '管理者',
                'admin-name'            => '管理者名',
                'back-btn'              => '戻る',
                'boolean'               => 'ブール値',
                'checkbox'              => 'チェックボックス',
                'code'                  => '属性コード',
                'color'                 => '色',
                'configuration'         => '設定',
                'create-empty-option'   => 'デフォルトの空のオプションを作成',
                'date'                  => '日付',
                'datetime'              => '日時',
                'decimal'               => '小数',
                'default-value'         => 'デフォルト値',
                'email'                 => 'メール',
                'enable-wysiwyg'        => 'WYSIWYGエディタを有効にする',
                'file'                  => 'ファイル',
                'general'               => '一般',
                'image'                 => '画像',
                'input-options'         => '入力オプション',
                'input-validation'      => '入力検証',
                'is-comparable'         => '属性は比較可能',
                'is-configurable'       => '設定可能な製品を作成するために使用',
                'is-filterable'         => '層別ナビゲーションで使用',
                'is-required'           => '必須',
                'is-unique'             => 'ユニーク',
                'is-visible-on-front'   => 'フロントエンドの商品表示ページに表示',
                'label'                 => 'ラベル',
                'multiselect'           => 'マルチセレクト',
                'no'                    => 'いいえ',
                'numeric'               => '数値',
                'option-deleted'        => 'オプションが正常に削除されました',
                'options'               => 'オプション',
                'position'              => '位置',
                'price'                 => '価格',
                'regex'                 => '正規表現',
                'regex-info'            => '式はダブルクォートで囲む必要があります。',
                'save-btn'              => '属性を保存',
                'select'                => '選択',
                'select-type'           => '属性タイプを選択',
                'swatch'                => 'スウォッチ',
                'text'                  => 'テキスト',
                'textarea'              => 'テキストエリア',
                'title'                 => '属性を編集',
                'type'                  => '属性タイプ',
                'url'                   => 'URL',
                'use-in-flat'           => '製品フラットテーブルに作成',
                'validations'           => '検証',
                'value-per-channel'     => 'チャネルごとの値',
                'value-per-locale'      => 'ロケールごとの値',
                'yes'                   => 'はい',

                'option' => [
                    'color'    => 'カラースウォッチ',
                    'dropdown' => 'ドロップダウン',
                    'image'    => '画像スウォッチ',
                    'save-btn' => 'オプションを保存',
                    'text'     => 'テキストスウォッチ',
                ],
            ],

            'create-success'    => '属性が正常に作成されました',
            'delete-failed'     => '属性の削除に失敗しました',
            'delete-success'    => '属性が正常に削除されました',
            'update-success'    => '属性が正常に更新されました',
            'user-define-error' => 'システム属性を削除できません',
        ],

        'categories' => [
            'index' => [
                'add-btn' => 'カテゴリを作成',
                'title'   => 'カテゴリ',

                'datagrid' => [
                    'active'         => 'アクティブ',
                    'delete'         => '削除',
                    'delete-success' => '選択した :resource は正常に削除されました',
                    'edit'           => '編集',
                    'id'             => 'ID',
                    'inactive'       => '非アクティブ',
                    'name'           => '名前',
                    'no-of-products' => '製品数',
                    'position'       => '位置',
                    'status'         => 'メニューで表示',
                    'update-status'  => 'ステータスを更新',
                ],
            ],

            'create' => [
                'add-banner'               => 'バナーを追加',
                'add-logo'                 => 'ロゴを追加',
                'back-btn'                 => '戻る',
                'banner'                   => 'バナー',
                'banner-size'              => 'バナーアスペクト比（1320px X 300px）',
                'description'              => '説明',
                'description-and-images'   => '説明と画像',
                'description-only'         => '説明のみ',
                'display-mode'             => '表示モード',
                'enter-position'           => '位置を入力',
                'filterable-attributes'    => 'フィルタ可能な属性',
                'general'                  => '一般',
                'logo'                     => 'ロゴ',
                'logo-size'                => 'ロゴの解像度は（110px X 110px）である必要があります',
                'meta-description'         => 'メタ説明',
                'meta-keywords'            => 'メタキーワード',
                'meta-title'               => 'メタタイトル',
                'name'                     => '名前',
                'parent-category'          => '親カテゴリ',
                'position'                 => '位置',
                'products-and-description' => '製品と説明',
                'products-only'            => '製品のみ',
                'save-btn'                 => 'カテゴリを保存',
                'select-display-mode'      => '表示モードを選択',
                'seo-details'              => 'SEOの詳細',
                'settings'                 => '設定',
                'slug'                     => 'スラッグ',
                'title'                    => '新しいカテゴリを追加',
                'visible-in-menu'          => 'メニューで表示',
            ],

            'edit' => [
                'add-banner'               => 'バナーを追加',
                'add-logo'                 => 'ロゴを追加',
                'back-btn'                 => '戻る',
                'banner'                   => 'バナー',
                'banner-size'              => 'バナーアスペクト比（1320px X 300px）',
                'description'              => '説明',
                'description-and-images'   => '説明と画像',
                'description-only'         => '説明のみ',
                'display-mode'             => '表示モード',
                'enter-position'           => '位置を入力',
                'filterable-attributes'    => 'フィルタ可能な属性',
                'general'                  => '一般',
                'logo'                     => 'ロゴ',
                'logo-size'                => 'ロゴの解像度は（110px X 110px）である必要があります',
                'meta-description'         => 'メタ説明',
                'meta-keywords'            => 'メタキーワード',
                'meta-title'               => 'メタタイトル',
                'name'                     => '名前',
                'position'                 => '位置*',
                'products-and-description' => '製品と説明',
                'products-only'            => '製品のみ',
                'save-btn'                 => 'カテゴリを保存',
                'select-display-mode'      => '表示モードを選択',
                'select-parent-category'   => '親カテゴリを選択*',
                'seo-details'              => 'SEOの詳細',
                'settings'                 => '設定',
                'slug'                     => 'スラッグ',
                'title'                    => 'カテゴリを編集',
                'visible-in-menu'          => 'メニューで表示',
            ],

            'category'             => 'カテゴリ',
            'create-success'       => 'カテゴリが正常に作成されました。',
            'delete-category-root' => 'ルートカテゴリは削除できません。',
            'delete-failed'        => 'カテゴリの削除中にエラーが発生しました',
            'delete-success'       => 'カテゴリが正常に削除されました。',
            'update-success'       => 'カテゴリが正常に更新されました。',
        ],

        'families' => [
            'index' => [
                'add'   => '属性ファミリーを作成',
                'title' => 'ファミリー',

                'datagrid' => [
                    'code'           => 'コード',
                    'delete'         => '削除',
                    'delete-success' => '選択した :resource は正常に削除されました',
                    'edit'           => '編集',
                    'id'             => 'ID',
                    'method-error'   => 'エラー！誤ったメソッドが検出されました。大量アクションの設定を確認してください',
                    'name'           => '名前',
                    'no-resource'    => 'アクションに提供されたリソースが不足しています',
                    'partial-action' => '一部のアクションは、:resource 上の制約があるため実行されませんでした',
                    'update-success' => '選択した :resource は正常に更新されました',
                ],
            ],

            'create' => [
                'add-group-btn'                    => 'グループを追加',
                'add-group-title'                  => '新しいグループを追加',
                'back-btn'                         => '戻る',
                'code'                             => 'コード',
                'column'                           => 'カラム',
                'delete-group-btn'                 => 'グループを削除',
                'edit-group-info'                  => 'ダブルクリックしてグループを編集',
                'enter-code'                       => 'コードを入力',
                'enter-name'                       => '名前を入力',
                'general'                          => '一般',
                'group-code-already-exists'        => '属性グループコードはすでに存在しています。',
                'group-contains-system-attributes' => 'このグループにはシステム属性が含まれています。まずシステム属性を別のグループに移動してから再試行してください。',
                'group-name-already-exists'        => '属性グループ名はすでに存在します。',
                'groups'                           => 'グループ',
                'groups-info'                      => '属性ファミリーグループを管理',
                'main-column'                      => 'メインカラム',
                'name'                             => '名前',
                'removal-not-possible'             => '属性ファミリーからシステム属性を削除することはできません。',
                'right-column'                     => '右側カラム',
                'save-btn'                         => '属性ファミリーを保存',
                'select-group'                     => '属性グループを選択してください。',
                'title'                            => '属性ファミリーを作成',
                'unassigned-attributes'            => '未割り当ての属性',
                'unassigned-attributes-info'       => 'これらの属性をカラムまたはグループに追加するには、ドラッグしてください。',
            ],

            'edit' => [
                'add-group-btn'                    => 'グループを追加',
                'add-group-title'                  => '新しいグループを追加',
                'back-btn'                         => '戻る',
                'code'                             => 'コード',
                'column'                           => 'カラム',
                'delete-group-btn'                 => 'グループを削除',
                'edit-group-info'                  => 'ダブルクリックしてグループを編集',
                'enter-code'                       => 'コードを入力',
                'enter-name'                       => '名前を入力',
                'general'                          => '一般',
                'group-code-already-exists'        => '属性グループコードはすでに存在しています。',
                'group-contains-system-attributes' => 'このグループにはシステム属性が含まれています。まずシステム属性を別のグループに移動してから再試行してください。',
                'group-name-already-exists'        => '属性グループ名はすでに存在します。',
                'groups'                           => 'グループ',
                'groups-info'                      => '属性ファミリーグループを管理',
                'main-column'                      => 'メインカラム',
                'name'                             => '名前',
                'removal-not-possible'             => '属性ファミリーからシステム属性を削除することはできません。',
                'right-column'                     => '右側カラム',
                'save-btn'                         => '属性ファミリーを保存',
                'select-group'                     => '属性グループを選択してください。',
                'title'                            => '属性ファミリーを編集',
                'unassigned-attributes'            => '未割り当ての属性',
                'unassigned-attributes-info'       => 'これらの属性をカラムまたはグループに追加するには、ドラッグしてください。',
            ],

            'attribute-family'        => '属性ファミリー',
            'attribute-product-error' => 'ファミリーは製品で使用されています。',
            'create-success'          => 'ファミリーが正常に作成されました。',
            'delete-failed'           => 'ファミリーの削除中にエラーが発生しました。',
            'delete-success'          => 'ファミリーが正常に削除されました。',
            'family'                  => 'ファミリー',
            'last-delete-error'       => '少なくとも1つのファミリーが必要です。',
            'update-success'          => 'ファミリーが正常に更新されました。',
            'user-define-error'       => 'システム属性ファミリーを削除できません',
        ],
    ],

    'customers' => [
        'customers' => [
            'index' => [
                'title'         => '顧客',
                'login-message' => ':customer_name としてログインしました',

                'datagrid' => [
                    'active'         => 'アクティブ',
                    'address'        => ':address 住所',
                    'address-count'  => '住所数',
                    'channel'        => 'チャンネル',
                    'delete'         => '削除',
                    'delete-success' => '選択したデータが正常に削除されました',
                    'email'          => 'メール',
                    'gender'         => '性別',
                    'group'          => 'グループ',
                    'id'             => '顧客ID',
                    'inactive'       => '非アクティブ',
                    'method-error'   => 'エラー！誤ったメソッドが検出されました。マスアクションの構成を確認してください',
                    'name'           => '顧客名',
                    'no-resource'    => '提供されたリソースは、アクションには不十分です',
                    'order'          => ':order 注文',
                    'order-count'    => '注文数',
                    'order-pending'  => '顧客は保留中の注文があります',
                    'partial-action' => '一部のアクションは、:resource の制約により実行されませんでした',
                    'phone'          => '連絡先番号',
                    'revenue'        => '収益',
                    'status'         => 'ステータス',
                    'suspended'      => '停止中',
                    'update-status'  => 'ステータスの更新',
                    'update-success' => '選択した顧客が正常に更新されました',
                ],

                'create' => [
                    'contact-number'        => '連絡先番号',
                    'create-btn'            => '顧客を作成',
                    'create-success'        => '顧客が正常に作成されました',
                    'customer-group'        => '顧客グループ',
                    'date-of-birth'         => '生年月日',
                    'email'                 => 'メール',
                    'female'                => '女性',
                    'first-name'            => '名',
                    'gender'                => '性別',
                    'last-name'             => '姓',
                    'male'                  => '男性',
                    'other'                 => 'その他',
                    'save-btn'              => '顧客を保存',
                    'select-customer-group' => '顧客グループを選択',
                    'select-gender'         => '性別を選択',
                    'title'                 => '新しい顧客を作成',
                ],
            ],

            'view' => [
                'account-delete-confirmation' => 'アカウントを削除してもよろしいですか？',
                'active'                      => 'アクティブ',
                'address-delete-confirmation' => 'この住所を削除してもよろしいですか？',
                'back-btn'                    => '戻る',
                'create-order'                => '注文を作成する',
                'customer'                    => '顧客',
                'date-of-birth'               => '生年月日 - :dob',
                'default-address'             => 'デフォルトアドレス',
                'delete-account'              => 'アカウントを削除',
                'delete'                      => '削除',
                'email'                       => 'メール - :email',
                'empty-description'           => '顧客の新しい住所を作成してください',
                'empty-title'                 => '顧客住所を追加',
                'gender'                      => '性別 - :gender',
                'group'                       => 'グループ - :group_code',
                'inactive'                    => '非アクティブ',
                'login-as-customer'           => '顧客としてログイン',
                'note-created-success'        => 'ノートが正常に作成されました',
                'order-create-confirmation'   => 'この顧客のために注文を作成してもよろしいですか？',
                'phone'                       => '電話 - :phone',
                'set-as-default'              => 'デフォルトに設定',
                'suspended'                   => '停止中',
                'title'                       => '顧客ビュー',

                'address' => [
                    'count'  => '住所 (:count)',

                    'create' => [
                        'city'               => '市町村',
                        'company-name'       => '会社名',
                        'country'            => '国',
                        'create-btn'         => '作成',
                        'create-address-btn' => '新しい住所を追加',
                        'default-address'    => 'デフォルトアドレス',
                        'email'              => 'メール',
                        'first-name'         => '名',
                        'last-name'          => '姓',
                        'phone'              => '電話',
                        'post-code'          => '郵便番号',
                        'save-btn-title'     => '住所を保存',
                        'select-country'     => '国を選択',
                        'state'              => '都道府県',
                        'street-address'     => '住所',
                        'title'              => '住所を作成',
                        'vat-id'             => 'VAT ID',
                    ],

                    'edit' => [
                        'city'            => '市町村',
                        'company-name'    => '会社名',
                        'country'         => '国',
                        'default-address' => 'デフォルトアドレス',
                        'edit-btn'        => '編集',
                        'email'           => 'メール',
                        'first-name'      => '名',
                        'last-name'       => '姓',
                        'phone'           => '電話',
                        'post-code'       => '郵便番号',
                        'save-btn-title'  => '住所を保存',
                        'select-country'  => '国を選択',
                        'state'           => '都道府県',
                        'street-address'  => '住所',
                        'title'           => '住所を編集',
                        'vat-id'          => 'VAT ID',
                    ],

                    'address-delete-success' => '住所が正常に削除されました',
                    'create-success'         => '住所が正常に作成されました',
                    'set-default-success'    => 'デフォルトアドレスが正常に更新されました',
                    'success-mass-delete'    => '住所が正常に一括削除されました',
                    'update-success'         => '住所が正常に更新されました',
                ],

                'datagrid' => [
                    'invoices' => [
                        'empty-invoice'  => 'レビューは利用できません',
                        'increment-id'   => '請求書ID',
                        'invoice-amount' => '請求書金額',
                        'invoice-date'   => '請求書日付',
                        'order-id'       => '注文ID',
                        'view'           => '表示',
                    ],

                    'orders' => [
                        'canceled'        => 'キャンセル済み',
                        'channel-name'    => 'チャネル名',
                        'closed'          => 'クローズ済み',
                        'completed'       => '完了済み',
                        'customer-name'   => '顧客名',
                        'date'            => '日付',
                        'empty-order'     => '注文は利用できません',
                        'email'           => 'メール',
                        'fraud'           => '詐欺',
                        'grand-total'     => '総計',
                        'location'        => '場所',
                        'order-id'        => '注文ID',
                        'pay-via'         => '支払い方法',
                        'pending'         => '保留中',
                        'pending-payment' => '支払い保留中',
                        'processing'      => '処理中',
                        'status'          => 'ステータス',
                        'view'            => '表示',
                    ],

                    'reviews' => [
                        'approved'      => '承認済み',
                        'comment'       => 'コメント',
                        'created-at'    => '作成日',
                        'disapproved'   => '非承認',
                        'empty-reviews' => '請求書は利用できません',
                        'id'            => 'ID',
                        'invoice-date'  => '請求書日付',
                        'pending'       => '保留中',
                        'product-id'    => '製品ID',
                        'product-name'  => '製品名',
                        'rating'        => '評価',
                        'status'        => 'ステータス',
                        'title'         => 'タイトル',
                    ],
                ],

                'edit' => [
                    'contact-number'        => '連絡先番号',
                    'customer-group'        => '顧客グループ',
                    'date-of-birth'         => '生年月日',
                    'edit-btn'              => '編集',
                    'email'                 => 'メール',
                    'female'                => '女性',
                    'first-name'            => '名',
                    'gender'                => '性別',
                    'last-name'             => '姓',
                    'male'                  => '男性',
                    'other'                 => 'その他',
                    'save-btn'              => '顧客を保存',
                    'select-customer-group' => '顧客グループを選択',
                    'select-gender'         => '性別を選択',
                    'status'                => 'ステータス',
                    'suspended'             => '停止中',
                    'title'                 => '顧客を編集',
                ],

                'invoices' => [
                    'count'        => '請求書 (:count)',
                    'increment-id' => '# :increment_id',
                ],

                'notes' => [
                    'add-note'              => 'ノートを追加',
                    'customer-not-notified' => ':date | 顧客 <b>未通知</b>',
                    'customer-notified'     => ':date | 顧客 <b>通知済み</b>',
                    'note'                  => 'ノート',
                    'note-placeholder'      => 'ここにノートを記入してください',
                    'notify-customer'       => '顧客に通知',
                    'submit-btn-title'      => 'ノートを送信',
                ],

                'orders' => [
                    'count'         => '注文 (:count)',
                    'increment-id'  => '# :increment_id',
                    'total-revenue' => '総収益 - :revenue',
                ],

                'reviews' => [
                    'id'    => 'ID - :id',
                    'count' => 'レビュー (:count)',
                ],

                'cart' => [
                    'delete-success' => 'カートアイテムが正常に削除されました。',
                ],

                'wishlist' => [
                    'delete-success' => 'ウィッシュリストアイテムが正常に削除されました。',
                ],

                'compare' => [
                    'delete-success' => '比較アイテムが正常に削除されました。',
                ],
            ],

            'delete-failed'  => '顧客の削除に失敗しました',
            'delete-success' => '顧客が正常に削除されました',
            'order-pending'  => '注文が保留中です',
            'update-success' => '顧客が正常に更新されました',
        ],

        'groups' => [
            'index' => [
                'title' => 'グループ',

                'create' => [
                    'code'       => 'コード',
                    'create-btn' => 'グループを作成',
                    'name'       => '名前',
                    'save-btn'   => 'グループを保存',
                    'success'    => 'グループが正常に作成されました',
                    'title'      => '新しいグループを作成',
                ],

                'edit' => [
                    'delete-failed'  => 'グループの削除に失敗しました',
                    'delete-success' => 'グループが正常に削除されました',
                    'group-default'  => 'デフォルトグループは削除できません',
                    'success'        => 'グループが正常に更新されました',
                    'title'          => 'グループを編集',
                ],

                'datagrid' => [
                    'code'   => 'コード',
                    'delete' => '削除',
                    'edit'   => '編集',
                    'id'     => 'ID',
                    'name'   => '名前',
                ],
            ],
        ],

        'reviews' => [
            'index' => [
                'date'        => '日付',
                'description' => '説明',
                'id'          => 'ID',
                'name'        => '名前',
                'product'     => '製品',
                'rating'      => '評価',
                'status'      => 'ステータス',
                'title'       => 'レビュー',

                'edit' => [
                    'approved'       => '承認済み',
                    'customer'       => '顧客',
                    'date'           => '日付',
                    'disapproved'    => '非承認',
                    'id'             => 'ID',
                    'images'         => '画像',
                    'pending'        => '保留中',
                    'product'        => '製品',
                    'rating'         => '評価',
                    'review-comment' => 'コメント',
                    'review-title'   => 'タイトル',
                    'save-btn'       => '保存',
                    'status'         => 'ステータス',
                    'title'          => 'レビューを編集',
                    'update-success' => '更新成功',
                ],

                'datagrid' => [
                    'approved'            => '承認済み',
                    'comment'             => 'コメント',
                    'customer-names'      => '名前',
                    'date'                => '日付',
                    'delete'              => '削除',
                    'delete-success'      => 'レビューが正常に削除されました',
                    'disapproved'         => '非承認',
                    'edit'                => '編集',
                    'id'                  => 'ID',
                    'mass-delete-error'   => '何かがうまくいかなかった',
                    'mass-delete-success' => '選択したレビューが正常に削除されました',
                    'mass-update-success' => '選択したレビューが正常に更新されました',
                    'pending'             => '保留中',
                    'product'             => '製品',
                    'rating'              => '評価',
                    'review-id'           => 'ID - :review_id',
                    'status'              => 'ステータス',
                    'title'               => 'タイトル',
                    'update-status'       => 'ステータスを更新',
                ],
            ],
        ],
    ],

    'marketing' => [
        'communications' => [
            'templates' => [
                'index' => [
                    'create-btn' => 'テンプレートを作成',
                    'title'      => 'メールテンプレート',

                    'datagrid' => [
                        'active'   => 'アクティブ',
                        'draft'    => '下書き',
                        'id'       => 'ID',
                        'inactive' => '非アクティブ',
                        'name'     => '名前',
                        'status'   => 'ステータス',
                    ],
                ],

                'create' => [
                    'active'         => 'アクティブ',
                    'back-btn'       => '戻る',
                    'content'        => 'コンテンツ',
                    'create-success' => 'メールテンプレートが正常に作成されました。',
                    'draft'          => '下書き',
                    'general'        => '一般',
                    'inactive'       => '非アクティブ',
                    'name'           => '名前',
                    'save-btn'       => 'テンプレートを保存',
                    'select-status'  => 'ステータスを選択',
                    'status'         => 'ステータス',
                    'title'          => 'テンプレートを作成',
                ],

                'edit' => [
                    'active'         => 'アクティブ',
                    'back-btn'       => '戻る',
                    'content'        => 'コンテンツ*',
                    'draft'          => '下書き',
                    'general'        => '一般',
                    'inactive'       => '非アクティブ',
                    'name'           => '名前',
                    'save-btn'       => 'テンプレートを保存',
                    'status'         => 'ステータス',
                    'title'          => 'テンプレートを編集',
                    'update-success' => '正常に更新されました',
                ],

                'delete-failed'  => ':name 削除に失敗しました',
                'delete-success' => 'テンプレートが正常に削除されました',
                'email-template' => 'メールテンプレート',
            ],

            'campaigns' => [
                'index' => [
                    'create-btn' => 'キャンペーンを作成',
                    'title'      => 'キャンペーン',

                    'datagrid' => [
                        'active'   => 'アクティブ',
                        'delete'   => '削除',
                        'edit'     => '編集',
                        'id'       => 'ID',
                        'inactive' => '非アクティブ',
                        'name'     => '名前',
                        'status'   => 'ステータス',
                        'subject'  => '件名',
                    ],
                ],

                'create' => [
                    'active'          => 'アクティブ',
                    'back-btn'        => '戻る',
                    'channel'         => 'チャンネル',
                    'customer-group'  => '顧客グループ',
                    'email-template'  => 'メールテンプレート',
                    'event'           => 'イベント',
                    'general'         => '一般',
                    'inactive'        => '非アクティブ',
                    'name'            => '名前',
                    'save-btn'        => 'キャンペーンを保存',
                    'select-channel'  => 'チャンネルを選択',
                    'select-event'    => 'イベントを選択',
                    'select-group'    => 'グループを選択',
                    'select-status'   => 'ステータスを選択',
                    'select-template' => 'テンプレートを選択',
                    'setting'         => '設定',
                    'status'          => 'ステータス',
                    'subject'         => '件名',
                    'title'           => 'キャンペーンを作成',
                ],

                'edit' => [
                    'active'          => 'アクティブ',
                    'audience'        => '対象',
                    'back-btn'        => '戻る',
                    'channel'         => 'チャンネル',
                    'customer-group'  => '顧客グループ',
                    'email-template'  => 'メールテンプレート',
                    'event'           => 'イベント',
                    'general'         => '一般',
                    'inactive'        => '非アクティブ',
                    'name'            => '名前',
                    'save-btn'        => 'キャンペーンを保存',
                    'select-event'    => 'イベントを選択',
                    'select-status'   => 'ステータスを選択',
                    'select-template' => 'テンプレートを選択',
                    'status'          => 'ステータス',
                    'subject'         => '件名',
                    'title'           => 'キャンペーンを編集',
                ],

                'create-success' => 'キャンペーンが正常に作成されました。',
                'delete-failed'  => ':name の削除に失敗しました',
                'delete-success' => 'キャンペーンが正常に削除されました',
                'email-campaign' => 'メールキャンペーン',
                'update-success' => 'キャンペーンが正常に更新されました。',
            ],

            'events' => [
                'index' => [
                    'create-btn' => 'イベントを作成',
                    'event'      => 'イベント',
                    'title'      => 'イベント',

                    'datagrid' => [
                        'actions' => 'アクション',
                        'date'    => '日付',
                        'delete'  => '削除',
                        'edit'    => '編集',
                        'id'      => 'ID',
                        'name'    => '名前',
                    ],

                    'create' => [
                        'date'           => '日付',
                        'delete-warning' => 'このアクションを実行してもよろしいですか？',
                        'description'    => '説明',
                        'general'        => '一般',
                        'name'           => '名前',
                        'save-btn'       => 'イベントを保存',
                        'success'        => 'イベントが正常に作成されました',
                        'title'          => 'イベントを作成',
                    ],

                    'edit' => [
                        'success' => 'イベントが正常に更新されました',
                        'title'   => 'イベントを編集',
                    ],
                ],

                'delete-failed'  => ':name の削除に失敗しました',
                'delete-success' => 'イベントが正常に削除されました',
                'edit-error'     => 'イベントは編集できません',
            ],

            'subscribers' => [
                'index' => [
                    'title' => 'ニュースレターの購読者',

                    'datagrid' => [
                        'actions'    => 'アクション',
                        'delete'     => '削除',
                        'edit'       => '編集',
                        'email'      => 'メールアドレス',
                        'false'      => 'いいえ',
                        'id'         => 'ID',
                        'subscribed' => '購読中',
                        'true'       => 'はい',
                    ],

                    'edit' => [
                        'back-btn'      => '戻る',
                        'email'         => 'メールアドレス',
                        'false'         => 'いいえ',
                        'save-btn'      => '購読者を保存',
                        'subscribed'    => '購読中',
                        'success'       => 'ニュースレターの購読が正常に更新されました',
                        'title'         => 'ニュースレターの購読者を編集',
                        'true'          => 'はい',
                        'update-failed' => 'ニュースレターの購読が更新されませんでした',
                    ],
                ],

                'delete-failed'  => '購読者の削除に失敗しました',
                'delete-success' => '購読者が正常に削除されました',
                'delete-warning' => 'このアクションを実行してもよろしいですか？',
            ],
        ],

        'promotions' => [
            'index' => [
                'cart-rule-title'    => 'カートルール',
                'catalog-rule-title' => 'カタログルール',
            ],

            'cart-rules' => [
                'index' => [
                    'create-btn' => 'カートルールを作成',
                    'title'      => 'カートルール',

                    'datagrid' => [
                        'active'      => '有効',
                        'copy'        => 'コピー',
                        'copy-of'     => ':value',
                        'coupon-code' => 'クーポンコード',
                        'delete'      => '削除',
                        'draft'       => '下書き',
                        'edit'        => '編集',
                        'end'         => '終了',
                        'id'          => 'ID',
                        'inactive'    => '無効',
                        'name'        => '名前',
                        'priority'    => '優先度',
                        'start'       => '開始',
                        'status'      => 'ステータス',
                    ],
                ],

                'create' => [
                    'action-type'                               => 'アクションの種類',
                    'actions'                                   => 'アクション',
                    'add-condition'                             => '条件を追加',
                    'additional'                                => '追加',
                    'all-conditions-true'                       => 'すべての条件が真である',
                    'any-conditions-true'                       => 'いずれかの条件が真である',
                    'apply-to-shipping'                         => '配送に適用',
                    'attribute-family'                          => '属性ファミリー',
                    'attribute-name-children-only'              => '属性名（子カテゴリのみ）',
                    'attribute-name-parent-only'                => '属性名（親カテゴリのみ）',
                    'auto-generate-coupon'                      => 'クーポンを自動生成',
                    'back-btn'                                  => '戻る',
                    'buy-x-get-y-free'                          => 'X個買うとY個無料',
                    'buy-x-quantity'                            => 'X個購入',
                    'cart-attribute'                            => 'カートの属性',
                    'cart-item-attribute'                       => 'カートアイテムの属性',
                    'categories'                                => 'カテゴリ',
                    'channels'                                  => 'チャネル',
                    'children-categories'                       => '子カテゴリのみ',
                    'choose-condition-to-add'                   => '追加する条件を選択',
                    'condition-type'                            => '条件の種類',
                    'conditions'                                => '条件',
                    'contain'                                   => '含む',
                    'contains'                                  => '含む',
                    'coupon-code'                               => 'クーポンコード',
                    'coupon-type'                               => 'クーポンの種類',
                    'create-success'                            => 'カートルールが正常に作成されました',
                    'customer-groups'                           => '顧客グループ',
                    'description'                               => '説明',
                    'discount-amount'                           => '割引額',
                    'does-not-contain'                          => '含まない',
                    'end-of-other-rules'                        => '他のルールの終了',
                    'equals-or-greater-than'                    => '以上',
                    'equals-or-less-than'                       => '以下',
                    'fixed-amount'                              => '固定金額',
                    'fixed-amount-whole-cart'                   => 'カート全体の固定金額',
                    'free-shipping'                             => '送料無料',
                    'from'                                      => '開始',
                    'general'                                   => '一般',
                    'greater-than'                              => 'より大きい',
                    'is-equal-to'                               => '等しい',
                    'is-not-equal-to'                           => '等しくない',
                    'less-than'                                 => 'より小さい',
                    'marketing-time'                            => 'マーケティング時間',
                    'maximum-quantity-allowed-to-be-discounted' => '割引対象とする最大数量',
                    'name'                                      => '名前',
                    'no'                                        => 'いいえ',
                    'no-coupon'                                 => 'クーポンなし',
                    'parent-categories'                         => '親カテゴリのみ',
                    'payment-method'                            => '支払い方法',
                    'percentage-product-price'                  => '商品価格の割引率',
                    'price-in-cart'                             => 'カート内の価格',
                    'priority'                                  => '優先度',
                    'product-attribute'                         => '商品属性',
                    'qty-in-cart'                               => 'カート内の数量',
                    'save-btn'                                  => 'カートルールを保存',
                    'settings'                                  => '設定',
                    'shipping-country'                          => '配送先国',
                    'shipping-method'                           => '配送方法',
                    'shipping-postcode'                         => '配送先郵便番号',
                    'shipping-state'                            => '配送先州',
                    'specific-coupon'                           => '特定のクーポン',
                    'status'                                    => 'ステータス',
                    'subtotal'                                  => '小計',
                    'title'                                     => 'カートルールを作成',
                    'to'                                        => '終了',
                    'total-items-qty'                           => '合計アイテム数量',
                    'total-weight'                              => '合計重量',
                    'uses-per-coupon'                           => 'クーポンごとの使用回数',
                    'uses-per-customer'                         => '顧客ごとの使用回数',
                    'uses-per-customer-control-info'            => 'ログインした顧客のみに適用されます。',
                    'yes'                                       => 'はい',
                ],

                'edit' => [
                    'action-type'                               => 'アクションの種類',
                    'actions'                                   => 'アクション',
                    'add-condition'                             => '条件を追加',
                    'additional'                                => '追加',
                    'all-conditions-true'                       => 'すべての条件が真である',
                    'alphabetical'                              => 'アルファベット',
                    'alphanumeric'                              => '英数字',
                    'any-conditions-true'                       => 'いずれかの条件が真である',
                    'apply-to-shipping'                         => '配送に適用',
                    'attribute-family'                          => '属性ファミリー',
                    'attribute-name-children-only'              => '属性名（子カテゴリのみ）',
                    'attribute-name-parent-only'                => '属性名（親カテゴリのみ）',
                    'auto-generate-coupon'                      => 'クーポンを自動生成',
                    'back-btn'                                  => '戻る',
                    'buy-x-get-y-free'                          => 'X個買うとY個無料',
                    'buy-x-quantity'                            => 'X個購入',
                    'cart-attribute'                            => 'カートの属性',
                    'cart-item-attribute'                       => 'カートアイテムの属性',
                    'categories'                                => 'カテゴリ',
                    'channels'                                  => 'チャネル',
                    'children-categories'                       => '子カテゴリ',
                    'choose-condition-to-add'                   => '追加する条件を選択',
                    'code-format'                               => 'コード形式',
                    'code-prefix'                               => 'コードプレフィックス',
                    'code-suffix'                               => 'コードサフィックス',
                    'condition-type'                            => '条件の種類',
                    'conditions'                                => '条件',
                    'contain'                                   => '含む',
                    'contains'                                  => '含む',
                    'coupon-code'                               => 'クーポンコード',
                    'coupon-length'                             => 'クーポン長さ',
                    'coupon-qty'                                => 'クーポン数量',
                    'coupon-type'                               => 'クーポンの種類',
                    'customer-group'                            => '顧客グループ',
                    'customer-groups'                           => '顧客グループ',
                    'description'                               => '説明',
                    'discount-amount'                           => '割引額',
                    'does-not-contain'                          => '含まない',
                    'end-of-other-rules'                        => '他のルールの終了',
                    'equals-or-greater-than'                    => '以上',
                    'equals-or-less-than'                       => '以下',
                    'fixed-amount'                              => '固定金額',
                    'fixed-amount-whole-cart'                   => 'カート全体の固定金額',
                    'free-shipping'                             => '送料無料',
                    'from'                                      => '開始',
                    'general'                                   => '一般',
                    'generate'                                  => '生成',
                    'greater-than'                              => 'より大きい',
                    'is-equal-to'                               => '等しい',
                    'is-not-equal-to'                           => '等しくない',
                    'less-than'                                 => 'より小さい',
                    'marketing-time'                            => 'マーケティング時間',
                    'maximum-quantity-allowed-to-be-discounted' => '割引対象とする最大数量',
                    'name'                                      => '名前',
                    'no'                                        => 'いいえ',
                    'no-coupon'                                 => 'クーポンなし',
                    'numeric'                                   => '数字',
                    'parent-categories'                         => '親カテゴリ',
                    'payment-method'                            => '支払い方法',
                    'percentage-product-price'                  => '商品価格の割引率',
                    'price-in-cart'                             => 'カート内の価格',
                    'priority'                                  => '優先度',
                    'product-attribute'                         => '商品属性',
                    'qty-in-cart'                               => 'カート内の数量',
                    'save-btn'                                  => 'カートルールを保存',
                    'settings'                                  => '設定',
                    'shipping-country'                          => '配送先国',
                    'shipping-method'                           => '配送方法',
                    'shipping-postcode'                         => '配送先郵便番号',
                    'shipping-state'                            => '配送先州',
                    'specific-coupon'                           => '特定のクーポン',
                    'status'                                    => 'ステータス',
                    'subtotal'                                  => '小計',
                    'title'                                     => 'カートルールを編集',
                    'to'                                        => '終了',
                    'total-items-qty'                           => '合計アイテム数量',
                    'total-weight'                              => '合計重量',
                    'update-success'                            => 'カートルールが正常に更新されました',
                    'uses-per-coupon'                           => 'クーポンごとの使用回数',
                    'uses-per-customer'                         => '顧客ごとの使用回数',
                    'uses-per-customer-control-info'            => 'ログインした顧客のみに適用されます。',
                    'yes'                                       => 'はい',
                ],

                'delete-failed'  => 'カートルールの削除に失敗しました',
                'delete-success' => 'カートルールが正常に削除されました',
            ],

            'catalog-rules' => [
                'index' => [
                    'create-btn' => 'カタログルールを作成',
                    'title'      => 'カタログルール',

                    'datagrid' => [
                        'active'   => 'アクティブ',
                        'delete'   => '削除',
                        'edit'     => '編集',
                        'end'      => '終了',
                        'id'       => 'ID',
                        'inactive' => '非アクティブ',
                        'name'     => '名前',
                        'priority' => '優先度',
                        'start'    => '開始',
                        'status'   => 'ステータス',
                    ],
                ],

                'create' => [
                    'action-type'              => 'アクションの種類',
                    'actions'                  => 'アクション',
                    'add-condition'            => '条件を追加',
                    'all-conditions-true'      => 'すべての条件が真である',
                    'any-conditions-true'      => 'いずれかの条件が真である',
                    'attribute-family'         => '属性ファミリー',
                    'back-btn'                 => '戻る',
                    'categories'               => 'カテゴリ',
                    'channels'                 => 'チャネル',
                    'choose-condition-to-add'  => '追加する条件を選択',
                    'condition-type'           => '条件の種類',
                    'conditions'               => '条件',
                    'contain'                  => '含む',
                    'contains'                 => '含む',
                    'customer-groups'          => '顧客グループ',
                    'description'              => '説明',
                    'discount-amount'          => '割引額',
                    'does-not-contain'         => '含まない',
                    'end-other-rules'          => '他のルールの終了',
                    'equals-or-greater-than'   => '以上',
                    'equals-or-less-than'      => '以下',
                    'fixed-amount'             => '固定金額',
                    'from'                     => '開始',
                    'general'                  => '一般',
                    'greater-than'             => 'より大きい',
                    'is-equal-to'              => '等しい',
                    'is-not-equal-to'          => '等しくない',
                    'less-than'                => 'より小さい',
                    'marketing-time'           => 'マーケティング時間',
                    'name'                     => '名前',
                    'no'                       => 'いいえ',
                    'percentage-product-price' => '商品価格の割引率',
                    'priority'                 => '優先度',
                    'product-attribute'        => '商品属性',
                    'save-btn'                 => 'カタログルールを保存',
                    'settings'                 => '設定',
                    'status'                   => 'ステータス',
                    'title'                    => 'カタログルールを作成',
                    'to'                       => '終了',
                    'yes'                      => 'はい',
                ],

                'edit' => [
                    'action-type'              => 'アクションの種類',
                    'actions'                  => 'アクション',
                    'add-condition'            => '条件を追加',
                    'all-conditions-true'      => 'すべての条件が真である',
                    'any-conditions-true'      => 'いずれかの条件が真である',
                    'back-btn'                 => '戻る',
                    'categories'               => 'カテゴリ',
                    'channels'                 => 'チャネル',
                    'choose-condition-to-add'  => '追加する条件を選択',
                    'condition-type'           => '条件の種類',
                    'conditions'               => '条件',
                    'contain'                  => '含む',
                    'contains'                 => '含む',
                    'customer-groups'          => '顧客グループ',
                    'description'              => '説明',
                    'discount-amount'          => '割引額',
                    'does-not-contain'         => '含まない',
                    'end-other-rules'          => '他のルールの終了',
                    'equals-or-greater-than'   => '以上',
                    'equals-or-less-than'      => '以下',
                    'fixed-amount'             => '固定金額',
                    'from'                     => '開始',
                    'general'                  => '一般',
                    'greater-than'             => 'より大きい',
                    'is-equal-to'              => '等しい',
                    'is-not-equal-to'          => '等しくない',
                    'less-than'                => 'より小さい',
                    'marketing-time'           => 'マーケティング時間',
                    'name'                     => '名前',
                    'no'                       => 'いいえ',
                    'percentage-product-price' => '商品価格の割引率',
                    'priority'                 => '優先度',
                    'product-attribute'        => '商品属性',
                    'save-btn'                 => 'カタログルールを保存',
                    'settings'                 => '設定',
                    'status'                   => 'ステータス',
                    'title'                    => 'カタログルールを編集',
                    'to'                       => '終了',
                    'yes'                      => 'はい',
                ],

                'create-success' => 'カタログルールが正常に作成されました',
                'delete-success' => 'カタログルールが正常に削除されました',
                'update-success' => 'カタログルールが正常に更新されました',
            ],

            'cart-rules-coupons' => [
                'cart-rule-not-defined-error' => 'カートルールは削除できません',
                'delete-success'              => 'カートルールクーポンが正常に削除されました',
                'mass-delete-success'         => '選択したアイテムが正常に削除されました',
                'success'                     => ':name が正常に作成されました',

                'datagrid' => [
                    'coupon-code'     => 'クーポンコード',
                    'created-date'    => '作成日',
                    'delete'          => '削除',
                    'expiration-date' => '有効期限日',
                    'id'              => 'ID',
                    'times-used'      => '使用回数',
                ],
            ],
        ],

        'search-seo' => [
            'search-terms' => [
                'index' => [
                    'create-btn' => '新しい検索キーワードを作成',
                    'title'      => '検索キーワード',

                    'datagrid' => [
                        'actions'             => 'アクション',
                        'channel'             => 'チャンネル',
                        'delete'              => '削除',
                        'edit'                => '編集',
                        'id'                  => 'ID',
                        'locale'              => 'ロケール',
                        'mass-delete-success' => '選択した検索キーワードを正常に削除しました。',
                        'redirect-url'        => 'リダイレクトURL',
                        'results'             => '結果',
                        'search-query'        => '検索クエリ',
                        'uses'                => '使用',
                    ],

                    'create' => [
                        'channel'        => 'チャンネル',
                        'delete-warning' => 'この操作を実行してもよろしいですか？',
                        'locale'         => 'ロケール',
                        'redirect-url'   => 'リダイレクトURL',
                        'results'        => '結果',
                        'save-btn'       => '検索キーワードを保存',
                        'search-query'   => '検索クエリ',
                        'success'        => '検索キーワードを正常に作成しました。',
                        'title'          => '新しい検索キーワードを作成',
                        'uses'           => '使用',
                    ],

                    'edit' => [
                        'delete-success' => '検索キーワードを正常に削除しました。',
                        'success'        => '検索キーワードを正常に更新しました。',
                        'title'          => '検索キーワードを編集',
                    ],
                ],
            ],

            'search-synonyms' => [
                'index' => [
                    'create-btn' => '検索の同義語を作成',
                    'title'      => '検索の同義語',

                    'datagrid' => [
                        'actions'             => 'アクション',
                        'delete'              => '削除',
                        'edit'                => '編集',
                        'id'                  => 'ID',
                        'mass-delete-success' => '選択した検索の同義語が正常に削除されました',
                        'name'                => '名前',
                        'terms'               => '用語',
                    ],

                    'create' => [
                        'delete-warning' => 'このアクションを実行してもよろしいですか？',
                        'name'           => '名前',
                        'save-btn'       => '検索の同義語を保存',
                        'success'        => '検索の同義語が正常に作成されました',
                        'terms'          => '用語',
                        'terms-info'     => 'シノニムをコンマで区切られたリストとして入力してください、例："靴,履物"。これにより、検索をすべての用語に拡張します。',
                        'title'          => '検索の同義語を作成',
                    ],

                    'edit' => [
                        'delete-success' => '検索の同義語が正常に削除されました',
                        'success'        => '検索の同義語が正常に更新されました',
                        'title'          => '検索の同義語を編集',
                    ],
                ],
            ],

            'sitemaps' => [
                'index' => [
                    'create-btn' => 'サイトマップを作成',
                    'sitemap'    => 'サイトマップ',
                    'title'      => 'サイトマップ',

                    'datagrid' => [
                        'actions'         => 'アクション',
                        'delete'          => '削除',
                        'edit'            => '編集',
                        'file-name'       => 'ファイル名',
                        'id'              => 'ID',
                        'link-for-google' => 'Googleへのリンク',
                        'path'            => 'パス',
                    ],

                    'create' => [
                        'delete-warning' => '本当にこのアクションを実行しますか？',
                        'file-name'      => 'ファイル名',
                        'file-name-info' => '例: sitemap.xml',
                        'path'           => 'パス',
                        'path-info'      => '例: "/sitemap/"または"/"（基本パス用）',
                        'save-btn'       => 'サイトマップを保存',
                        'success'        => 'サイトマップが正常に作成されました',
                        'title'          => 'サイトマップを作成',
                    ],

                    'edit' => [
                        'delete-success' => 'サイトマップが正常に削除されました',
                        'success'        => 'サイトマップが正常に更新されました',
                        'title'          => 'サイトマップを編集',
                    ],
                ],

                'edit' => [
                    'back-btn'       => '戻る',
                    'file-name'      => 'ファイル名',
                    'file-name-info' => '例: sitemap.xml',
                    'general'        => '一般',
                    'path'           => 'パス',
                    'path-info'      => '例: "/sitemap/"または"/"（基本パス用）',
                    'save-btn'       => 'サイトマップを保存',
                ],

                'delete-failed' => ':name 削除に失敗しました',
            ],

            'url-rewrites' => [
                'index' => [
                    'create-btn' => 'URLリライトを作成',
                    'title'      => 'URLリライト',

                    'datagrid' => [
                        'actions'             => 'アクション',
                        'delete'              => '削除',
                        'edit'                => '編集',
                        'for'                 => '対象',
                        'id'                  => 'ID',
                        'locale'              => 'ロケール',
                        'mass-delete-success' => '選択したURLリライトが正常に削除されました',
                        'permanent-redirect'  => '恒久的なリダイレクト(301)',
                        'redirect-type'       => 'リダイレクトタイプ',
                        'request-path'        => 'リクエストパス',
                        'target-path'         => 'ターゲットパス',
                        'temporary-redirect'  => '一時的なリダイレクト(302)',
                        'category'            => 'カテゴリ',
                        'cms-page'            => 'CMSページ',
                        'product'             => '製品',
                    ],

                    'create' => [
                        'category'           => 'カテゴリ',
                        'cms-page'           => 'CMSページ',
                        'delete-warning'     => 'このアクションを実行してもよろしいですか？',
                        'for'                => '対象',
                        'locale'             => 'ロケール',
                        'permanent-redirect' => '恒久的なリダイレクト(301)',
                        'product'            => '製品',
                        'redirect-type'      => 'リダイレクトタイプ',
                        'request-path'       => 'リクエストパス',
                        'save-btn'           => 'URLリライトを保存',
                        'success'            => 'URLリライトが正常に作成されました',
                        'target-path'        => 'ターゲットパス',
                        'temporary-redirect' => '一時的なリダイレクト(302)',
                        'title'              => 'URLリライトの作成',
                    ],

                    'edit' => [
                        'delete-success' => 'URLリライトが正常に削除されました',
                        'success'        => 'URLリライトが正常に更新されました',
                        'title'          => 'URLリライトの編集',
                    ],
                ],
            ],
        ],
    ],

    'cms' => [
        'index' => [
            'already-taken' => ':name は既に使用されています。',
            'create-btn'    => 'ページを作成',
            'channel'       => 'チャンネル',
            'language'      => '言語',
            'title'         => 'ページ',

            'datagrid' => [
                'channel'             => 'チャンネル',
                'delete'              => '削除',
                'edit'                => '編集',
                'id'                  => 'ID',
                'mass-delete-success' => '選択したデータが正常に削除されました',
                'page-title'          => 'ページタイトル',
                'url-key'             => 'URLキー',
                'view'                => '表示',
            ],
        ],

        'create' => [
            'channels'         => 'チャンネル',
            'content'          => 'コンテンツ',
            'description'      => '説明',
            'general'          => '一般',
            'meta-description' => 'メタディスクリプション',
            'meta-keywords'    => 'メタキーワード',
            'meta-title'       => 'メタタイトル',
            'page-title'       => 'タイトル',
            'save-btn'         => 'ページを保存',
            'seo'              => 'SEO',
            'title'            => 'ページを作成',
            'url-key'          => 'URLキー',
        ],

        'edit' => [
            'back-btn'         => '戻る',
            'channels'         => 'チャンネル',
            'content'          => 'コンテンツ',
            'description'      => '説明',
            'general'          => '一般',
            'meta-description' => 'メタディスクリプション',
            'meta-keywords'    => 'メタキーワード',
            'meta-title'       => 'メタタイトル',
            'page-title'       => 'ページタイトル',
            'preview-btn'      => 'ページをプレビュー',
            'save-btn'         => 'ページを保存',
            'seo'              => 'SEO',
            'title'            => 'ページを編集',
            'url-key'          => 'URLキー',
        ],

        'create-success' => 'CMSが正常に作成されました。',
        'delete-success' => 'CMSが正常に削除されました。',
        'no-resource'    => 'リソースが存在しません。',
        'update-success' => 'CMSが正常に更新されました。',
    ],

    'settings' => [
        'locales' => [
            'index' => [
                'create-btn' => 'ロケールを作成',
                'locale'     => 'ロケール',
                'logo-size'  => '画像の解像度は24px × 16pxのようである必要があります',
                'title'      => 'ロケール',

                'datagrid' => [
                    'actions'   => 'アクション',
                    'code'      => 'コード',
                    'delete'    => '削除',
                    'direction' => '方向',
                    'edit'      => '編集',
                    'id'        => 'ID',
                    'ltr'       => 'LTR',
                    'name'      => '名前',
                    'rtl'       => 'RTL',
                ],

                'create' => [
                    'code'             => 'コード',
                    'direction'        => '方向',
                    'locale-logo'      => 'ロケールロゴ',
                    'name'             => '名前',
                    'save-btn'         => 'ロケールを保存',
                    'select-direction' => '方向を選択',
                    'title'            => 'ロケールを作成',
                ],

                'edit' => [
                    'title' => 'ロケールを編集',
                ],

                'create-success'    => 'ロケールが正常に作成されました。',
                'delete-failed'     => 'ロケールの削除に失敗しました',
                'delete-success'    => 'ロケールが正常に削除されました。',
                'delete-warning'    => '本当にこのアクションを実行しますか？',
                'last-delete-error' => '最低でも1つのロケールが必要です。',
                'update-success'    => 'ロケールが正常に更新されました。',
            ],
        ],

        'currencies' => [
            'index' => [
                'create-btn' => '通貨を作成',
                'currency'   => '通貨',
                'title'      => '通貨',

                'datagrid' => [
                    'actions'        => 'アクション',
                    'code'           => 'コード',
                    'delete'         => '削除',
                    'edit'           => '編集',
                    'id'             => 'ID',
                    'method-error'   => 'エラー！誤ったメソッドが検出されました。マスアクションの構成を確認してください',
                    'name'           => '名前',
                    'no-resource'    => 'アクションに対して提供されたリソースが不足しています',
                    'partial-action' => ':resource への制約により、一部のアクションが実行されませんでした',
                    'update-success' => '選択した :resource が正常に更新されました',
                ],

                'create' => [
                    'code'              => 'コード',
                    'create-btn'        => '通貨を作成',
                    'currency-position' => '通貨位置',
                    'decimal'           => '小数点',
                    'decimal-separator' => '小数点区切り文字',
                    'delete-warning'    => '本当にこのアクションを実行しますか？',
                    'general'           => '一般',
                    'group-separator'   => 'グループ区切り',
                    'name'              => '名前',
                    'save-btn'          => '通貨を保存',
                    'symbol'            => '記号',
                    'title'             => '新しい通貨を作成',
                ],

                'edit' => [
                    'title' => '通貨を編集',
                ],

                'create-success'    => '通貨が正常に作成されました。',
                'delete-failed'     => '通貨の削除に失敗しました',
                'delete-success'    => '通貨が正常に削除されました。',
                'last-delete-error' => '少なくとも1つの通貨が必要です。',
                'update-success'    => '通貨が正常に更新されました。',
            ],
        ],

        'data-transfer' => [
            'imports' => [
                'create' => [
                    'action'              => 'アクション',
                    'allowed-errors'      => '許可されたエラー',
                    'back-btn'            => '戻る',
                    'create-update'       => '作成/更新',
                    'delete'              => '削除',
                    'download-sample'     => 'サンプルをダウンロード',
                    'field-separator'     => 'フィールドセパレータ',
                    'file-info-example'   => '例: 製品イメージの場合、ファイルは/project-root/storage/app/import/product-imagesフォルダーに配置する必要があります。',
                    'file-info'           => '/project-root/storage/import/appへの相対パスを使用してください、例: product-images, import-images.',
                    'file'                => 'ファイル',
                    'general'             => '一般',
                    'images-directory'    => '画像ディレクトリーパス',
                    'process-in-queue'    => 'キューで処理',
                    'results'             => '結果',
                    'save-btn'            => 'インポートを保存',
                    'settings'            => '設定',
                    'skip-errors'         => 'エラーをスキップ',
                    'stop-on-errors'      => 'エラーで停止',
                    'title'               => 'インポートの作成',
                    'type'                => 'タイプ',
                    'validation-strategy' => 'バリデーション戦略',
                ],

                'edit' => [
                    'action'              => 'アクション',
                    'allowed-errors'      => '許可されたエラー',
                    'back-btn'            => '戻る',
                    'create-update'       => '作成/更新',
                    'delete'              => '削除',
                    'download-sample'     => 'サンプルをダウンロード',
                    'field-separator'     => 'フィールドセパレータ',
                    'file-info-example'   => '例: 製品イメージの場合、ファイルは/project-root/storage/app/import/product-imagesフォルダーに配置する必要があります。',
                    'file-info'           => '/project-root/storage/app/importへの相対パスを使用してください、例: product-images, import-images.',
                    'file'                => 'ファイル',
                    'general'             => '一般',
                    'images-directory'    => '画像ディレクトリーパス',
                    'process-in-queue'    => 'キューで処理',
                    'results'             => '結果',
                    'save-btn'            => 'インポートを保存',
                    'settings'            => '設定',
                    'skip-errors'         => 'エラーをスキップ',
                    'stop-on-errors'      => 'エラーで停止',
                    'title'               => 'インポートの編集',
                    'type'                => 'タイプ',
                    'validation-strategy' => '検証戦略',
                ],

                'index' => [
                    'button-title' => 'インポートの作成',
                    'title'        => '輸入品',

                    'datagrid' => [
                        'actions'       => '行動',
                        'completed-at'  => '完了日',
                        'created'       => '作成した',
                        'delete'        => '消去',
                        'deleted'       => '削除されました',
                        'edit'          => '編集',
                        'error-file'    => 'エラーファイル',
                        'id'            => 'ID',
                        'started-at'    => '開始日',
                        'state'         => '州',
                        'summary'       => 'まとめ',
                        'updated'       => '更新しました',
                        'uploaded-file' => 'アップロードされたファイル',
                    ],
                ],

                'import' => [
                    'back-btn'                => '戻る',
                    'completed-batches'       => '完了したバッチの合計:',
                    'download-error-report'   => '完全なレポートをダウンロード',
                    'edit-btn'                => '編集',
                    'imported-info'           => 'おめでとう！インポートは成功しました。',
                    'importing-info'          => 'インポート中',
                    'indexing-info'           => 'リソースのインデックス作成 (価格、在庫、エラスティック検索) が進行中です',
                    'linking-info'            => 'リソースのリンクが進行中です',
                    'progress'                => '進捗：',
                    'title'                   => '輸入',
                    'total-batches'           => '合計バッチ数:',
                    'total-created'           => '作成された合計レコード数:',
                    'total-deleted'           => '削除されたレコードの合計:',
                    'total-errors'            => '合計エラー数:',
                    'total-invalid-rows'      => '無効な行の合計:',
                    'total-rows-processed'    => '処理された合計行数:',
                    'total-updated'           => '更新された合計レコード:',
                    'validate-info'           => '「データの検証」をクリックしてインポートを確認します。',
                    'validate'                => '検証',
                    'validating-info'         => 'データの読み取りと検証が開始されました',
                    'validation-failed-info'  => 'インポートは無効です。次のエラーを修正して再試行してください。',
                    'validation-success-info' => 'インポートは有効です。 「インポート」をクリックしてインポートプロセスを開始します。',
                ],

                'create-success'    => 'インポートが正常に作成されました。',
                'delete-failed'     => 'インポートの削除が予期せず失敗しました。',
                'delete-success'    => 'インポートは正常に削除されました。',
                'not-valid'         => 'インポートが無効です',
                'nothing-to-import' => 'インポートするリソースがありません。',
                'setup-queue-error' => 'インポート プロセスを開始するには、キュー ドライバーを「データベース」または「redis」に変更してください。',
                'update-success'    => 'インポートは正常に更新されました。',
            ],
        ],

        'exchange-rates' => [
            'index' => [
                'create-btn'    => '為替レートを作成',
                'exchange-rate' => '為替レート',
                'title'         => '為替レート',
                'update-rates'  => '為替レートを更新',

                'create' => [
                    'delete-warning'         => '本当にこのアクションを実行しますか？',
                    'rate'                   => 'レート',
                    'save-btn'               => '為替レートを保存',
                    'select-target-currency' => '目標通貨を選択',
                    'source-currency'        => '元通貨',
                    'target-currency'        => 'ターゲット通貨',
                    'title'                  => '為替レートを作成',
                ],

                'edit' => [
                    'title'   => '為替レートを編集',
                ],

                'datagrid' => [
                    'actions'       => 'アクション',
                    'currency-name' => '通貨名',
                    'delete'        => '削除',
                    'edit'          => '編集',
                    'exchange-rate' => '為替レート',
                    'id'            => 'ID',
                ],

                'create-success' => '為替レートが正常に作成されました',
                'delete-error'   => '為替レートの削除エラー',
                'delete-success' => '為替レートが正常に削除されました',
                'update-success' => '為替レートが正常に更新されました',
            ],
        ],

        'inventory-sources' => [
            'index' => [
                'create-btn' => '在庫ソースを作成する',
                'title'      => '在庫ソース',

                'datagrid' => [
                    'active'   => 'アクティブ',
                    'code'     => 'コード',
                    'delete'   => '削除',
                    'edit'     => '編集',
                    'id'       => 'ID',
                    'inactive' => '非アクティブ',
                    'name'     => '名前',
                    'priority' => '優先度',
                    'status'   => 'ステータス',
                ],
            ],

            'create' => [
                'add-title'      => '在庫ソースを追加',
                'address'        => 'ソース住所',
                'back-btn'       => '戻る',
                'city'           => '市区町村',
                'code'           => 'コード',
                'contact-email'  => 'メール',
                'contact-fax'    => 'FAX',
                'contact-info'   => '連絡先情報',
                'contact-name'   => '名前',
                'contact-number' => '連絡先番号',
                'country'        => '国',
                'description'    => '説明',
                'general'        => '一般',
                'latitude'       => '緯度',
                'longitude'      => '経度',
                'name'           => '名前',
                'postcode'       => '郵便番号',
                'priority'       => '優先度',
                'save-btn'       => '在庫ソースを保存',
                'select-country' => '国を選択',
                'select-state'   => '都道府県を選択',
                'settings'       => '設定',
                'state'          => '都道府県',
                'status'         => 'ステータス',
                'street'         => '番地',
                'title'          => '在庫ソース',
            ],

            'edit' => [
                'back-btn'       => '戻る',
                'city'           => '市区町村',
                'code'           => 'コード',
                'contact-email'  => 'メール',
                'contact-fax'    => 'FAX',
                'contact-info'   => '連絡先情報',
                'contact-name'   => '名前',
                'contact-number' => '連絡先番号',
                'country'        => '国',
                'description'    => '説明',
                'general'        => '一般',
                'latitude'       => '緯度',
                'longitude'      => '経度',
                'name'           => '名前',
                'postcode'       => '郵便番号',
                'priority'       => '優先度',
                'save-btn'       => '在庫ソースを保存',
                'select-country' => '国を選択',
                'select-state'   => '都道府県を選択',
                'settings'       => '設定',
                'source-address' => 'ソース住所',
                'state'          => '都道府県',
                'status'         => 'ステータス',
                'street'         => '番地',
                'title'          => '在庫ソースを編集',
            ],

            'create-success'    => '在庫ソースが正常に作成されました',
            'delete-failed'     => '在庫ソースの削除に失敗しました',
            'delete-success'    => '在庫ソースが正常に削除されました',
            'last-delete-error' => '最後の在庫ソースは削除できません',
            'update-success'    => '在庫ソースが正常に更新されました',
        ],

        'taxes' => [
            'categories' => [
                'index' => [
                    'delete-warning' => '本当に削除しますか？',
                    'tax-category'   => '税カテゴリー',
                    'title'          => '税カテゴリー',

                    'datagrid' => [
                        'actions' => 'アクション',
                        'code'    => 'コード',
                        'delete'  => '削除',
                        'edit'    => '編集',
                        'id'      => 'ID',
                        'name'    => '名前',
                    ],

                    'create' => [
                        'add-tax-rates' => '税率を追加',
                        'code'          => 'コード',
                        'description'   => '説明',
                        'empty-text'    => '税率は利用できません。新しい税率を作成してください。',
                        'general'       => '税カテゴリー',
                        'name'          => '名前',
                        'save-btn'      => '税カテゴリーを保存',
                        'select'        => '選択',
                        'tax-rates'     => '税率',
                        'title'         => '税カテゴリーを作成',
                    ],

                    'edit' => [
                        'title' => '税カテゴリーを編集',
                    ],

                    'create-success' => '新しい税カテゴリーが作成されました',
                    'delete-failed'  => '税カテゴリーの削除に失敗しました',
                    'delete-success' => '税カテゴリーが正常に削除されました',
                    'update-success' => '税カテゴリーが正常に更新されました',
                ],
            ],

            'rates' => [
                'index' => [
                    'button-title' => '税率を作成する',
                    'tax-rate'     => '税率',
                    'title'        => '税率',

                    'datagrid' => [
                        'country'    => '国',
                        'delete'     => '削除',
                        'edit'       => '編集',
                        'id'         => 'ID',
                        'identifier' => '識別子',
                        'state'      => '州',
                        'tax-rate'   => '税率',
                        'zip-code'   => '郵便番号',
                        'zip-from'   => '開始郵便番号',
                        'zip-to'     => '終了郵便番号',
                    ],
                ],

                'create' => [
                    'back-btn'       => '戻る',
                    'country'        => '国',
                    'general'        => '一般',
                    'identifier'     => '識別子',
                    'is-zip'         => '郵便番号範囲を有効にする',
                    'save-btn'       => '税率を保存',
                    'select-country' => '国を選択',
                    'select-state'   => '州を選択',
                    'settings'       => '設定',
                    'state'          => '州',
                    'tax-rate'       => '税率',
                    'title'          => '税率を作成',
                    'zip-code'       => '郵便番号',
                    'zip-from'       => '開始郵便番号',
                    'zip-to'         => '終了郵便番号',
                ],

                'edit' => [
                    'back-btn'       => '戻る',
                    'country'        => '国',
                    'identifier'     => '識別子',
                    'save-btn'       => '税率を保存',
                    'select-country' => '国を選択',
                    'select-state'   => '州を選択',
                    'settings'       => '設定',
                    'state'          => '州',
                    'tax-rate'       => '税率',
                    'title'          => '税率を編集',
                    'zip-code'       => '郵便番号',
                    'zip-from'       => '開始郵便番号',
                    'zip-to'         => '終了郵便番号',
                ],

                'create-success' => '税率が正常に作成されました。',
                'delete-failed'  => '税率の削除に失敗しました',
                'delete-success' => '税率が正常に削除されました',
                'update-success' => '税率が正常に更新されました',
            ],
        ],

        'channels' => [
            'index' => [
                'create-btn'        => 'チャネルを作成',
                'delete-failed'     => 'チャンネル の削除に失敗しました',
                'delete-success'    => 'チャネルが正常に削除されました。',
                'last-delete-error' => '最後のチャネルの削除に失敗しました。',
                'title'             => 'チャネル',

                'datagrid' => [
                    'code'      => 'コード',
                    'delete'    => '削除',
                    'edit'      => '編集',
                    'host-name' => 'ホスト名',
                    'id'        => 'ID',
                    'name'      => '名前',
                ],
            ],

            'create' => [
                'allowed-ips'             => '許可されたIP',
                'cancel'                  => '戻る',
                'code'                    => 'コード',
                'create-success'          => 'チャネルが正常に作成されました。',
                'currencies'              => '通貨',
                'currencies-and-locales'  => '通貨とロケール',
                'default-currency'        => 'デフォルト通貨',
                'default-locale'          => 'デフォルトロケール',
                'description'             => '説明',
                'design'                  => 'デザイン',
                'favicon'                 => 'ファビコン',
                'favicon-size'            => '画像の解像度は16px X 16pxのようにする必要があります',
                'general'                 => '一般',
                'hostname'                => 'ホスト名',
                'hostname-placeholder'    => 'https://www.example.com（末尾にスラッシュを追加しないでください。）',
                'inventory-sources'       => '在庫ソース',
                'last-delete-error'       => '少なくとも1つのチャネルが必要です。',
                'locales'                 => 'ロケール',
                'logo'                    => 'ロゴ',
                'logo-size'               => '画像の解像度は192px X 50pxのようにする必要があります',
                'maintenance-mode-text'   => 'メッセージ',
                'name'                    => '名前',
                'root-category'           => 'ルートカテゴリー',
                'save-btn'                => 'チャネルを保存',
                'select-default-currency' => 'デフォルト通貨を選択',
                'select-default-locale'   => 'デフォルトロケールを選択',
                'select-root-category'    => 'ルートカテゴリを選択',
                'select-theme'            => 'テーマを選択',
                'seo'                     => 'ホームページのSEO',
                'seo-description'         => 'メタディスクリプション',
                'seo-keywords'            => 'メタキーワード',
                'seo-title'               => 'メタタイトル',
                'settings'                => '設定',
                'status'                  => 'ステータス',
                'theme'                   => 'テーマ',
                'title'                   => 'チャネルを作成',
            ],

            'edit' => [
                'allowed-ips'            => '許可されたIP',
                'back-btn'               => '戻る',
                'code'                   => 'コード',
                'currencies'             => '通貨',
                'currencies-and-locales' => '通貨とロケール',
                'default-currency'       => 'デフォルト通貨',
                'default-locale'         => 'デフォルトロケール',
                'description'            => '説明',
                'design'                 => 'デザイン',
                'favicon'                => 'ファビコン',
                'favicon-size'           => '画像の解像度は16px X 16pxのようにする必要があります',
                'general'                => '一般',
                'hostname'               => 'ホスト名',
                'hostname-placeholder'   => 'https://www.example.com（末尾にスラッシュを追加しないでください。）',
                'inventory-sources'      => '在庫ソース',
                'last-delete-error'      => '少なくとも1つのチャネルが必要です。',
                'locales'                => 'ロケール',
                'logo'                   => 'ロゴ',
                'logo-size'              => '画像の解像度は192px X 50pxのようにする必要があります',
                'maintenance-mode'       => 'メンテナンスモード',
                'maintenance-mode-text'  => 'メッセージ',
                'name'                   => '名前',
                'root-category'          => 'ルートカテゴリー',
                'save-btn'               => 'チャネルを保存',
                'seo'                    => 'ホームページのSEO',
                'seo-description'        => 'メタディスクリプション',
                'seo-keywords'           => 'メタキーワード',
                'seo-title'              => 'メタタイトル',
                'status'                 => 'ステータス',
                'theme'                  => 'テーマ',
                'title'                  => 'チャネルを編集',
                'update-success'         => 'チャネルが正常に更新されました。',
            ],
        ],

        'users' => [
            'index' => [
                'admin' => '管理者',
                'title' => 'ユーザー',
                'user'  => 'ユーザー',

                'create' => [
                    'confirm-password'  => 'パスワードの確認',
                    'email'             => 'メール',
                    'name'              => '名前',
                    'password'          => 'パスワード',
                    'role'              => '役割',
                    'save-btn'          => 'ユーザーを保存',
                    'status'            => 'ステータス',
                    'title'             => 'ユーザーを作成',
                    'upload-image-info' => 'プロフィール画像をアップロードしてください（110px X 110px）PNGまたはJPG形式',
                ],

                'datagrid' => [
                    'actions'  => 'アクション',
                    'active'   => 'アクティブ',
                    'delete'   => '削除',
                    'edit'     => '編集',
                    'email'    => 'メール',
                    'id'       => 'ID',
                    'inactive' => '非アクティブ',
                    'name'     => '名前',
                    'role'     => '役割',
                    'status'   => 'ステータス',
                ],

                'edit' => [
                    'title' => 'ユーザーを編集',
                ],
            ],

            'edit' => [
                'back-btn'         => '戻る',
                'confirm-password' => 'パスワードの確認',
                'email'            => 'メール',
                'general'          => '一般',
                'name'             => '名前',
                'password'         => 'パスワード',
                'role'             => '役割',
                'save-btn'         => 'ユーザーを保存',
                'status'           => 'ステータス',
                'title'            => 'ユーザーを編集',
            ],

            'activate-warning'   => 'アカウントはまだ有効になっていません。管理者に連絡してください。',
            'cannot-change'      => 'ユーザーは変更できません。',
            'create-success'     => 'ユーザーが正常に作成されました。',
            'delete-failed'      => 'ユーザーの削除に失敗しました。',
            'delete-success'     => 'ユーザーが正常に削除されました。',
            'delete-warning'     => 'このアクションを実行してもよろしいですか？',
            'incorrect-password' => 'パスワードが正しくありません',
            'last-delete-error'  => '最後のユーザーの削除に失敗しました。',
            'login-error'        => '資格情報を確認して、もう一度試してください。',
            'update-success'     => 'ユーザーが正常に更新されました。',
        ],

        'roles' => [
            'index' => [
                'create-btn' => '役割を作成',
                'title'      => '役割',

                'datagrid' => [
                    'custom'          => 'カスタム',
                    'all'             => 'すべて',
                    'permission-type' => '権限タイプ',
                    'name'            => '名前',
                    'id'              => 'ID',
                    'edit'            => '編集',
                    'delete'          => '削除',
                ],
            ],

            'create' => [
                'access-control' => 'アクセス制御',
                'all'            => 'すべて',
                'back-btn'       => '戻る',
                'custom'         => 'カスタム',
                'description'    => '説明',
                'general'        => '一般',
                'name'           => '名前',
                'permissions'    => '権限',
                'save-btn'       => '役割を保存',
                'title'          => '役割を作成',
            ],

            'edit' => [
                'access-control' => 'アクセス制御',
                'all'            => 'すべて',
                'back-btn'       => '戻る',
                'custom'         => 'カスタム',
                'description'    => '説明',
                'general'        => '一般',
                'name'           => '名前',
                'permissions'    => '権限',
                'save-btn'       => '役割を保存',
                'title'          => '役割を編集',
            ],

            'being-used'        => '役割はすでに管理者ユーザーで使用されています',
            'create-success'    => '役割が正常に作成されました',
            'delete-failed'     => '役割の削除に失敗しました',
            'delete-success'    => '役割が正常に削除されました',
            'last-delete-error' => '最後の役割は削除できません',
            'update-success'    => '役割が正常に更新されました',
        ],

        'themes' => [
            'index' => [
                'create-btn' => 'テーマを作成',
                'title'      => 'テーマ',

                'datagrid' => [
                    'active'       => 'アクティブ',
                    'channel_name' => 'チャンネル名',
                    'delete'       => '削除',
                    'id'           => 'ID',
                    'inactive'     => '非アクティブ',
                    'name'         => '名前',
                    'sort-order'   => '並び替え順',
                    'status'       => 'ステータス',
                    'theme'        => 'テーマ',
                    'type'         => 'タイプ',
                    'view'         => '表示',
                ],
            ],

            'create' => [
                'name'       => '名前',
                'save-btn'   => 'テーマを保存する',
                'sort-order' => '並び替え順',
                'themes'     => 'テーマ',
                'title'      => 'テーマを作成',

                'type' => [
                    'category-carousel' => 'カテゴリーカルーセル',
                    'footer-links'      => 'フッターリンク',
                    'image-carousel'    => '画像カルーセル',
                    'product-carousel'  => '商品カルーセル',
                    'services-content'  => 'サービス内容',
                    'static-content'    => '静的コンテンツ',
                    'title'             => 'タイプ',
                ],
            ],

            'edit' => [
                'active'                        => 'アクティブ',
                'add-filter-btn'                => 'フィルターを追加',
                'add-footer-link-btn'           => 'フッターリンクを追加',
                'add-image-btn'                 => '画像を追加',
                'add-link'                      => 'リンクを追加',
                'asc'                           => '昇順',
                'back'                          => '戻る',
                'category-carousel'             => 'カテゴリーカルーセル',
                'category-carousel-description' => 'レスポンシブなカテゴリーカルーセルを使用して、動的なカテゴリーを魅力的に表示します。',
                'channels'                      => 'チャンネル',
                'column'                        => 'カラム',
                'create-filter'                 => 'フィルターを作成',
                'css'                           => 'CSS',
                'delete'                        => '削除',
                'desc'                          => '降順',
                'edit'                          => '編集',
                'featured'                      => '注目',
                'filter-title'                  => 'タイトル',
                'filters'                       => 'フィルター',
                'footer-link'                   => 'フッターリンク',
                'footer-link-description'       => 'ウェブサイトのシームレスな探索と情報取得のために、フッターリンクを介してナビゲートします。',
                'footer-link-form-title'        => 'フッターリンク',
                'footer-title'                  => 'タイトル',
                'general'                       => '一般',
                'html'                          => 'HTML',
                'image'                         => '画像',
                'image-size'                    => '画像の解像度は（1920px X 700px）である必要があります',
                'image-title'                   => '画像のタイトル',
                'image-upload-message'          => '画像のみ（.jpeg、.jpg、.png、.webp、..）が許可されています。',
                'inactive'                      => '非アクティブ',
                'key'                           => 'キー：:key',
                'key-input'                     => 'キー',
                'limit'                         => '制限',
                'link'                          => 'リンク',
                'name'                          => '名前',
                'new'                           => '新しい',
                'no'                            => 'いいえ',
                'parent-id'                     => '親ID',
                'category-id'                   => 'カテゴリID',
                'preview'                       => 'プレビュー',
                'product-carousel'              => '商品カルーセル',
                'product-carousel-description'  => '動的でレスポンシブな商品カルーセルを使用して、製品をエレガントにショーケースします。',
                'save-btn'                      => '保存',
                'select'                        => '選択',
                'slider'                        => 'スライダー',
                'slider-add-btn'                => 'スライダーを追加',
                'slider-description'            => 'スライダー関連のテーマのカスタマイズ。',
                'slider-image'                  => 'スライダー画像',
                'slider-required'               => 'スライダーフィールドは必須です。',
                'sort'                          => '並び替え',
                'sort-order'                    => '並び替え順',
                'static-content'                => '静的コンテンツ',
                'static-content-description'    => '観客に向けて簡潔で情報豊かな静的コンテンツでエンゲージメントを向上させます。',
                'status'                        => 'ステータス',
                'themes'                        => 'テーマ',
                'title'                         => 'テーマを編集',
                'update-slider'                 => 'スライダーを更新',
                'url'                           => 'URL',
                'value'                         => '値：:value',
                'value-input'                   => '値',

                'services-content' => [
                    'add-btn'            => 'サービスを追加',
                    'channels'           => 'チャンネル',
                    'delete'             => '削除',
                    'description'        => '説明',
                    'general'            => '一般',
                    'name'               => '名前',
                    'save-btn'           => '保存',
                    'service-icon'       => 'サービスアイコン',
                    'service-icon-class' => 'サービスアイコンクラス',
                    'service-info'       => 'サービス関連のテーマのカスタマイズ。',
                    'services'           => 'サービス',
                    'sort-order'         => '並べ替え順序',
                    'status'             => 'ステータス',
                    'title'              => 'タイトル',
                    'update-service'     => 'サービスを更新',
                ],
                'yes'                           => 'はい',
            ],

            'create-success' => 'テーマが正常に作成されました',
            'delete-success' => 'テーマが正常に削除されました',
            'update-success' => 'テーマが正常に更新されました',
        ],
    ],

    'reporting' => [
        'sales' => [
            'index' => [
                'abandoned-carts'               => '放棄されたカート',
                'abandoned-products'            => '放棄された商品',
                'abandoned-rate'                => '放棄率',
                'abandoned-revenue'             => '放棄された売上',
                'added-to-cart'                 => 'カートに追加',
                'added-to-cart-info'            => '進捗中の訪問者のみがカートに商品を追加',
                'all-channels'                  => 'すべてのチャンネル',
                'average-order-value-over-time' => '平均注文金額の推移',
                'average-sales'                 => '平均注文金額',
                'count'                         => 'カウント',
                'end-date'                      => '終了日',
                'id'                            => 'ID',
                'interval'                      => 'インターバル',
                'name'                          => '名前',
                'orders'                        => '注文',
                'orders-over-time'              => '注文の推移',
                'payment-method'                => '支払い方法',
                'product-views'                 => '商品閲覧数',
                'product-views-info'            => '進捗中の訪問者のみが商品を閲覧',
                'purchase-funnel'               => '購入ファネル',
                'purchased'                     => '購入済み',
                'purchased-info'                => '進捗中の訪問者のみが購入',
                'refunds'                       => '払い戻し',
                'refunds-over-time'             => '払い戻しの推移',
                'sales-over-time'               => '売上の推移',
                'shipping-collected'            => '送料収集',
                'shipping-collected-over-time'  => '送料収集の推移',
                'start-date'                    => '開始日',
                'tax-collected'                 => '税金収集',
                'tax-collected-over-time'       => '税金収集の推移',
                'title'                         => '売上',
                'top-payment-methods'           => 'トップ支払い方法',
                'top-shipping-methods'          => 'トップ配送方法',
                'top-tax-categories'            => 'トップ税カテゴリー',
                'total'                         => '合計',
                'total-orders'                  => '合計注文数',
                'total-sales'                   => '合計売上',
                'total-visits'                  => '合計訪問数',
                'total-visits-info'             => '店舗の合計訪問者数',
                'view-details'                  => '詳細を表示',
            ],
        ],

        'customers' => [
            'index' => [
                'all-channels'                => 'すべてのチャンネル',
                'count'                       => 'カウント',
                'customers'                   => '顧客',
                'customers-over-time'         => '顧客の推移',
                'customers-traffic'           => '顧客トラフィック',
                'customers-with-most-orders'  => '最も多くの注文をした顧客',
                'customers-with-most-reviews' => '最も多くのレビューをした顧客',
                'customers-with-most-sales'   => '最も多くの売上をした顧客',
                'email'                       => 'メールアドレス',
                'end-date'                    => '終了日',
                'id'                          => 'ID',
                'interval'                    => 'インターバル',
                'name'                        => '名前',
                'orders'                      => '注文',
                'reviews'                     => 'レビュー',
                'start-date'                  => '開始日',
                'title'                       => '顧客',
                'top-customer-groups'         => 'トップ顧客グループ',
                'total'                       => '合計',
                'total-customers'             => '合計顧客数',
                'total-visitors'              => '合計訪問者',
                'traffic-over-week'           => '週のトラフィック',
                'unique-visitors'             => 'ユニーク訪問者',
                'view-details'                => '詳細を表示',
            ],
        ],

        'products' => [
            'index' => [
                'all-channels'                     => 'すべてのチャンネル',
                'channel'                          => 'チャンネル',
                'end-date'                         => '終了日',
                'id'                               => 'ID',
                'interval'                         => 'インターバル',
                'last-search-terms'                => '直近の検索語',
                'locale'                           => 'ロケール',
                'name'                             => '名前',
                'orders'                           => '注文',
                'price'                            => '価格',
                'products-added-over-time'         => '時間別商品追加数',
                'products-with-most-reviews'       => '最多レビュー商品',
                'products-with-most-visits'        => '最多訪問商品',
                'quantities'                       => '数量',
                'quantities-sold-over-time'        => '時間別販売数量',
                'results'                          => '検索結果',
                'revenue'                          => '売上',
                'reviews'                          => 'レビュー',
                'search-term'                      => '検索語',
                'start-date'                       => '開始日',
                'title'                            => '商品',
                'top-search-terms'                 => '人気検索語',
                'top-selling-products-by-quantity' => '数量別最売商品',
                'top-selling-products-by-revenue'  => '売上別最売商品',
                'total'                            => '合計',
                'total-products-added-to-wishlist' => 'ウィッシュリストへの商品追加数',
                'total-sold-quantities'            => '販売済商品数量',
                'uses'                             => '利用',
                'view-details'                     => '詳細を表示',
                'visits'                           => 'アクセス数',
            ],
        ],

        'view' => [
            'all-channels'  => 'すべてのチャンネル',
            'day'           => '日',
            'end-date'      => '終了日',
            'export-csv'    => 'CSVエクスポート',
            'export-xls'    => 'XLSエクスポート',
            'month'         => '月',
            'not-available' => '利用可能なレコードはありません。',
            'start-date'    => '開始日',
            'year'          => '年',
        ],

        'empty' => [
            'info'  => '選択した期間のデータはありません',
            'title' => 'データは利用できません',
        ],
    ],

    'configuration' => [
        'index' => [
            'back-btn'                     => '戻る',
            'delete'                       => '削除',
            'enable-at-least-one-payment'  => '少なくとも1つの支払い方法を有効にしてください。',
            'enable-at-least-one-shipping' => '少なくとも1つの配送方法を有効にしてください。',
            'no-result-found'              => '結果が見つかりませんでした',
            'save-btn'                     => '設定を保存',
            'save-message'                 => '設定が正常に保存されました',
            'search'                       => '検索',
            'select-country'               => '国を選択',
            'select-state'                 => '都道府県を選択',
            'title'                        => '設定',

            'general' => [
                'info'  => 'ユニットオプションを設定します。',
                'title' => '一般',

                'general' => [
                    'info'  => 'ユニットオプションを設定します。',
                    'title' => '一般',

                    'unit-options' => [
                        'info'        => 'ユニットオプションを設定します。',
                        'title'       => 'ユニットオプション',
                        'title-info'  => '重量をポンド（lbs）またはキログラム（kgs）で設定してください。',
                        'weight-unit' => '重量単位',
                    ],

                    'breadcrumbs' => [
                        'shop'       => 'ショップのパンくずリスト',
                        'title'      => 'パンくずリスト',
                        'title-info' => 'ショップでのパンくずリストのナビゲーションを有効または無効にします。',
                    ],
                ],

                'content' => [
                    'info'  => '比較オプション、ウィッシュリストオプション、画像検索オプション、フッター、フッターの切り替え、カスタムスクリプトを設定します。',
                    'title' => 'コンテンツ',

                    'header-offer' => [
                        'title'             => 'ヘッダーオファータイトル',
                        'title-info'        => 'オファータイトル、リダイレクションタイトル、リダイレクションリンクを設定してヘッダーオファータイトルを構成します。',
                        'offer-title'       => 'オファータイトル',
                        'redirection-title' => 'リダイレクションタイトル',
                        'redirection-link'  => 'リダイレクションリンク',
                    ],

                    'custom-scripts' => [
                        'custom-css'        => 'カスタムCSS',
                        'custom-javascript' => 'カスタムJavascript',
                        'title'             => 'カスタムスクリプト',
                        'title-info'        => 'カスタムスクリプトは、特定の機能や機能をソフトウェアに追加するために作成された個別のコードのことであり、その機能をユニークに強化します。',
                    ],
                ],

                'design' => [
                    'info'  => 'ロゴとファビコンアイコンを設定します。',
                    'title' => 'デザイン',

                    'admin-logo' => [
                        'favicon'    => 'ファビコン',
                        'logo-image' => 'ロゴ画像',
                        'title'      => '管理者ロゴ',
                        'title-info' => 'ブランディングと認識のために、ウェブサイトのフロントエンドのロゴとファビコン画像を設定します。',
                    ],
                ],

                'magic-ai' => [
                    'info'  => 'Magic AIオプションを設定します。',
                    'title' => 'Magic AI',

                    'settings' => [
                        'api-key'        => 'APIキー',
                        'enabled'        => '有効',
                        'llm-api-domain' => 'LLM APIドメイン',
                        'organization'   => '組織',
                        'title'          => '一般設定',
                        'title-info'     => 'Magic AI機能を利用するために、独占的なAPIキーを入力し、関連する組織を指定してMagic AI機能を強化します。 OpenAIの資格情報を制御し、特定のニーズに応じて設定をカスタマイズします。',
                    ],

                    'content-generation' => [
                        'category-description-prompt'      => 'カテゴリの説明プロンプト',
                        'cms-page-content-prompt'          => 'CMSページのコンテンツプロンプト',
                        'enabled'                          => '有効',
                        'product-description-prompt'       => '製品の説明プロンプト',
                        'product-short-description-prompt' => '製品の短い説明プロンプト',
                        'title'                            => 'コンテンツ生成',
                        'title-info'                       => 'この機能を有効にすると、AIを使用してコンテンツを管理するためのすべてのWYSIWYGエディタでMagic AIが有効になります。<br/><br/>有効にすると、任意のエディタに移動してコンテンツを生成できます。',
                    ],

                    'image-generation' => [
                        'enabled'    => '有効',
                        'title'      => '画像生成',
                        'title-info' => 'この機能を有効にすると、DALL-Eを使用して画像を生成するためのすべての画像アップロードでMagic AIが有効になります。<br/><br/>有効にすると、任意の画像アップロードに移動して画像を生成できます。',
                    ],

                    'review-translation' => [
                        'dolphin-phi'       => 'ドルフィンファイ',
                        'enabled'           => '有効',
                        'gpt-3-5-turbo'     => 'OpenAI gpt-3.5-turbo',
                        'llama2'            => 'Llama 2',
                        'llama2-uncensored' => 'Llama 2 Uncensored',
                        'llama2:13b'        => 'Llama 2 13B',
                        'llama2:70b'        => 'Llama 2 70B',
                        'llava'             => 'LLaVA',
                        'mistral'           => 'ミストラル',
                        'model'             => 'モデル',
                        'orca-mini'         => 'オルカミニ',
                        'phi'               => 'Phi-2',
                        'starling-lm'       => 'スターリング',
                        'title'             => 'レビュー翻訳',
                        'title-info'        => '顧客または訪問者に英語に翻訳するオプションを提供します。<br/><br/>有効にすると、レビューに移動すると、「英語に翻訳」ボタンが表示されます。',
                        'vicuna'            => 'ビクーニャ',
                    ],

                    'checkout-message' => [
                        'dolphin-phi'       => 'ドルフィンファイ',
                        'enabled'           => '有効',
                        'gpt-3-5-turbo'     => 'OpenAI gpt-3.5-turbo',
                        'llama2'            => 'Llama 2',
                        'llama2-uncensored' => 'Llama 2 Uncensored',
                        'llama2:13b'        => 'Llama 2 13B',
                        'llama2:70b'        => 'Llama 2 70B',
                        'llava'             => 'LLaVA',
                        'mistral'           => 'ミストラル',
                        'model'             => 'モデル',
                        'orca-mini'         => 'オルカミニ',
                        'phi'               => 'Phi-2',
                        'prompt'            => 'プロンプト',
                        'starling-lm'       => 'スターリング',
                        'title'             => 'パーソナライズされたチェックアウトメッセージ',
                        'title-info'        => '個別の好みに合わせてコンテンツを調整し、全体的な購入後の体験を向上させるために、お客様向けのパーソナライズされたチェックアウトメッセージを作成します。',
                        'vicuna'            => 'ビクーニャ',
                    ],
                ],
            ],

            'catalog' => [
                'info'  => 'カタログ',
                'title' => 'カタログ',

                'products' => [
                    'info'  => '製品表示ページ、カート表示ページ、店舗フロント、レビューおよび属性のソーシャル共有。',
                    'title' => '製品',

                    'settings' => [
                        'compare-options'     => '比較オプション',
                        'image-search-option' => '画像検索オプション',
                        'title'               => '設定',
                        'title-info'          => '設定は、ユーザーの好みや要件に合わせてシステム、アプリケーション、またはデバイスの動作を制御する設定可能な選択肢を指します。',
                        'wishlist-options'    => 'ウィッシュリストオプション',
                    ],

                    'search' => [
                        'admin-mode'            => '管理者検索モード',
                        'admin-mode-info'       => '管理パネルのMega Search、Datagridなどの検索機能は、選択した検索エンジンに基づいて動作します。',
                        'database'              => 'データベース',
                        'elastic'               => 'Elastic Search',
                        'max-query-length'      => '最大クエリ長',
                        'max-query-length-info' => '検索クエリの最大長を設定します。',
                        'min-query-length'      => '最小クエリ長',
                        'min-query-length-info' => '検索クエリの最小長を設定します。',
                        'search-engine'         => '検索エンジン',
                        'storefront-mode'       => 'ストアフロント検索モード',
                        'storefront-mode-info'  => 'ストアフロントの検索機能は、カテゴリページ、検索ページ、その他の検索機能を含む、選択した検索エンジンに基づいて動作します。',
                        'title'                 => '検索',
                        'title-info'            => '製品検索のための検索エンジンを設定するには、データベースとElasticsearchのいずれかを選択できます。製品が多数ある場合は、Elasticsearchが推奨されます。',
                    ],

                    'guest-checkout' => [
                        'allow-guest-checkout'      => 'ゲストチェックアウトを許可する',
                        'allow-guest-checkout-hint' => 'ヒント：オンにすると、このオプションを製品ごとに設定できます。',
                        'title'                     => 'ゲストチェックアウト',
                        'title-info'                => 'ゲストチェックアウトを許可すると、アカウントを作成せずに商品を購入できるようになり、便利で迅速な取引が可能になります。',
                    ],

                    'product-view-page' => [
                        'allow-no-of-related-products'  => '関連製品の許可数',
                        'allow-no-of-up-sells-products' => 'アップセル製品の許可数',
                        'title'                         => '製品ビューページの設定',
                        'title-info'                    => '製品ビューページの設定では、製品の表示ページのレイアウトと要素を調整し、ユーザーエクスペリエンスと情報の表示を向上させます。',
                    ],

                    'cart-view-page' => [
                        'allow-no-of-cross-sells-products' => 'クロスセル製品の許可数',
                        'title'                            => 'カートビューページの設定',
                        'title-info'                       => 'カートビューページの設定では、ショッピングカートページのアイテム、詳細、オプションを配置し、ユーザーの対話と購入フローを改善します。',
                    ],

                    'storefront' => [
                        'buy-now-button-display' => '顧客が直接商品を購入できるようにする',
                        'cheapest-first'         => '最安値順',
                        'comma-separated'        => 'カンマ区切り',
                        'default-list-mode'      => 'デフォルトのリストモード',
                        'expensive-first'        => '最高価格順',
                        'from-a-z'               => 'A-Z順',
                        'from-z-a'               => 'Z-A順',
                        'grid'                   => 'グリッド',
                        'latest-first'           => '新着順',
                        'list'                   => 'リスト',
                        'oldest-first'           => '最古順',
                        'products-per-page'      => 'ページごとの製品数',
                        'sort-by'                => '並び替え',
                        'title'                  => 'ストアフロント',
                        'title-info'             => 'ストアフロントは、オンラインショップの顧客向けインターフェースであり、シームレスなショッピング体験のために製品、カテゴリ、ナビゲーションを展示します。',
                    ],

                    'small-image' => [
                        'height'      => '高さ',
                        'placeholder' => '小さい画像のプレースホルダ',
                        'title'       => '小さい画像',
                        'title-info'  => 'ストアフロントは、オンラインショップの顧客向けインターフェースであり、製品、カテゴリ、ナビゲーションを展示します。',
                        'width'       => '幅',
                    ],

                    'medium-image' => [
                        'height'      => '高さ',
                        'placeholder' => '中サイズの画像プレースホルダ',
                        'title'       => '中サイズの画像',
                        'title-info'  => '中サイズの画像は、詳細と画面スペースのバランスをとり、一般的にビジュアルに使用されます。',
                        'width'       => '幅',
                    ],

                    'large-image' => [
                        'height'      => '高さ',
                        'placeholder' => '大きな画像のプレースホルダ',
                        'title'       => '大きな画像',
                        'title-info'  => '大きな画像は、製品やグラフィックを展示するために使用される、詳細と視覚的なインパクトを提供する高解像度の画像です。',
                        'width'       => '幅',
                    ],

                    'review' => [
                        'allow-customer-review' => '顧客レビューを許可する',
                        'allow-guest-review'    => 'ゲストレビューを許可する',
                        'display-review-count'  => '評価のレビュー数を表示します。',
                        'display-star-count'    => '評価に星の数を表示します。',
                        'summary'               => 'まとめ',
                        'title'                 => 'レビュー',
                        'title-info'            => '何かを評価または評価することで、しばしば意見やフィードバックが含まれます。',
                    ],

                    'attribute' => [
                        'file-upload-size'  => '許可されるファイルのアップロードサイズ（KB単位）',
                        'image-upload-size' => '許可される画像のアップロードサイズ（KB単位）',
                        'title'             => '属性',
                        'title-info'        => 'オブジェクトを定義し、その動作、外観、または機能に影響を与える特性またはプロパティ。',
                    ],

                    'social-share' => [
                        'title-info'                  => 'Instagram、Twitter、WhatsApp、Facebook、Pinterest、LinkedIn、およびメールを介して製品の共有を有効にするために、ソーシャルシェア設定を構成します。',
                        'title'                       => 'ソーシャルシェア',
                        'share-message'               => '共有メッセージ',
                        'share'                       => '共有',
                        'enable-social-share'         => 'ソーシャルシェアを有効にする？',
                        'enable-share-whatsapp-info'  => 'モバイルデバイスでのみWhatsapp共有リンクが表示されます。',
                        'enable-share-whatsapp'       => 'Whatsappでの共有を有効にする？',
                        'enable-share-twitter'        => 'Twitterでの共有を有効にする？',
                        'enable-share-pinterest'      => 'Pinterestでの共有を有効にする？',
                        'enable-share-linkedin'       => 'Linkedinでの共有を有効にする？',
                        'enable-share-facebook'       => 'Facebookでの共有を有効にする？',
                        'enable-share-email'          => 'メールでの共有を有効にする？',
                    ],
                ],

                'rich-snippets' => [
                    'info'  => '製品とカテゴリを設定します。',
                    'title' => 'リッチスニペット',

                    'products' => [
                        'enable'          => '有効にする',
                        'show-categories' => 'カテゴリを表示する',
                        'show-images'     => '画像を表示する',
                        'show-offers'     => 'オファーを表示する',
                        'show-ratings'    => '評価を表示する',
                        'show-reviews'    => 'レビューを表示する',
                        'show-sku'        => 'SKUを表示する',
                        'show-weight'     => '重量を表示する',
                        'title'           => '製品',
                        'title-info'      => 'SKU、重量、カテゴリ、画像、レビュー、評価、オファーなどを含む製品設定を構成する。',
                    ],

                    'categories' => [
                        'enable'                  => '有効にする',
                        'show-search-input-field' => '検索入力フィールドを表示する',
                        'title'                   => 'カテゴリ',
                        'title-info'              => '「カテゴリ」とは、似たような製品やアイテムを簡単にブラウズやナビゲーションするためにグループ化し、分類するためのグループまたは分類です。',
                    ],
                ],

                'inventory' => [
                    'title'      => '在庫',
                    'title-info' => 'バックオーダーを許可し、最小および最大のカート数量を設定し、在庫切れのしきい値を定義するための在庫設定を構成します。',

                    'product-stock-options' => [
                        'allow-back-orders'       => 'バックオーダーを許可する',
                        'max-qty-allowed-in-cart' => 'ショッピングカートで許可される最大数量',
                        'min-qty-allowed-in-cart' => 'ショッピングカートで許可される最小数量',
                        'out-of-stock-threshold'  => '在庫切れのしきい値',
                        'title'                   => '製品の在庫オプション',
                        'info'                    => '製品在庫オプションを設定して、バックオーダーを許可し、カートの最小および最大数量を設定し、在庫不足のしきい値を定義します。',
                    ],
                ],
            ],

            'customer' => [
                'info'  => '顧客',
                'title' => '顧客',

                'address' => [
                    'info'  => '国、都道府県、郵便番号、住所の行を設定します。',
                    'title' => '住所',

                    'requirements' => [
                        'city'       => '市区町村',
                        'country'    => '国',
                        'state'      => '都道府県',
                        'title'      => '要件',
                        'title-info' => '要件は、何かを達成するために必要な条件、機能、または仕様です。',
                        'zip'        => '郵便番号',
                    ],

                    'information' => [
                        'street-lines' => '住所の行',
                        'title'        => '情報',
                        'title-info'   => '「住所の行」とは、住所の個々のセグメントを指し、通常はコンマで区切られており、家番号、通り名、市区町村などの位置情報を提供します。',
                    ],
                ],

                'captcha' => [
                    'info'  => 'サイトキー、シークレットキー、ステータスを設定します。',
                    'title' => 'キャプチャ',

                    'credentials' => [
                        'secret-key' => 'シークレットキー',
                        'site-key'   => 'サイトキー',
                        'status'     => 'ステータス',
                        'title'      => '資格情報',
                        'title-info' => '「サイトマップ: 検索エンジン用のウェブサイトのレイアウトマップ。シークレットキー: データの暗号化、認証、またはAPIアクセス保護のための安全なコード。」',
                    ],

                    'validations' => [
                        'captcha'  => 'エラーが発生しました。もう一度お試しください。',
                        'required' => 'CAPTCHAを選択してください。',
                    ],
                ],

                'settings' => [
                    'settings-info' => 'ニュースレターの購読、メールの確認、ソーシャルログインを設定します。',
                    'title'         => '設定',

                    'login-as-customer' => [
                        'allow-option' => '顧客としてログインを許可する',
                        'title'        => '顧客としてログイン',
                        'title-info'   => '「顧客としてログイン」機能を有効にします。',
                    ],

                    'wishlist' => [
                        'allow-option' => 'ウィッシュリストオプションを許可する',
                        'title'        => 'ウィッシュリスト',
                        'title-info'   => 'ウィッシュリストオプションを有効または無効にします。',
                    ],

                    'login-options' => [
                        'account'          => 'アカウント',
                        'home'             => 'ホーム',
                        'redirect-to-page' => '選択したページに顧客をリダイレクトする',
                        'title'            => 'ログインオプション',
                        'title-info'       => 'ログインオプションを設定して、ログイン後の顧客のリダイレクトページを決定します。',
                    ],

                    'create-new-account-option' => [
                        'news-letter'      => 'ニュースレターを許可する',
                        'news-letter-info' => 'サインアップページでニュースレターの購読オプションを有効にします。',
                        'title'            => '新規アカウントオプション',
                        'title-info'       => '新規アカウントのオプションを設定します。デフォルトの顧客グループの割り当てや、サインアップ時のニュースレターの購読オプションを有効にするなどが含まれます。',

                        'default-group' => [
                            'general'    => '一般',
                            'guest'      => 'ゲスト',
                            'title'      => 'デフォルトグループ',
                            'title-info' => '新規顧客のデフォルトとして特定の顧客グループを割り当てます。',
                            'wholesale'  => '卸売',
                        ],
                    ],

                    'newsletter' => [
                        'subscription' => 'ニュースレターの購読を許可する',
                        'title'        => 'ニュースレターの購読',
                        'title-info'   => '「ニュースレター情報」は、定期的に購読者にメールで共有される更新情報、オファー、またはコンテンツを含み、彼らを情報提供と関与に保ちます。',
                    ],

                    'email' => [
                        'email-verification' => 'メールの確認を許可する',
                        'title'              => 'メールの確認',
                        'title-info'         => '「メールの確認」は、メールアドレスの真正性を確認するものであり、確認リンクを送信することが一般的です。アカウントのセキュリティと通信の信頼性を向上させます。',
                    ],

                    'social-login' => [
                        'enable-facebook'   => 'Facebookを有効にする',
                        'enable-github'     => 'GitHubを有効にする',
                        'enable-google'     => 'Googleを有効にする',
                        'enable-linkedin'   => 'LinkedInを有効にする',
                        'enable-twitter'    => 'Twitterを有効にする',
                        'social-login'      => 'ソーシャルログイン',
                        'social-login-info' => '「ソーシャルログイン」は、ユーザーがソーシャルメディアアカウントを使用してウェブサイトにアクセスできるようにすることで、登録とログインのプロセスを簡素化します。',
                    ],
                ],
            ],

            'email' => [
                'info'  => 'メール',
                'title' => 'メール',

                'email-settings' => [
                    'admin-email'           => '管理者メール',
                    'admin-email-tip'       => 'このチャネルの管理者のメールアドレス',
                    'admin-name'            => '管理者名',
                    'admin-name-tip'        => 'すべての管理者メールに表示される名前',
                    'admin-page-limit'      => 'デフォルトのページごとのアイテム数（管理者）',
                    'contact-email'         => '連絡先メール',
                    'contact-email-tip'     => 'メールの下部に表示されるメールアドレス',
                    'contact-name'          => '連絡先名',
                    'contact-name-tip'      => 'メールの下部に表示される名前',
                    'email-sender-name'     => 'メール送信者名',
                    'email-sender-name-tip' => '顧客の受信トレイに表示される名前',
                    'info'                  => 'メール送信者名、ショップのメールアドレス、管理者名、管理者のメールアドレスを設定します。',
                    'shop-email-from'       => 'ショップのメールアドレス',
                    'shop-email-from-tip'   => '顧客にメールを送信するためのこのチャネルのメールアドレス',
                    'title'                 => 'メール設定',
                ],

                'notifications' => [
                    'cancel-order'                                     => '注文をキャンセルした後に通知を送信する',
                    'customer'                                         => '登録後に顧客アカウントの資格情報を送信する',
                    'customer-registration-confirmation-mail-to-admin' => '顧客登録後に管理者に確認メールを送信する',
                    'info'                                             => '製品の在庫オプションを設定し、バックオーダーを許可し、カートの最小および最大数量を設定し、在庫切れのしきい値を定義します。',
                    'new-admin'                                        => '新しい注文後に管理者に確認メールを送信する',
                    'new-inventory-source'                             => '出荷作成後に在庫ソースに通知メールを送信する',
                    'new-invoice'                                      => '新しい請求書作成後に顧客に通知メールを送信する',
                    'new-order'                                        => '新しい注文後に顧客に確認メールを送信する',
                    'new-refund'                                       => '返金作成後に顧客に通知メールを送信する',
                    'new-shipment'                                     => '出荷作成後に顧客に通知メールを送信する',
                    'registration'                                     => '顧客登録後に確認メールを送信する',
                    'title'                                            => '通知',
                    'verification'                                     => '顧客登録後に確認メールを送信する',
                ],
            ],

            'sales' => [
                'info'  => '売上',
                'title' => '売上',

                'shipping-setting' => [
                    'info'  => '国、州、市、住所、郵便番号、店舗名、VAT番号、連絡先番号、および銀行の詳細など、配送設定を構成します。',
                    'title' => '配送設定',

                    'origin' => [
                        'bank-details'   => '銀行の詳細',
                        'city'           => '市',
                        'contact-number' => '連絡先番号',
                        'country'        => '国',
                        'state'          => '州',
                        'store-name'     => '店舗名',
                        'street-address' => '住所',
                        'title'          => '出荷元',
                        'title-info'     => '出荷元は、商品や製品が目的地に輸送される前に起源する場所を指します。',
                        'vat-number'     => 'VAT番号',
                        'zip'            => '郵便番号',
                    ],
                ],

                'shipping-methods' => [
                    'info'  => '無料配送、一律料金などの配送方法を設定します。',
                    'title' => '配送方法',

                    'free-shipping' => [
                        'description' => '説明',
                        'page-title'  => '無料配送',
                        'status'      => 'ステータス',
                        'title'       => 'タイトル',
                        'title-info'  => '「無料配送」とは、送料が免除され、販売者が買い手に商品を配送するための送料を負担する配送方法を指します。',
                    ],

                    'flat-rate-shipping' => [
                        'description' => '説明',
                        'page-title'  => '一律料金配送',
                        'rate'        => '料金',
                        'status'      => 'ステータス',
                        'title'       => 'タイトル',
                        'title-info'  => '一律料金配送は、パッケージの重量、サイズ、または距離に関係なく、一定の料金が請求される配送方法です。これにより、送料が簡素化され、買い手と販売者の両方にとって有利になります。',
                        'type'        => [
                            'per-order' => '注文ごと',
                            'per-unit'  => '単位ごと',
                            'title'     => 'タイプ',
                        ],
                    ],
                ],

                'payment-methods' => [
                    'accepted-currencies'            => '受け入れられる通貨',
                    'accepted-currencies-info'       => '通貨コードをカンマ区切りで追加してください。例：USD、INR、...',
                    'business-account'               => 'ビジネスアカウント',
                    'cash-on-delivery'               => '代金引換',
                    'cash-on-delivery-info'          => '代金引換は、商品やサービスを受け取った後に現金で支払う支払い方法です。',
                    'client-id'                      => 'クライアントID',
                    'client-id-info'                 => 'テストには「sb」を使用してください。',
                    'client-secret'                  => 'クライアントシークレット',
                    'client-secret-info'             => 'ここに秘密キーを追加してください',
                    'description'                    => '説明',
                    'generate-invoice'               => '注文後に自動的に請求書を生成する',
                    'generate-invoice-applicable'    => '自動請求書生成が有効な場合に適用されます',
                    'info'                           => '支払い方法の情報を設定します',
                    'instructions'                   => '指示',
                    'logo'                           => 'ロゴ',
                    'logo-information'               => '画像の解像度は55px X 45pxのようにする必要があります',
                    'mailing-address'                => '送付先',
                    'money-transfer'                 => '送金',
                    'money-transfer-info'            => '送金は、取引や送金などのさまざまな目的で、しばしば電子的に行われる、1人またはアカウントから別の人またはアカウントへの資金の移動です。',
                    'page-title'                     => '支払い方法',
                    'paid'                           => '支払済み',
                    'paypal-smart-button'            => 'PayPal',
                    'paypal-smart-button-info'       => 'PayPal Smart Button：ウェブサイトやアプリでのセキュアなマルチメソッドトランザクションのためのカスタマイズ可能なボタンを使用して、オンライン支払いを簡素化します。',
                    'paypal-standard'                => 'PayPal Standard',
                    'paypal-standard-info'           => 'PayPal Standardは、オンラインビジネス向けの基本的なPayPal支払いオプションであり、顧客がPayPalアカウントまたはクレジット/デビットカードを使用して支払いを行うことができます。',
                    'pending'                        => '保留中',
                    'pending-payment'                => '保留中の支払い',
                    'processing'                     => '処理中',
                    'sandbox'                        => 'サンドボックス',
                    'set-invoice-status'             => '請求書作成後の請求書ステータスを設定する',
                    'set-order-status'               => '請求書作成後の注文ステータスを設定する',
                    'sort-order'                     => '並べ替え順',
                    'status'                         => 'ステータス',
                    'title'                          => 'タイトル',
                ],

                'order-settings' => [
                    'info'               => '注文番号、最小注文数、バックオーダーを設定します。',
                    'title'              => '注文設定',

                    'order-number' => [
                        'generator'   => '注文番号ジェネレータ',
                        'info'        => '特定の顧客注文に割り当てられた一意の識別子で、購入プロセス全体での追跡、コミュニケーション、参照を支援します。',
                        'length'      => '注文番号の長さ',
                        'prefix'      => '注文番号のプレフィックス',
                        'suffix'      => '注文番号のサフィックス',
                        'title'       => '注文番号の設定',
                    ],

                    'minimum-order' => [
                        'description'             => '説明',
                        'enable'                  => '有効にする',
                        'include-discount-amount' => '割引額を含む',
                        'include-tax-amount'      => '税額を含む',
                        'info'                    => '注文が処理されるための最低必要数量または金額を指定する基準を設定します。',
                        'minimum-order-amount'    => '最低注文金額',
                        'title'                   => '最小注文設定',
                    ],

                    'reorder' => [
                        'admin-reorder'      => '管理者の再注文',
                        'admin-reorder-info' => '管理者ユーザーの再注文機能を有効または無効にします。',
                        'info'               => 'ショップユーザーの再注文機能を有効または無効にします。',
                        'shop-reorder'       => 'ショップの再注文',
                        'shop-reorder-info'  => 'ショップユーザーの再注文機能を有効または無効にします。',
                        'title'              => '再注文を許可する',
                    ],

                    'stock-options' => [
                        'allow-back-orders' => 'バックオーダーを許可する',
                        'info'              => '株式オプションは、株式の買い付けや売却の権利を与える投資契約であり、潜在的な利益に影響を与えます。',
                        'title'             => '株式オプション',
                    ],
                ],

                'invoice-settings' => [
                    'info'  => '請求書番号、支払条件、請求書スリップのデザイン、請求書リマインダーを設定します。',
                    'title' => '請求書設定',

                    'invoice-number' => [
                        'generator'  => '請求書番号ジェネレータ',
                        'info'       => '組織や追跡の目的で請求書に一意の識別番号を生成および割り当てるためのルールやパラメータの設定。',
                        'length'     => '請求書番号の長さ',
                        'prefix'     => '請求書番号のプレフィックス',
                        'suffix'     => '請求書番号のサフィックス',
                        'title'      => '請求書番号の設定',
                    ],

                    'payment-terms' => [
                        'due-duration'      => '支払期限',
                        'due-duration-day'  => ':due-duration 日',
                        'due-duration-days' => ':due-duration 日',
                        'info'              => '買い手が売り手に対して商品やサービスの支払いを行うべき時期や方法を定めた合意条件。',
                        'title'             => '支払条件',
                    ],

                    'pdf-print-outs' => [
                        'info'             => 'PDF印刷アウトを設定して、ヘッダーに請求書ID、注文IDを表示し、請求書のロゴを含めます。',
                        'invoice-id-info'  => '請求書ヘッダーに請求書IDを表示するように設定します。',
                        'invoice-id-title' => 'ヘッダーに請求書IDを表示',
                        'logo'             => 'ロゴ',
                        'logo-info'        => '画像の解像度は131px x 30pxであるべきです。',
                        'order-id-info'    => '請求書ヘッダーに注文IDを表示するように設定します。',
                        'order-id-title'   => 'ヘッダーに注文IDを表示',
                        'title'            => 'PDF印刷アウト',
                    ],

                    'invoice-reminders' => [
                        'info'                       => '請求書の支払いの予定または延滞を顧客に通知するために自動的に送信される通知やコミュニケーション。',
                        'interval-between-reminders' => 'リマインダー間隔',
                        'maximum-limit-of-reminders' => 'リマインダーの最大制限',
                        'title'                      => '請求書リマインダー',
                    ],
                ],

                'taxes' => [
                    'title'      => '税金',
                    'title-info' => '税金は、政府が商品、サービス、または取引に課す義務的な料金であり、販売者が徴収し当局に納付するものです。',

                    'categories' => [
                        'title'      => '税金カテゴリ',
                        'title-info' => '税金カテゴリは、商品やサービスに税率を適用するための分類であり、消費税、付加価値税、消費税などの異なる種類の税金を分類および適用するために使用されます。',
                        'product'    => '製品のデフォルト税金カテゴリ',
                        'shipping'   => '配送料税金カテゴリ',
                        'none'       => 'なし',
                    ],

                    'calculation' => [
                        'title'            => '計算設定',
                        'title-info'       => '基本価格、割引、税金、および追加料金など、商品やサービスの費用に関する詳細情報。',
                        'based-on'         => '計算基準',
                        'shipping-address' => '配送先住所',
                        'billing-address'  => '請求先住所',
                        'shipping-origin'  => '出荷元',
                        'product-prices'   => '商品価格',
                        'shipping-prices'  => '配送料',
                        'excluding-tax'    => '税抜き',
                        'including-tax'    => '税込み',
                    ],

                    'default-destination-calculation' => [
                        'default-country'   => 'デフォルトの国',
                        'default-post-code' => 'デフォルトの郵便番号',
                        'default-state'     => 'デフォルトの州',
                        'title'             => 'デフォルトの宛先計算',
                        'title-info'        => '事前定義された要因や設定に基づいて、標準または初期の宛先を自動的に決定します。',
                    ],

                    'shopping-cart' => [
                        'title'                   => 'ショッピングカートの表示設定',
                        'title-info'              => 'ショッピングカートでの税金の表示を設定します',
                        'display-prices'          => '価格の表示',
                        'display-subtotal'        => '小計の表示',
                        'display-shipping-amount' => '配送料の表示',
                        'excluding-tax'           => '税抜き',
                        'including-tax'           => '税込み',
                        'both'                    => '税抜きと税込みの両方',
                    ],

                    'sales' => [
                        'title'                   => '注文、請求書、返金の表示設定',
                        'title-info'              => '注文、請求書、返金での税金の表示を設定します',
                        'display-prices'          => '価格の表示',
                        'display-subtotal'        => '小計の表示',
                        'display-shipping-amount' => '配送料の表示',
                        'excluding-tax'           => '税抜き',
                        'including-tax'           => '税込み',
                        'both'                    => '税抜きと税込みの両方',
                    ],
                ],

                'checkout' => [
                    'title' => 'チェックアウト',
                    'info'  => 'ゲストチェックアウトを設定、ミニカートを有効または無効にする、カートの概要。',

                    'shopping-cart' => [
                        'cart-page'              => 'カートページ',
                        'cart-page-info'         => 'ユーザーのショッピング体験を向上させるために、カートページの表示を制御します。',
                        'cross-sell'             => 'クロスセル商品',
                        'cross-sell-info'        => '追加の販売機会を増やすために、クロスセル商品を有効にします。',
                        'estimate-shipping'      => '配送料の見積もり',
                        'estimate-shipping-info' => '見積もり配送料を有効にして、事前に配送料を提供します。',
                        'guest-checkout'         => 'ゲストチェックアウトを許可する',
                        'guest-checkout-info'    => '迅速で手間のかからない購入プロセスのために、ゲストチェックアウトを有効にします。',
                        'info'                   => 'ゲストチェックアウト、カートページ、クロスセル商品、および見積もり配送料を有効にして、ユーザーの利便性を向上させ、販売を促進します。',
                        'title'                  => 'ショッピングカート',
                    ],

                    'my-cart' => [
                        'display-item-quantities' => 'アイテムの数量を表示',
                        'display-number-in-cart'  => 'カート内のアイテム数を表示',
                        'info'                    => 'マイカートの設定を有効にして、アイテムの数量の概要を表示し、カート内の総アイテム数を表示して追跡を容易にします。',
                        'summary'                 => '概要',
                        'title'                   => 'マイカート',
                    ],

                    'mini-cart' => [
                        'display-mini-cart'    => 'ミニカートの表示',
                        'info'                 => 'ミニカートの設定を有効にして、ミニカートを表示し、ミニカートのオファー情報を表示してカートの詳細とプロモーションに簡単にアクセスできるようにします。',
                        'mini-cart-offer-info' => 'ミニカートのオファー情報',
                        'title'                => 'ミニカート',
                    ],
                ],
            ],
        ],
    ],

    'components' => [
        'layouts' => [
            'header' => [
                'account-title' => 'アカウント',
                'app-version'   => 'バージョン : :version',
                'logout'        => 'ログアウト',
                'my-account'    => 'マイアカウント',
                'notifications' => '通知',
                'visit-shop'    => 'ショップを訪問',

                'mega-search' => [
                    'categories'                      => 'カテゴリ',
                    'customers'                       => '顧客',
                    'explore-all-categories'          => 'すべてのカテゴリを探索',
                    'explore-all-customers'           => 'すべての顧客を探索',
                    'explore-all-matching-categories' => '“:query” (:count) に一致するすべてのカテゴリを探索',
                    'explore-all-matching-customers'  => '“:query” (:count) に一致するすべての顧客を探索',
                    'explore-all-matching-orders'     => '“:query” (:count) に一致するすべての注文を探索',
                    'explore-all-matching-products'   => '“:query” (:count) に一致するすべての製品を探索',
                    'explore-all-orders'              => 'すべての注文を探索',
                    'explore-all-products'            => 'すべての製品を探索',
                    'orders'                          => '注文',
                    'products'                        => '製品',
                    'sku'                             => 'SKU: :sku',
                    'title'                           => 'メガ検索',
                ],
            ],

            'sidebar' => [
                'attribute-families'       => '属性ファミリー',
                'attributes'               => '属性',
                'campaigns'                => 'キャンペーン',
                'catalog'                  => 'カタログ',
                'categories'               => 'カテゴリ',
                'channels'                 => 'チャネル',
                'cms'                      => 'CMS',
                'collapse'                 => '折りたたむ',
                'communications'           => 'コミュニケーション',
                'configure'                => '設定',
                'currencies'               => '通貨',
                'customers'                => '顧客',
                'dashboard'                => 'ダッシュボード',
                'data-transfer'            => 'Data Transfer',
                'discount'                 => '割引',
                'email-templates'          => 'メールテンプレート',
                'events'                   => 'イベント',
                'exchange-rates'           => '為替レート',
                'groups'                   => 'グループ',
                'imports'                  => '輸入品',
                'inventory-sources'        => '在庫ソース',
                'invoices'                 => '請求書',
                'locales'                  => 'ロケール',
                'marketing'                => 'マーケティング',
                'mode'                     => 'ダークモード',
                'newsletter-subscriptions' => 'ニュースレターの購読',
                'orders'                   => '注文',
                'products'                 => '製品',
                'promotions'               => 'プロモーション',
                'refunds'                  => '返金',
                'reporting'                => 'レポート',
                'reviews'                  => 'レビュー',
                'roles'                    => 'ロール',
                'sales'                    => '販売',
                'search-seo'               => '検索とSEO',
                'search-synonyms'          => '検索の同義語',
                'search-terms'             => '検索用語',
                'settings'                 => '設定',
                'shipments'                => '発送',
                'sitemaps'                 => 'サイトマップ',
                'tax-categories'           => '税カテゴリ',
                'tax-rates'                => '税率',
                'taxes'                    => '税金',
                'themes'                   => 'テーマ',
                'transactions'             => '取引',
                'url-rewrites'             => 'URL書き換え',
                'users'                    => 'ユーザー',
            ],
        ],

        'datagrid' => [
            'toolbar' => [
                'length-of' => ':length の',
                'of'        => 'の',
                'per-page'  => 'ページあたり',
                'results'   => ':total 結果',
                'selected'  => ':total 選択されました',

                'index' => [
                    'no-records-selected'              => 'レコードは選択されていません。',
                    'must-select-a-mass-action-option' => '一括操作のオプションを選択する必要があります。',
                    'must-select-a-mass-action'        => '一括操作を選択する必要があります。',
                ],

                'mass-actions' => [
                    'submit'        => '送信',
                    'select-option' => 'オプションを選択',
                    'select-action' => 'アクションを選択',
                ],

                'filter' => [
                    'apply-filters-btn' => 'フィルタを適用する',
                    'back-btn'          => '戻る',
                    'create-new-filter' => '新しいフィルターを作成',
                    'custom-filters'    => 'カスタムフィルター',
                    'delete-error'      => 'フィルターの削除中に問題が発生しました。もう一度お試しください。',
                    'delete-success'    => 'フィルターは正常に削除されました。',
                    'empty-description' => '保存する選択されたフィルターはありません。保存するフィルターを選択してください。',
                    'empty-title'       => '保存するフィルターを追加',
                    'name'              => '名前',
                    'quick-filters'     => 'クイックフィルター',
                    'save-btn'          => '保存',
                    'save-filter'       => 'フィルターを保存',
                    'saved-success'     => 'フィルターは正常に保存されました。',
                    'selected-filters'  => '選択したフィルター',
                    'title'             => 'フィルター',
                    'update'            => '更新',
                    'update-filter'     => 'フィルターを更新',
                    'updated-success'   => 'フィルターが正常に更新されました',
                ],

                'search' => [
                    'title' => '検索',
                ],
            ],

            'filters' => [
                'select' => '選択',
                'title'  => 'フィルター',

                'dropdown' => [
                    'searchable' => [
                        'atleast-two-chars' => '少なくとも2文字を入力してください...',
                        'no-results'        => '結果が見つかりませんでした...',
                    ],
                ],

                'custom-filters' => [
                    'clear-all' => 'すべてクリア',
                    'title'     => 'カスタムフィルター',
                ],

                'boolean-options' => [
                    'false' => '偽',
                    'true'  => '真',
                ],

                'date-options' => [
                    'last-month'        => '先月',
                    'last-six-months'   => '過去6か月',
                    'last-three-months' => '過去3か月',
                    'this-month'        => '今月',
                    'this-week'         => '今週',
                    'this-year'         => '今年',
                    'today'             => '今日',
                    'yesterday'         => '昨日',
                ],
            ],

            'table' => [
                'actions'              => 'アクション',
                'no-records-available' => '利用可能なレコードはありません。',
            ],
        ],

        'modal' => [
            'confirm' => [
                'agree-btn'    => '同意',
                'disagree-btn' => '同意しない',
                'message'      => 'この操作を実行してもよろしいですか？',
                'title'        => '本当によろしいですか？',
            ],
        ],

        'products' => [
            'search' => [
                'add-btn'       => '選択した製品を追加',
                'empty-info'    => '検索語に該当する製品はありません。',
                'empty-title'   => '製品が見つかりませんでした',
                'product-image' => '製品画像',
                'qty'           => ':qty 利用可能',
                'sku'           => 'SKU - :sku',
                'title'         => '製品を選択',
            ],
        ],

        'media' => [
            'images' => [
                'add-image-btn'     => '画像を追加',
                'ai-add-image-btn'  => 'マジックAI',
                'ai-btn-info'       => '画像生成',
                'allowed-types'     => 'png、jpeg、jpg',
                'not-allowed-error' => '画像ファイル（.jpeg、.jpg、.png、..）のみ許可されています。',

                'ai-generation' => [
                    '1024x1024'        => '1024x1024',
                    '1024x1792'        => '1024x1792',
                    '1792x1024'        => '1792x1024',
                    'apply'            => '適用',
                    'dall-e-2'         => 'Dall.E 2',
                    'dall-e-3'         => 'Dall.E 3',
                    'generate'         => '生成',
                    'generating'       => '生成中...',
                    'hd'               => 'HD',
                    'model'            => 'モデル',
                    'number-of-images' => '画像の数',
                    'prompt'           => 'プロンプト',
                    'quality'          => '品質',
                    'regenerate'       => '再生成',
                    'regenerating'     => '再生成中...',
                    'size'             => 'サイズ',
                    'standard'         => '標準',
                    'title'            => 'AI画像生成',
                ],

                'placeholders' => [
                    'front'     => '前面',
                    'next'      => '次',
                    'size'      => 'サイズ',
                    'use-cases' => '用途',
                    'zoom'      => 'ズーム',
                ],
            ],

            'videos' => [
                'add-video-btn'     => 'ビデオを追加',
                'allowed-types'     => 'mp4、webm、mkv',
                'not-allowed-error' => 'ビデオファイルのみ許可されています（.mp4、.mov、.ogg ..）。',
            ],
        ],

        'tinymce' => [
            'ai-btn-tile' => 'マジックAI',

            'ai-generation' => [
                'apply'                  => '適用',
                'dolphin-phi'            => 'Dolphin Phi',
                'generate'               => '生成',
                'generated-content'      => '生成されたコンテンツ',
                'generated-content-info' => 'AIによるコンテンツは誤解を招く可能性があります。適用する前に生成されたコンテンツを確認してください。',
                'generating'             => '生成中...',
                'gpt-3-5-turbo'          => 'OpenAI GPT-3.5 Turbo',
                'llama2'                 => 'Llama 2',
                'llama2-uncensored'      => 'Llama 2 センシャードなし',
                'llama2:13b'             => 'Llama 2 13B',
                'llama2:70b'             => 'Llama 2 70B',
                'llava'                  => 'LLaVA',
                'mistral'                => 'Mistral',
                'model'                  => 'モデル',
                'orca-mini'              => 'Orca Mini',
                'phi'                    => 'Phi-2',
                'prompt'                 => 'プロンプト',
                'starling-lm'            => 'Starling',
                'title'                  => 'AIアシスタンス',
                'vicuna'                 => 'Vicuna',
            ],
        ],
    ],

    'acl' => [
        'addresses'                => '住所',
        'attribute-families'       => '属性ファミリー',
        'attributes'               => '属性',
        'campaigns'                => 'キャンペーン',
        'cancel'                   => 'キャンセル',
        'cart-rules'               => 'カートルール',
        'catalog-rules'            => 'カタログルール',
        'catalog'                  => 'カタログ',
        'categories'               => 'カテゴリー',
        'channels'                 => 'チャネル',
        'cms'                      => 'CMS',
        'communications'           => 'コミュニケーション',
        'configure'                => '設定',
        'copy'                     => 'コピー',
        'create'                   => '作成する',
        'currencies'               => '通貨',
        'customers'                => '顧客',
        'dashboard'                => 'ダッシュボード',
        'data-transfer'            => 'データ転送',
        'delete'                   => '削除',
        'edit'                     => '編集',
        'email-templates'          => 'Eメールテンプレート',
        'events'                   => 'イベント',
        'exchange-rates'           => '為替レート',
        'groups'                   => 'グループ',
        'import'                   => '輸入',
        'imports'                  => '輸入品',
        'inventory-sources'        => '在庫ソース',
        'invoices'                 => '請求書',
        'locales'                  => 'ロケール',
        'marketing'                => 'マーケティング',
        'newsletter-subscriptions' => 'ニュースレター購読',
        'note'                     => 'メモ',
        'orders'                   => '注文',
        'products'                 => '製品',
        'promotions'               => 'プロモーション',
        'refunds'                  => '返金',
        'reporting'                => '報告',
        'reviews'                  => 'レビュー',
        'roles'                    => '役割',
        'sales'                    => '販売',
        'search-seo'               => '検索とSEO',
        'search-synonyms'          => '検索の同義語',
        'search-terms'             => '検索用語',
        'settings'                 => '設定',
        'shipments'                => '出荷',
        'sitemaps'                 => 'サイトマップ',
        'subscribers'              => 'ニュースレター購読者',
        'tax-categories'           => '税カテゴリー',
        'tax-rates'                => '税率',
        'taxes'                    => '税金',
        'themes'                   => 'テーマ',
        'transactions'             => '取引',
        'url-rewrites'             => 'URL書き換え',
        'users'                    => 'ユーザー',
        'view'                     => '表示',
    ],

    'errors' => [
        'dashboard' => 'ダッシュボード',
        'go-back'   => '戻る',
        'support'   => '問題が解決しない場合、<a href=":link" class=":class">:email</a> までお問い合わせください。',

        '404' => [
            'description' => 'おっと！探しているページは休暇中のようです。お探しのものが見つからないようです。',
            'title'       => '404 ページが見つかりません',
        ],

        '401' => [
            'description' => 'おっと！このページにアクセスする権限がありません。必要な資格情報が不足しているようです。',
            'title'       => '401 認証エラー',
        ],

        '403' => [
            'description' => 'おっと！このページへのアクセスは制限されています。必要なアクセス権限がないようです。',
            'title'       => '403 アクセス拒否',
        ],

        '500' => [
            'description' => 'おっと！何か問題が発生しました。お探しのページを読み込むのに問題があるようです。',
            'title'       => '500 サーバーエラー',
        ],

        '503' => [
            'description' => 'おっと！一時的にメンテナンス中のようです。少し後で再度ご確認ください。',
            'title'       => '503 サービス利用不可',
        ],
    ],

    'export' => [
        'csv'        => 'CSV',
        'download'   => 'ダウンロード',
        'export'     => 'エクスポート',
        'no-records' => 'エクスポート対象がありません',
        'xls'        => 'XLS',
        'xlsx'       => 'XLSX',
    ],

    'validations' => [
        'slug-being-used' => 'このスラッグはカテゴリまたは製品で使用されています。',
        'slug-reserved'   => 'このスラッグは予約済みです。',
    ],

    'footer' => [
        'copy-right' => '搭載 <a href="https://bagisto.com/" target="_blank">Bagisto</a>, Webkulによるコミュニティプロジェクト<a href="https://webkul.com/" target="_blank">Webkul</a>',
    ],

    'emails' => [
        'dear'   => '尊敬する :admin_name さん',
        'thanks' => '何かお手伝いが必要な場合は、<a href=":link" style=":style">:email</a> でお問い合わせいただくか、ご連絡ください。<br/>ありがとうございます！',

        'admin' => [
            'forgot-password' => [
                'description'    => 'このメールは、アカウントのパスワードリセットリクエストを受けたため、お送りしています。',
                'greeting'       => 'パスワードを忘れました！',
                'reset-password' => 'パスワードをリセット',
                'subject'        => 'パスワードリセットメール',
            ],
        ],

        'customers' => [
            'registration' => [
                'description' => '新しい顧客アカウントが正常に作成されました。 これで、電子メール アドレスとパスワードの資格情報を使用してログインできるようになります。 ログインすると、過去の注文の確認、ウィッシュリストの管理、アカウント情報の更新など、さまざまなサービスにアクセスできるようになります。',
                'greeting'    => '私たちに登録したばかりの新しい顧客、:customer_name を温かく歓迎します。',
                'subject'     => '新規顧客登録',
            ],
        ],

        'orders' => [
            'created' => [
                'greeting' => ':created_at に注文 #:order_id が新しく受け付けられました',
                'subject'  => '新しい注文確認',
                'summary'  => '注文の要約',
                'title'    => '注文確認！',
            ],

            'invoiced' => [
                'greeting' => ':created_at に注文 #:order_id の請求書 #:invoice_id が作成されました',
                'subject'  => '新しい請求書確認',
                'summary'  => '請求書の要約',
                'title'    => '請求書確認！',
            ],

            'shipped' => [
                'greeting' => ':created_at に注文 #:order_id が発送されました',
                'subject'  => '新しい出荷確認',
                'summary'  => '出荷の要約',
                'title'    => '出荷確認！',
            ],

            'inventory-source' => [
                'greeting' => ':created_at に注文 #:order_id が発送されました',
                'subject'  => '新しい出荷確認',
                'summary'  => '出荷の要約',
                'title'    => '出荷確認！',
            ],

            'refunded' => [
                'greeting' => ':created_at に注文 #:order_id の払い戻しが行われました',
                'subject'  => '新しい払い戻し確認',
                'summary'  => '払い戻しの要約',
                'title'    => '払い戻し確認！',
            ],

            'canceled' => [
                'greeting' => ':created_at に注文 #:order_id がキャンセルされました',
                'subject'  => '新しい注文キャンセル',
                'summary'  => '注文の要約',
                'title'    => '注文キャンセル！',
            ],

            'billing-address'            => '請求先住所',
            'carrier'                    => 'キャリア',
            'contact'                    => '連絡先',
            'discount'                   => '割引',
            'excl-tax'                   => '税抜き: ',
            'grand-total'                => '総計',
            'name'                       => '名前',
            'payment'                    => '支払い',
            'price'                      => '価格',
            'qty'                        => '数量',
            'shipping-address'           => '配送先住所',
            'shipping-handling-excl-tax' => '送料 (税抜き)',
            'shipping-handling-incl-tax' => '送料 (税込み)',
            'shipping-handling'          => '送料',
            'shipping'                   => '配送',
            'sku'                        => 'SKU',
            'subtotal-excl-tax'          => '小計 (税抜き)',
            'subtotal-incl-tax'          => '小計 (税込み)',
            'subtotal'                   => '小計',
            'tax'                        => '税金',
            'tracking-number'            => '追跡番号: :tracking_number',
        ],
    ],
];
